/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.BeginExp;
import gnu.expr.BlockExp;
import gnu.expr.CatchClause;
import gnu.expr.ClassExp;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.FluidLetExp;
import gnu.expr.IfExp;
import gnu.expr.LambdaExp;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.expr.ReferenceExp;
import gnu.expr.ScopeExp;
import gnu.expr.SetExp;
import gnu.expr.SynchronizedExp;
import gnu.expr.TryExp;
import gnu.kawa.functions.AppendValues;
import java.util.HashSet;

public class FindTailCalls
extends ExpWalker {
    Expression returnContinuation;

    public static void findTailCalls(Expression exp, Compilation comp) {
        FindTailCalls walker = new FindTailCalls();
        walker.setContext(comp);
        walker.walk(exp);
    }

    public boolean inTailContext() {
        return this.returnContinuation == this.currentLambda.body;
    }

    protected Expression walkExpression(Expression exp) {
        Expression saveContext = this.returnContinuation;
        this.returnContinuation = exp;
        Expression ret = super.walkExpression(exp);
        this.returnContinuation = saveContext;
        return ret;
    }

    public Expression[] walkExps(Expression[] exps, int n) {
        Expression saveContext = this.returnContinuation;
        for (int i = 0; i < n; ++i) {
            Expression expi;
            this.returnContinuation = expi = exps[i];
            exps[i] = this.walk(expi);
        }
        this.returnContinuation = saveContext;
        return exps;
    }

    protected Expression walkApplyExp(ApplyExp exp) {
        boolean inTailContext = this.inTailContext();
        if (inTailContext) {
            exp.setTailCall(true);
        }
        exp.context = this.currentLambda;
        LambdaExp lexp = null;
        boolean isAppendValues = false;
        if (exp.func instanceof ReferenceExp) {
            ReferenceExp func = (ReferenceExp)exp.func;
            Declaration binding = Declaration.followAliases(func.binding);
            if (binding != null) {
                Expression value;
                if (!binding.getFlag(2048L)) {
                    exp.nextCall = binding.firstCall;
                    binding.firstCall = exp;
                }
                Compilation comp = this.getCompilation();
                binding.setCanCall();
                if (!comp.mustCompile) {
                    binding.setCanRead();
                }
                if ((value = binding.getValue()) instanceof LambdaExp) {
                    lexp = (LambdaExp)value;
                }
            }
        } else if (exp.func instanceof LambdaExp && !(exp.func instanceof ClassExp)) {
            lexp = (LambdaExp)exp.func;
            this.walkLambdaExp(lexp, false);
            lexp.setCanCall(true);
        } else if (exp.func instanceof QuoteExp && ((QuoteExp)exp.func).getValue() == AppendValues.appendValues) {
            isAppendValues = true;
        } else {
            Expression saveContext = this.returnContinuation;
            this.returnContinuation = exp.func;
            exp.func = exp.func.walk(this);
            this.returnContinuation = saveContext;
        }
        if (!(lexp == null || lexp.returnContinuation == this.returnContinuation || lexp == this.currentLambda && inTailContext)) {
            if (inTailContext) {
                if (lexp.tailCallers == null) {
                    lexp.tailCallers = new HashSet<LambdaExp>();
                }
                lexp.tailCallers.add(this.currentLambda);
            } else if (lexp.returnContinuation == null) {
                lexp.returnContinuation = this.returnContinuation;
                lexp.inlineHome = this.currentLambda;
            } else {
                lexp.returnContinuation = LambdaExp.unknownContinuation;
                lexp.inlineHome = null;
            }
        }
        exp.args = this.walkExps(exp.args);
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkBlockExp(BlockExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            exp.body = exp.body.walk(this);
            if (exp.exitBody != null) {
                this.returnContinuation = exp.exitBody;
                exp.exitBody = exp.exitBody.walk(this);
            }
            BlockExp blockExp = exp;
            return blockExp;
        }
        finally {
            this.returnContinuation = saveContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkBeginExp(BeginExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            int n = exp.length - 1;
            for (int i = 0; i <= n; ++i) {
                this.returnContinuation = i == n ? saveContext : exp.exps[i];
                exp.exps[i] = exp.exps[i].walk(this);
            }
            BeginExp beginExp = exp;
            return beginExp;
        }
        finally {
            this.returnContinuation = saveContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkFluidLetExp(FluidLetExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            decl.setCanRead(true);
            if (decl.base == null) continue;
            decl.base.setCanRead(true);
        }
        Expression saveContext = this.returnContinuation;
        try {
            this.walkLetDecls(exp);
            this.returnContinuation = exp.body;
            exp.body = exp.body.walk(this);
        }
        finally {
            this.returnContinuation = saveContext;
        }
        this.postWalkDecls(exp);
        return exp;
    }

    void walkLetDecls(LetExp exp) {
        Declaration decl = exp.firstDecl();
        int n = exp.inits.length;
        int i = 0;
        while (i < n) {
            Expression value;
            Expression init = this.walkSetExp(decl, exp.inits[i]);
            if (init == QuoteExp.undefined_exp && ((value = decl.getValue()) instanceof LambdaExp || value != init && value instanceof QuoteExp)) {
                init = value;
            }
            exp.inits[i] = init;
            ++i;
            decl = decl.nextDecl();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkLetExp(LetExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            this.walkLetDecls(exp);
        }
        finally {
            this.returnContinuation = saveContext;
        }
        exp.body = exp.body.walk(this);
        this.postWalkDecls(exp);
        return exp;
    }

    public void postWalkDecls(ScopeExp exp) {
        for (Declaration decl = exp.firstDecl(); decl != null; decl = decl.nextDecl()) {
            ReferenceExp rexp;
            Declaration context;
            Expression value = decl.getValue();
            if (value instanceof LambdaExp) {
                LambdaExp lexp = (LambdaExp)value;
                if (decl.getCanRead()) {
                    lexp.setCanRead(true);
                }
                if (decl.getCanCall()) {
                    lexp.setCanCall(true);
                }
            }
            if (!decl.getFlag(1024L) || !(value instanceof ReferenceExp) || (context = (rexp = (ReferenceExp)value).contextDecl()) == null || !context.isPrivate()) continue;
            context.setFlag(524288L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkIfExp(IfExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            this.returnContinuation = exp.test;
            exp.test = exp.test.walk(this);
        }
        finally {
            this.returnContinuation = saveContext;
        }
        exp.then_clause = exp.then_clause.walk(this);
        Expression else_clause = exp.else_clause;
        if (else_clause != null) {
            exp.else_clause = else_clause.walk(this);
        }
        return exp;
    }

    protected Expression walkLambdaExp(LambdaExp exp) {
        this.walkLambdaExp(exp, true);
        return exp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void walkLambdaExp(LambdaExp exp, boolean canRead) {
        Expression saveContext = this.returnContinuation;
        this.returnContinuation = exp;
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        if (canRead) {
            exp.setCanRead(true);
        }
        try {
            this.returnContinuation = exp;
            if (exp.defaultArgs != null) {
                exp.defaultArgs = this.walkExps(exp.defaultArgs);
            }
            Expression expression = this.returnContinuation = exp.getInlineOnly() ? saveContext : exp.body;
            if (this.exitValue == null && exp.body != null) {
                exp.body = exp.body.walk(this);
            }
        }
        finally {
            this.returnContinuation = saveContext;
            this.currentLambda = parent;
        }
        this.postWalkDecls(exp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkClassExp(ClassExp exp) {
        Expression saveContext = this.returnContinuation;
        this.returnContinuation = exp;
        LambdaExp parent = this.currentLambda;
        this.currentLambda = exp;
        try {
            LambdaExp child = exp.firstChild;
            while (child != null && this.exitValue == null) {
                this.walkLambdaExp(child, false);
                child = child.nextSibling;
            }
        }
        finally {
            this.returnContinuation = saveContext;
            this.currentLambda = parent;
        }
        return exp;
    }

    protected Expression walkReferenceExp(ReferenceExp exp) {
        Declaration ctx;
        Declaration decl = Declaration.followAliases(exp.binding);
        if (decl != null) {
            Type type = decl.type;
            if (type != null && type.isVoid()) {
                return QuoteExp.voidExp;
            }
            decl.setCanRead(true);
        }
        if ((ctx = exp.contextDecl()) != null) {
            ctx.setCanRead(true);
        }
        return exp;
    }

    final Expression walkSetExp(Declaration decl, Expression value) {
        this.returnContinuation = value;
        if (decl != null && decl.getValue() == value && value instanceof LambdaExp && !(value instanceof ClassExp) && !decl.isPublic()) {
            LambdaExp lexp = (LambdaExp)value;
            this.walkLambdaExp(lexp, false);
            return lexp;
        }
        return value.walk(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkSetExp(SetExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            Declaration ctx;
            Declaration decl = exp.binding;
            if (decl != null && decl.isAlias()) {
                if (exp.isDefining()) {
                    this.returnContinuation = exp.new_value;
                    exp.new_value = exp.new_value.walk(this);
                    SetExp setExp = exp;
                    return setExp;
                }
                decl = Declaration.followAliases(decl);
            }
            if ((ctx = exp.contextDecl()) != null) {
                ctx.setCanRead(true);
            }
            Expression value = this.walkSetExp(decl, exp.new_value);
            if (decl != null && decl.context instanceof LetExp && value == decl.getValue() && (value instanceof LambdaExp || value instanceof QuoteExp)) {
                QuoteExp quoteExp = QuoteExp.voidExp;
                return quoteExp;
            }
            exp.new_value = value;
            SetExp setExp = exp;
            return setExp;
        }
        finally {
            this.returnContinuation = saveContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkTryExp(TryExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            if (exp.finally_clause != null) {
                this.returnContinuation = exp.try_clause;
            }
            exp.try_clause = exp.try_clause.walk(this);
            for (CatchClause catch_clause = exp.catch_clauses; this.exitValue == null && catch_clause != null; catch_clause = catch_clause.getNext()) {
                if (exp.finally_clause != null) {
                    this.returnContinuation = catch_clause.body;
                }
                catch_clause.body = catch_clause.body.walk(this);
            }
            Expression finally_clause = exp.finally_clause;
            if (finally_clause != null) {
                this.returnContinuation = finally_clause;
                exp.finally_clause = finally_clause.walk(this);
            }
            TryExp tryExp = exp;
            return tryExp;
        }
        finally {
            this.returnContinuation = saveContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Expression walkSynchronizedExp(SynchronizedExp exp) {
        Expression saveContext = this.returnContinuation;
        try {
            this.returnContinuation = exp.object;
            exp.object = exp.object.walk(this);
            this.returnContinuation = exp.body;
            exp.body = exp.body.walk(this);
            SynchronizedExp synchronizedExp = exp;
            return synchronizedExp;
        }
        finally {
            this.returnContinuation = saveContext;
        }
    }
}

