/*
 * Decompiled with CFR 0.152.
 */
package gnu.xquery.util;

import gnu.bytecode.ClassType;
import gnu.bytecode.Type;
import gnu.expr.ApplyExp;
import gnu.expr.ErrorExp;
import gnu.expr.Expression;
import gnu.expr.InlineCalls;
import gnu.expr.QuoteExp;
import gnu.kawa.xml.XDataType;
import gnu.mapping.Procedure;
import gnu.math.IntNum;
import gnu.xquery.lang.XQuery;
import gnu.xquery.util.BooleanValue;
import gnu.xquery.util.Compare;

public class CompileMisc {
    public static Expression inlineCompare(ApplyExp exp, InlineCalls walker, boolean argsInlined, Procedure proc) {
        exp.walkArgs(walker, argsInlined);
        Expression folded = exp.inlineIfConstant(proc, walker);
        if (folded != exp) {
            return folded;
        }
        Compare cproc = (Compare)proc;
        if ((cproc.flags & 0x20) == 0) {
            exp = new ApplyExp(ClassType.make("gnu.xquery.util.Compare").getDeclaredMethod("apply", 4), new Expression[]{new QuoteExp(IntNum.make(cproc.flags)), exp.getArg(0), exp.getArg(1), QuoteExp.nullExp});
        }
        if (exp.getTypeRaw() == null) {
            exp.setType(XDataType.booleanType);
        }
        return exp;
    }

    public static Expression inlineBooleanValue(ApplyExp exp, InlineCalls walker, boolean argsInlined, Procedure proc) {
        exp.walkArgs(walker, argsInlined);
        Expression[] args = exp.getArgs();
        if (args.length == 1) {
            Expression arg = args[0];
            Type type = arg.getType();
            if (type == XDataType.booleanType) {
                return arg;
            }
            if (type == null) {
                exp.setType(XDataType.booleanType);
            }
            if (arg instanceof QuoteExp) {
                Object value = ((QuoteExp)arg).getValue();
                try {
                    return BooleanValue.booleanValue(value) ? XQuery.trueExp : XQuery.falseExp;
                }
                catch (Throwable ex) {
                    String message = "cannot convert to a boolean";
                    walker.getMessages().error('e', message);
                    return new ErrorExp(message);
                }
            }
        }
        return exp;
    }

    public static Expression inlineArithOp(ApplyExp exp, InlineCalls walker, boolean argsInlined, Procedure proc) {
        exp.walkArgs(walker, argsInlined);
        return exp;
    }
}

