/*
 * Decompiled with CFR 0.152.
 */
package gnu.expr;

import gnu.bytecode.ClassType;
import gnu.bytecode.CodeAttr;
import gnu.bytecode.Variable;
import gnu.expr.Compilation;
import gnu.expr.Declaration;
import gnu.expr.ExpWalker;
import gnu.expr.Expression;
import gnu.expr.ScopeExp;
import gnu.expr.Target;
import gnu.mapping.OutPort;

public class CatchClause
extends ScopeExp {
    Expression body;
    CatchClause next;

    public CatchClause(Object object2, ClassType classType) {
        this.addDeclaration(object2, classType);
    }

    public final CatchClause getNext() {
        return this.next;
    }

    public final void setNext(CatchClause catchClause) {
        this.next = catchClause;
    }

    public final Expression getBody() {
        return this.body;
    }

    public final void setBody(Expression expression) {
        this.body = expression;
    }

    public void compile(Compilation compilation, Target target) {
        CodeAttr codeAttr = compilation.getCode();
        Declaration declaration = this.firstDecl();
        Variable variable = declaration.allocateVariable(codeAttr);
        codeAttr.enterScope(this.scope);
        codeAttr.emitCatchStart(variable);
        this.body.compileWithPosition(compilation, target);
        codeAttr.emitCatchEnd();
        codeAttr.popScope();
    }

    protected void walkChildren(ExpWalker expWalker) {
        this.body = expWalker.walk(this.body);
    }

    public void print(OutPort outPort) {
        outPort.print("(Catch ? ");
        this.body.print(outPort);
        outPort.print(")");
    }
}

