/*
 * Decompiled with CFR 0.152.
 */
package kawa.standard;

import gnu.expr.Declaration;
import gnu.expr.Expression;
import gnu.expr.LetExp;
import gnu.expr.QuoteExp;
import gnu.lists.LList;
import gnu.lists.Pair;
import gnu.mapping.Printable;
import java.io.Externalizable;
import kawa.lang.Macro;
import kawa.lang.Syntax;
import kawa.lang.Translator;

public class let_syntax
extends Syntax
implements Printable {
    boolean recursive;

    public let_syntax(boolean bl) {
        this.recursive = bl;
    }

    public Expression rewrite(Object object2, Translator translator) {
        Object object3;
        Externalizable externalizable;
        if (!(object2 instanceof Pair)) {
            return translator.syntaxError("missing let-syntax arguments");
        }
        Pair pair = (Pair)object2;
        Object object4 = pair.car;
        Object object5 = pair.cdr;
        int n = LList.length(object4);
        Expression[] expressionArray = new Expression[n];
        Declaration[] declarationArray = new Declaration[n];
        Macro[] macroArray = new Macro[n];
        Object[] objectArray = new Object[n];
        LetExp letExp = new LetExp(expressionArray);
        int n2 = 0;
        while (n2 < n) {
            externalizable = (Pair)object4;
            if (!(externalizable.car instanceof Pair)) {
                return translator.syntaxError("let binding is not a pair");
            }
            Pair pair2 = (Pair)externalizable.car;
            if (!(pair2.car instanceof String)) {
                return translator.syntaxError("variable in let binding is not a symbol");
            }
            object3 = (String)pair2.car;
            if (!(pair2.cdr instanceof Pair)) {
                return translator.syntaxError("let has no value for '" + (String)object3 + "'");
            }
            pair2 = (Pair)pair2.cdr;
            if (pair2.cdr != LList.Empty) {
                return translator.syntaxError("let binding for '" + (String)object3 + "' is improper list");
            }
            declarationArray[n2] = new Declaration(object3);
            macroArray[n2] = Macro.make(declarationArray[n2]);
            objectArray[n2] = pair2.car;
            letExp.addDeclaration(declarationArray[n2]);
            expressionArray[n2] = QuoteExp.nullExp;
            object4 = externalizable.cdr;
            ++n2;
        }
        if (this.recursive) {
            translator.push(letExp);
        }
        externalizable = translator.currentMacroDefinition;
        int n3 = 0;
        while (n3 < n) {
            translator.currentMacroDefinition = macroArray[n3];
            expressionArray[n3] = translator.rewrite(objectArray[n3]);
            macroArray[n3].expander = expressionArray[n3];
            ++n3;
        }
        translator.currentMacroDefinition = externalizable;
        if (!this.recursive) {
            translator.push(letExp);
        }
        object3 = translator.rewrite_body(object5);
        translator.pop(letExp);
        return object3;
    }
}

