/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class Main {
    private static final String[] HOME_NAMES = new String[]{"JENKINS_HOME", "HUDSON_HOME"};
    static /* synthetic */ Class class$Main;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$util$zip$ZipFile;

    private static Map parseDependencyVersions() throws IOException {
        String line;
        HashMap<String, String> r = new HashMap<String, String>();
        BufferedReader in = new BufferedReader(new InputStreamReader((class$Main == null ? (class$Main = Main.class$("Main")) : class$Main).getResourceAsStream("WEB-INF/classes/dependencies.txt")));
        while ((line = in.readLine()) != null) {
            String[] tokens = (line = line.trim()).split(":");
            if (tokens.length != 5) continue;
            r.put(tokens[0] + ":" + tokens[1], tokens[3]);
        }
        return r;
    }

    public static void main(String[] args) throws Exception {
        try {
            String v = System.getProperty("java.class.version");
            if (v != null) {
                try {
                    if (Float.parseFloat(v) < 51.0f) {
                        throw new UnsupportedClassVersionError(v);
                    }
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            ColorFormatter.install();
            Main._main(args);
        }
        catch (UnsupportedClassVersionError e) {
            System.err.println("Jenkins requires Java7 or later, but you are running " + System.getProperty("java.runtime.version") + " from " + System.getProperty("java.home"));
            e.printStackTrace();
        }
    }

    private static void _main(String[] args) throws Exception {
        int i;
        ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
        if (arguments.contains("--version")) {
            System.out.println(Main.getVersion("?"));
            return;
        }
        File extractedFilesFolder = null;
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--extractedFilesFolder=") || (extractedFilesFolder = new File(args[i].substring("--extractedFilesFolder=".length()))).isDirectory()) continue;
            System.err.println("The extractedFilesFolder value is not a directory. Ignoring.");
            extractedFilesFolder = null;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--daemon")) continue;
            Map revisions = Main.parseDependencyVersions();
            URLClassLoader cl = new URLClassLoader(new URL[]{Main.extractFromJar("WEB-INF/lib/jna-" + Main.getVersion(revisions, "net.java.dev.jna", "jna") + ".jar", "jna", "jar", extractedFilesFolder).toURI().toURL(), Main.extractFromJar("WEB-INF/lib/akuma-" + Main.getVersion(revisions, "org.kohsuke", "akuma") + ".jar", "akuma", "jar", extractedFilesFolder).toURI().toURL()});
            Class<?> $daemon = cl.loadClass("com.sun.akuma.Daemon");
            Object daemon = $daemon.newInstance();
            Method isDaemonized = $daemon.getMethod("isDaemonized", new Class[0]);
            if (!((Boolean)isDaemonized.invoke(daemon, new Object[0])).booleanValue()) {
                System.out.println("Forking into background to run as a daemon.");
                if (!Main.hasOption(arguments, "--logfile=")) {
                    System.out.println("Use --logfile to redirect output to a file");
                }
            }
            Method m = $daemon.getMethod("all", Boolean.TYPE);
            m.invoke(daemon, Boolean.TRUE);
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--logfile=")) continue;
            LogFileOutputStream los = new LogFileOutputStream(new File(args[i].substring("--logfile=".length())));
            PrintStream ps = new PrintStream(los);
            System.setOut(ps);
            System.setErr(ps);
            ArrayList<String> _args = new ArrayList<String>(Arrays.asList(args));
            _args.remove(i);
            args = _args.toArray(new String[_args.size()]);
            break;
        }
        for (i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("--pluginroot=")) continue;
            System.setProperty("hudson.PluginManager.workDir", new File(args[i].substring("--pluginroot=".length())).getAbsolutePath());
            break;
        }
        System.setProperty("java.awt.headless", "true");
        if (System.getProperty("hudson.diyChunking") == null) {
            System.setProperty("hudson.diyChunking", "true");
        }
        File me = Main.whoAmI(extractedFilesFolder);
        System.out.println("Running from: " + me);
        System.setProperty("executable-war", me.getAbsolutePath());
        Main.trimOffOurOptions(arguments);
        arguments.add(0, "--warfile=" + me.getAbsolutePath());
        if (!Main.hasOption(arguments, "--webroot=")) {
            FileAndDescription describedHomeDir = Main.getHomeDir();
            System.out.println("webroot: " + describedHomeDir.description);
            arguments.add("--webroot=" + new File(describedHomeDir.file, "war"));
        }
        File tmpJar = Main.extractFromJar("winstone.jar", "winstone", ".jar", extractedFilesFolder);
        tmpJar.deleteOnExit();
        File tempFile = File.createTempFile("dummy", "dummy");
        Main.deleteContents(new File(tempFile.getParent(), "winstone/" + me.getName()));
        tempFile.delete();
        URLClassLoader cl = new URLClassLoader(new URL[]{tmpJar.toURI().toURL()});
        Class<?> launcher = cl.loadClass("winstone.Launcher");
        Method mainMethod = launcher.getMethod("main", array$Ljava$lang$String == null ? (array$Ljava$lang$String = Main.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        Field usage = launcher.getField("USAGE");
        usage.set(null, "Jenkins Continuous Integration Engine " + Main.getVersion("") + "\n" + "Usage: java -jar jenkins.war [--option=value] [--option=value]\n" + "\n" + "Options:\n" + "   --webroot                = folder where the WAR file is expanded into. Default is ${JENKINS_HOME}/war\n" + "   --pluginroot             = folder where the plugin archives are expanded into. Default is ${JENKINS_HOME}/plugins\n" + "                              (NOTE: this option does not change the directory where the plugin archives are stored)\n" + "   --extractedFilesFolder   = folder where extracted files are to be located. Default is the temp folder\n" + "   --daemon                 = fork into background and run as daemon (Unix only)\n" + "   --logfile                = redirect log messages to this file\n" + "{OPTIONS}");
        try {
            Field f = cl.loadClass("winstone.WinstoneSession").getField("SESSION_COOKIE_NAME");
            f.setAccessible(true);
            f.set(null, "JSESSIONID." + UUID.randomUUID().toString().replace("-", "").substring(0, 8));
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        mainMethod.invoke(null, new Object[]{arguments.toArray(new String[0])});
    }

    private static void trimOffOurOptions(List arguments) {
        Iterator itr = arguments.iterator();
        while (itr.hasNext()) {
            String arg = (String)itr.next();
            if (!arg.startsWith("--daemon") && !arg.startsWith("--logfile") && !arg.startsWith("--extractedFilesFolder") && !arg.startsWith("--pluginroot")) continue;
            itr.remove();
        }
    }

    private static String getVersion(Map revisions, String groupId, String artifactId) {
        String v = (String)revisions.get(groupId + ":" + artifactId);
        if (v == null) {
            Iterator itr = revisions.keySet().iterator();
            while (itr.hasNext()) {
                String key = (String)itr.next();
                if (!key.endsWith(":" + artifactId)) continue;
                return v;
            }
        }
        return v;
    }

    private static String getVersion(String fallback) throws IOException {
        Enumeration<URL> manifests = (class$Main == null ? (class$Main = Main.class$("Main")) : class$Main).getClassLoader().getResources("META-INF/MANIFEST.MF");
        while (manifests.hasMoreElements()) {
            URL res = manifests.nextElement();
            Manifest manifest = new Manifest(res.openStream());
            String v = manifest.getMainAttributes().getValue("Jenkins-Version");
            if (v == null) continue;
            return v;
        }
        return fallback;
    }

    private static boolean hasOption(List args, String prefix) {
        Iterator itr = args.iterator();
        while (itr.hasNext()) {
            String s = (String)itr.next();
            if (!s.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File whoAmI(File directory) throws IOException, URISyntaxException {
        try {
            URL classFile = (class$Main == null ? (class$Main = Main.class$("Main")) : class$Main).getClassLoader().getResource("Main.class");
            JarFile jf = ((JarURLConnection)classFile.openConnection()).getJarFile();
            Field f = (class$java$util$zip$ZipFile == null ? (class$java$util$zip$ZipFile = Main.class$("java.util.zip.ZipFile")) : class$java$util$zip$ZipFile).getDeclaredField("name");
            f.setAccessible(true);
            return new File((String)f.get(jf));
        }
        catch (Exception x) {
            System.err.println("ZipFile.name trick did not work, using fallback: " + x);
            File myself = File.createTempFile("jenkins", ".jar", directory);
            myself.deleteOnExit();
            InputStream is = (class$Main == null ? (class$Main = Main.class$("Main")) : class$Main).getProtectionDomain().getCodeSource().getLocation().openStream();
            try {
                FileOutputStream os = new FileOutputStream(myself);
                try {
                    Main.copyStream(is, os);
                }
                finally {
                    ((OutputStream)os).close();
                }
            }
            finally {
                is.close();
            }
            return myself;
        }
    }

    private static void copyStream(InputStream in, OutputStream out) throws IOException {
        int len;
        byte[] buf = new byte[8192];
        while ((len = in.read(buf)) > 0) {
            out.write(buf, 0, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static File extractFromJar(String resource, String fileName, String suffix, File directory) throws IOException {
        File tmp;
        URL res = (class$Main == null ? (class$Main = Main.class$("Main")) : class$Main).getResource(resource);
        if (res == null) {
            throw new IOException("Unable to find the resource: " + resource);
        }
        try {
            tmp = File.createTempFile(fileName, suffix, directory);
        }
        catch (IOException e) {
            String tmpdir = directory == null ? System.getProperty("java.io.tmpdir") : directory.getAbsolutePath();
            IOException x = new IOException("Jenkins has failed to create a temporary file in " + tmpdir);
            x.initCause(e);
            throw x;
        }
        InputStream is = res.openStream();
        try {
            FileOutputStream os = new FileOutputStream(tmp);
            try {
                Main.copyStream(is, os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        finally {
            is.close();
        }
        tmp.deleteOnExit();
        return tmp;
    }

    private static void deleteContents(File file) throws IOException {
        File[] files;
        if (file.isDirectory() && (files = file.listFiles()) != null) {
            for (int i = 0; i < files.length; ++i) {
                Main.deleteContents(files[i]);
            }
        }
        file.delete();
    }

    private static FileAndDescription getHomeDir() {
        File legacyHome;
        String name;
        int i;
        for (i = 0; i < HOME_NAMES.length; ++i) {
            name = HOME_NAMES[i];
            try {
                InitialContext iniCtxt = new InitialContext();
                Context env = (Context)iniCtxt.lookup("java:comp/env");
                String value = (String)env.lookup(name);
                if (value != null && value.trim().length() > 0) {
                    return new FileAndDescription(new File(value.trim()), "JNDI/java:comp/env/" + name);
                }
                value = (String)iniCtxt.lookup(name);
                if (value == null || value.trim().length() <= 0) continue;
                return new FileAndDescription(new File(value.trim()), "JNDI/" + name);
            }
            catch (NamingException e) {
                // empty catch block
            }
        }
        for (i = 0; i < HOME_NAMES.length; ++i) {
            name = HOME_NAMES[i];
            String sysProp = System.getProperty(name);
            if (sysProp == null) continue;
            return new FileAndDescription(new File(sysProp.trim()), "System.getProperty(\"" + name + "\")");
        }
        try {
            for (i = 0; i < HOME_NAMES.length; ++i) {
                name = HOME_NAMES[i];
                String env = System.getenv(name);
                if (env == null) continue;
                return new FileAndDescription(new File(env.trim()).getAbsoluteFile(), "EnvVars.masterEnvVars.get(\"" + name + "\")");
            }
        }
        catch (Throwable e) {
            // empty catch block
        }
        if ((legacyHome = new File(new File(System.getProperty("user.home")), ".hudson")).exists()) {
            return new FileAndDescription(legacyHome, "$user.home/.hudson");
        }
        File newHome = new File(new File(System.getProperty("user.home")), ".jenkins");
        return new FileAndDescription(newHome, "$user.home/.jenkins");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class FileAndDescription {
        File file;
        String description;

        public FileAndDescription(File file, String description) {
            this.file = file;
            this.description = description;
        }
    }
}

