/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.analysis.js.checkers.declaration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.AbstractKtSourceElement;
import org.jetbrains.kotlin.diagnostics.DiagnosticContext;
import org.jetbrains.kotlin.diagnostics.DiagnosticReporter;
import org.jetbrains.kotlin.diagnostics.KtDiagnosticReportHelpersKt;
import org.jetbrains.kotlin.fir.analysis.checkers.MppCheckerKind;
import org.jetbrains.kotlin.fir.analysis.checkers.context.CheckerContext;
import org.jetbrains.kotlin.fir.analysis.checkers.declaration.FirDeclarationChecker;
import org.jetbrains.kotlin.fir.analysis.diagnostics.js.FirJsErrors;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsHelpersKt;
import org.jetbrains.kotlin.fir.analysis.js.checkers.FirJsStableName;
import org.jetbrains.kotlin.fir.declarations.FirCallableDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirClassLikeDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirDeclaration;
import org.jetbrains.kotlin.fir.resolve.ContainingClassUtilsKt;

@Metadata(mv={2, 3, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\f\u0012\u0004\u0012\u00020\u00020\u0001j\u0002`\u0003B\t\b\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0010\u001a\u00020\u0002H\u0016R\u00020\fR\u00020\u000ej\u0006\u0010\r\u001a\u00020\fj\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u0011R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lorg/jetbrains/kotlin/fir/analysis/js/checkers/declaration/FirJsBuiltinNameClashChecker;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirDeclarationChecker;", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;", "Lorg/jetbrains/kotlin/fir/analysis/checkers/declaration/FirBasicDeclarationChecker;", "<init>", "()V", "PROHIBITED_STATIC_NAMES", "", "", "PROHIBITED_MEMBER_NAMES", "check", "", "Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;", "context", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;", "reporter", "declaration", "(Lorg/jetbrains/kotlin/fir/analysis/checkers/context/CheckerContext;Lorg/jetbrains/kotlin/diagnostics/DiagnosticReporter;Lorg/jetbrains/kotlin/fir/declarations/FirDeclaration;)V", "checkers.js"})
public final class FirJsBuiltinNameClashChecker
extends FirDeclarationChecker<FirDeclaration> {
    @NotNull
    public static final FirJsBuiltinNameClashChecker INSTANCE = new FirJsBuiltinNameClashChecker();
    @NotNull
    private static final Set<String> PROHIBITED_STATIC_NAMES;
    @NotNull
    private static final Set<String> PROHIBITED_MEMBER_NAMES;

    private FirJsBuiltinNameClashChecker() {
        super(MppCheckerKind.Common);
    }

    @Override
    public void check(@NotNull CheckerContext context2, @NotNull DiagnosticReporter reporter, @NotNull FirDeclaration declaration) {
        Intrinsics.checkNotNullParameter(context2, "context");
        Intrinsics.checkNotNullParameter(reporter, "reporter");
        Intrinsics.checkNotNullParameter(declaration, "declaration");
        if (FirJsHelpersKt.isNativeObject(declaration.getSymbol(), context2.getSession())) {
            return;
        }
        if (ContainingClassUtilsKt.getContainingClassSymbol(declaration) == null) {
            return;
        }
        FirJsStableName firJsStableName = FirJsStableName.Companion.createStableNameOrNull(declaration.getSymbol(), context2.getSession());
        if (firJsStableName == null) {
            return;
        }
        FirJsStableName stableName = firJsStableName;
        if (declaration instanceof FirClassLikeDeclaration && PROHIBITED_STATIC_NAMES.contains(stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirClassLikeDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getJS_BUILTIN_NAME_CLASH(), (Object)("Function." + stableName), null, 16, null);
        }
        if (declaration instanceof FirCallableDeclaration && PROHIBITED_MEMBER_NAMES.contains(stableName.getName())) {
            KtDiagnosticReportHelpersKt.reportOn$default((DiagnosticContext)context2, reporter, (AbstractKtSourceElement)((FirCallableDeclaration)declaration).getSource(), FirJsErrors.INSTANCE.getJS_BUILTIN_NAME_CLASH(), (Object)("Object.prototype." + stableName), null, 16, null);
        }
    }

    static {
        String[] stringArray = new String[]{"prototype", "length", "$metadata$"};
        PROHIBITED_STATIC_NAMES = SetsKt.setOf(stringArray);
        PROHIBITED_MEMBER_NAMES = SetsKt.setOf("constructor");
    }
}

