/*
 * Decompiled with CFR 0.152.
 */
package org.rundeck.client.api.model;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
@JsonInclude(value=JsonInclude.Include.NON_NULL)
public class KeyStorageItem
implements Comparable<KeyStorageItem> {
    public static final String RUNDECK_DATA_TYPE = "Rundeck-data-type";
    public static final String RUNDECK_KEY_TYPE = "Rundeck-key-type";
    public static final String PASSWORD_DATA_TYPE = "password";
    public static final String PRIVATE_KEY_TYPE = "private";
    public static final String PUBLIC_KEY_TYPE = "public";
    private String path;
    private KeyItemType type;
    private String name;
    private String url;
    private Map<String, String> meta;
    private List<KeyStorageItem> resources;
    private Object metaString;
    private String fileType;

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public KeyItemType getType() {
        return this.type;
    }

    public void setType(KeyItemType type) {
        this.type = type;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<String, String> getMeta() {
        return this.meta;
    }

    public void setMeta(Map<String, String> meta) {
        this.meta = meta;
    }

    public List<KeyStorageItem> getResources() {
        if (this.resources == null) {
            return new ArrayList<KeyStorageItem>();
        }
        return this.resources;
    }

    public void setResources(List<KeyStorageItem> resources) {
        this.resources = resources;
    }

    public String getMetaString() {
        return this.getMetaString("");
    }

    public String getMetaString(String prefix) {
        StringBuilder sb = new StringBuilder();
        if (null != this.getMeta() && this.getMeta().size() > 0) {
            this.getMeta().keySet().forEach(m -> sb.append(prefix).append((String)m).append(": ").append(this.getMeta().get(m)).append("\n"));
        }
        return sb.toString();
    }

    public KeyFileType getFileType() {
        if (null != this.getMeta()) {
            if (PASSWORD_DATA_TYPE.equals(this.getMeta().get(RUNDECK_DATA_TYPE))) {
                return KeyFileType.password;
            }
            if (PRIVATE_KEY_TYPE.equals(this.getMeta().get(RUNDECK_KEY_TYPE))) {
                return KeyFileType.privateKey;
            }
            if (PUBLIC_KEY_TYPE.equals(this.getMeta().get(RUNDECK_KEY_TYPE))) {
                return KeyFileType.publicKey;
            }
        }
        return KeyFileType.other;
    }

    public String toBasicString() {
        boolean isDir = this.isDirectory();
        if (isDir) {
            return String.format("%s/", this.path);
        }
        return String.format("%s [%s]", new Object[]{this.path, this.getFileType()});
    }

    public boolean isDirectory() {
        return this.type == KeyItemType.directory;
    }

    public String toString() {
        return "org.rundeck.client.api.model.KeyStorageItem{path='" + this.path + '\'' + ", type=" + (Object)((Object)this.type) + ", name='" + this.name + '\'' + ", url='" + this.url + '\'' + ", meta=" + this.meta + ", resources=" + this.resources + '}';
    }

    @Override
    public int compareTo(KeyStorageItem o) {
        if (this.isDirectory() && !o.isDirectory()) {
            return -1;
        }
        if (!this.isDirectory() && o.isDirectory()) {
            return 1;
        }
        return this.getPath().compareTo(o.getPath());
    }

    public static enum KeyItemType {
        directory,
        file;

    }

    public static enum KeyFileType {
        password,
        privateKey,
        publicKey,
        other;

    }
}

