/*
 * Decompiled with CFR 0.152.
 */
package jrm.profile.scan;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.xml.stream.FactoryConfigurationError;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import jrm.locale.Messages;
import jrm.profile.Profile;
import jrm.profile.data.Container;
import jrm.profile.data.Entry;
import jrm.profile.data.Machine;
import jrm.profile.data.MachineList;
import jrm.profile.data.NameBase;
import jrm.profile.data.Software;
import jrm.profile.data.SoftwareList;
import jrm.profile.manager.Export;
import jrm.profile.scan.DirScan;
import jrm.ui.progress.ProgressHandler;
import jrm.xml.EnhancedXMLStreamWriter;
import jrm.xml.SimpleAttribute;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;

public class Dir2Dat {
    public Dir2Dat(File srcdir, File dstdat, ProgressHandler progress, EnumSet<DirScan.Options> options, Export.ExportType type, HashMap<String, String> headers) {
        DirScan srcdir_scan = new DirScan(srcdir, progress, options);
        this.write(dstdat, srcdir_scan, progress, options, type, headers);
    }

    /*
     * WARNING - void declaration
     */
    private void write(File dstdat, DirScan scan, ProgressHandler progress, EnumSet<DirScan.Options> options, Export.ExportType type, HashMap<String, String> headers) {
        progress.clearInfos();
        progress.setInfos(1, false);
        AtomicInteger i = new AtomicInteger();
        scan.getContainersIterable().forEach(c -> i.incrementAndGet());
        progress.setProgress(Messages.getString("Dir2Dat.Saving"), 0, i.get());
        i.set(0);
        try (BufferedOutputStream fos = new BufferedOutputStream(new FileOutputStream(dstdat));){
            EnhancedXMLStreamWriter writer = new EnhancedXMLStreamWriter(XMLOutputFactory.newInstance().createXMLStreamWriter(fos, "UTF-8"));
            writer.writeStartDocument("UTF-8", "1.0");
            switch (type) {
                case MAME: {
                    writer.writeDTD("<!DOCTYPE mame [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/mame.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
                    writer.writeStartElement("mame");
                    HashMap<void, AtomicInteger> counter = new HashMap<void, AtomicInteger>();
                    for (Container c2 : scan.getContainersIterable()) {
                        void var14_24;
                        AtomicInteger val;
                        void var14_27;
                        String string = FilenameUtils.removeExtension(c2.file.getName());
                        NameBase machine = null;
                        if (Profile.curr_profile != null && options.contains((Object)DirScan.Options.MATCH_PROFILE)) {
                            machine = ((MachineList)Profile.curr_profile.machinelist_list.get(0)).getByName(string);
                        }
                        if (machine != null) {
                            String string2 = machine.getBaseName();
                        }
                        if (!counter.containsKey(var14_27)) {
                            counter.put(var14_27, new AtomicInteger());
                        }
                        if ((val = (AtomicInteger)counter.get(var14_27)).incrementAndGet() > 1) {
                            String string3 = (String)var14_27 + "_" + val.get();
                        }
                        progress.setProgress(Messages.getString("Dir2Dat.Saving"), i.incrementAndGet());
                        writer.writeStartElement("machine", new SimpleAttribute("name", var14_24), new SimpleAttribute("isbios", machine != null && ((Machine)machine).isBios() ? "yes" : null), new SimpleAttribute("isdevice", machine != null && ((Machine)machine).isdevice ? "yes" : null), new SimpleAttribute("ismechanical", machine != null && ((Machine)machine).ismechanical ? "yes" : null), new SimpleAttribute("cloneof", machine != null ? ((Machine)machine).cloneof : null), new SimpleAttribute("romof", machine != null ? ((Machine)machine).romof : null), new SimpleAttribute("sampleof", machine != null ? ((Machine)machine).sampleof : null));
                        writer.writeElement("description", (CharSequence)(machine != null ? ((Machine)machine).description : var14_24), new SimpleAttribute[0]);
                        writer.writeElement("year", machine != null ? ((Machine)machine).year : "????", new SimpleAttribute[0]);
                        writer.writeElement("manufacturer", machine != null ? ((Machine)machine).manufacturer : "", new SimpleAttribute[0]);
                        for (Entry e : c2.getEntries()) {
                            String ename;
                            if (e.type == Entry.Type.CHD) {
                                ename = this.normalize(FilenameUtils.removeExtension(e.getName()));
                                if (options.contains((Object)DirScan.Options.JUNK_SUBFOLDERS)) {
                                    ename = Paths.get(ename, new String[0]).getFileName().toString();
                                }
                                writer.writeElement("disk", new SimpleAttribute("name", ename), new SimpleAttribute("md5", e.md5), new SimpleAttribute("sha1", e.sha1));
                                continue;
                            }
                            ename = this.normalize(e.getName());
                            if (options.contains((Object)DirScan.Options.JUNK_SUBFOLDERS)) {
                                ename = Paths.get(ename, new String[0]).getFileName().toString();
                            }
                            writer.writeElement("rom", new SimpleAttribute("name", ename), new SimpleAttribute("size", e.size), new SimpleAttribute("crc", e.crc), new SimpleAttribute("md5", options.contains((Object)DirScan.Options.NEED_MD5) ? e.md5 : null), new SimpleAttribute("sha1", options.contains((Object)DirScan.Options.NEED_SHA1) ? e.sha1 : null));
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    break;
                }
                case DATAFILE: {
                    writer.writeDTD("<!DOCTYPE datafile [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/datafile.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
                    writer.writeStartElement("datafile");
                    writer.writeStartElement("header");
                    for (Map.Entry<String, String> entry : headers.entrySet()) {
                        writer.writeElement(entry.getKey(), entry.getValue(), new SimpleAttribute[0]);
                    }
                    writer.writeEndElement();
                    HashMap counter = new HashMap();
                    for (Container c3 : scan.getContainersIterable()) {
                        void var14_29;
                        AtomicInteger val;
                        void var14_32;
                        String string = FilenameUtils.removeExtension(c3.file.getName());
                        NameBase machine = null;
                        if (Profile.curr_profile != null && options.contains((Object)DirScan.Options.MATCH_PROFILE)) {
                            machine = ((MachineList)Profile.curr_profile.machinelist_list.get(0)).getByName(string);
                        }
                        if (machine != null) {
                            String string4 = machine.getBaseName();
                        }
                        if (!counter.containsKey(var14_32)) {
                            counter.put(var14_32, new AtomicInteger());
                        }
                        if ((val = (AtomicInteger)counter.get(var14_32)).incrementAndGet() > 1) {
                            String string5 = (String)var14_32 + "_" + val.get();
                        }
                        progress.setProgress(Messages.getString("Dir2Dat.Saving"), i.incrementAndGet());
                        writer.writeStartElement("game", new SimpleAttribute("name", var14_29), new SimpleAttribute("isbios", machine != null && ((Machine)machine).isBios() ? "yes" : null), new SimpleAttribute("cloneof", machine != null ? ((Machine)machine).cloneof : null), new SimpleAttribute("romof", machine != null ? ((Machine)machine).romof : null), new SimpleAttribute("sampleof", machine != null ? ((Machine)machine).sampleof : null));
                        writer.writeElement("description", (CharSequence)(machine != null ? ((Machine)machine).description : var14_29), new SimpleAttribute[0]);
                        writer.writeElement("year", machine != null ? ((Machine)machine).year : "????", new SimpleAttribute[0]);
                        writer.writeElement("manufacturer", machine != null ? ((Machine)machine).manufacturer : "", new SimpleAttribute[0]);
                        for (Entry e : c3.getEntries()) {
                            String ename;
                            if (e.type == Entry.Type.CHD) {
                                ename = this.normalize(FilenameUtils.removeExtension(e.getName()));
                                if (options.contains((Object)DirScan.Options.JUNK_SUBFOLDERS)) {
                                    ename = Paths.get(ename, new String[0]).getFileName().toString();
                                }
                                writer.writeElement("disk", new SimpleAttribute("name", ename), new SimpleAttribute("md5", e.md5), new SimpleAttribute("sha1", e.sha1));
                                continue;
                            }
                            ename = this.normalize(e.getName());
                            if (options.contains((Object)DirScan.Options.JUNK_SUBFOLDERS)) {
                                ename = Paths.get(ename, new String[0]).getFileName().toString();
                            }
                            writer.writeElement("rom", new SimpleAttribute("name", ename), new SimpleAttribute("size", e.size), new SimpleAttribute("crc", e.crc), new SimpleAttribute("md5", options.contains((Object)DirScan.Options.NEED_MD5) ? e.md5 : null), new SimpleAttribute("sha1", options.contains((Object)DirScan.Options.NEED_SHA1) ? e.sha1 : null), new SimpleAttribute("offset", 0), new SimpleAttribute("date", e.modified));
                        }
                        writer.writeEndElement();
                    }
                    writer.writeEndElement();
                    break;
                }
                case SOFTWARELIST: {
                    HashMap slcounter = new HashMap();
                    HashMap<String, SL> hashMap = new HashMap<String, SL>();
                    for (Container container : scan.getContainersIterable()) {
                        AtomicInteger val;
                        Map swcounter;
                        progress.setProgress(Messages.getString("Dir2Dat.Saving"), i.incrementAndGet());
                        Software software = null;
                        Path relativized = scan.getDir().toPath().relativize(container.file.toPath());
                        String swname = FilenameUtils.removeExtension(relativized.getFileName().toString());
                        String slname = relativized.getParent().toString();
                        if (Profile.curr_profile != null) {
                            SoftwareList sl = Profile.curr_profile.machinelist_list.softwarelist_list.getByName(slname);
                            if (sl != null && sl.containsName(swname)) {
                                software = sl.getByName(swname);
                            }
                            if (software != null && options.contains((Object)DirScan.Options.MATCH_PROFILE)) {
                                swname = software.getBaseName();
                                slname = software.sl.getBaseName();
                            }
                        }
                        if (!slcounter.containsKey(slname)) {
                            slcounter.put(slname, new HashMap());
                            hashMap.put(slname, new SL(slname, software != null ? software.sl : null));
                        }
                        if (!(swcounter = (Map)slcounter.get(slname)).containsKey(swname)) {
                            swcounter.put(swname, new AtomicInteger());
                        }
                        if ((val = (AtomicInteger)swcounter.get(swname)).incrementAndGet() > 1) {
                            swname = swname + "_" + val.get();
                        }
                        ((SL)hashMap.get(slname)).sw.put(swname, new SL.SW(swname, software, container));
                    }
                    if (hashMap.size() > 1) {
                        writer.writeDTD("<!DOCTYPE softwarelists [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/softwarelists.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
                        writer.writeStartElement("softwarelists");
                    }
                    for (Map.Entry entry : hashMap.entrySet()) {
                        if (hashMap.size() == 1) {
                            writer.writeDTD("<!DOCTYPE softwarelist [\n" + IOUtils.toString(Export.class.getResourceAsStream("/jrm/resources/dtd/softwarelist.dtd"), Charset.forName("UTF-8")) + "\n]>\n");
                        }
                        writer.writeStartElement("softwarelist", new SimpleAttribute("name", ((SL)entry.getValue()).name));
                        if (((SL)entry.getValue()).sl != null) {
                            writer.writeElement("description", ((SL)((SL)entry.getValue())).sl.description, new SimpleAttribute[0]);
                        }
                        for (Map.Entry ee : ((SL)entry.getValue()).sw.entrySet()) {
                            if (((SL.SW)ee.getValue()).sw != null) {
                                ((SL.SW)ee.getValue()).sw.export(writer, ((SL.SW)ee.getValue()).c.getEntries());
                                continue;
                            }
                            writer.writeStartElement("software", new SimpleAttribute("name", ((SL.SW)ee.getValue()).name));
                            int ii = 0;
                            for (Entry entry2 : ((SL.SW)ee.getValue()).c.getEntries()) {
                                String ename;
                                if (entry2.type == Entry.Type.CHD) {
                                    ename = this.normalize(FilenameUtils.removeExtension(entry2.getName()));
                                    if (options.contains((Object)DirScan.Options.JUNK_SUBFOLDERS)) {
                                        ename = Paths.get(ename, new String[0]).getFileName().toString();
                                    }
                                    writer.writeStartElement("part", new SimpleAttribute("name", "cdrom" + ++ii), new SimpleAttribute("interface", "cdrom"));
                                    writer.writeStartElement("diskarea", new SimpleAttribute("name", "cdrom"));
                                    writer.writeElement("disk", new SimpleAttribute("name", ename), new SimpleAttribute("sha1", entry2.sha1));
                                    writer.writeEndElement();
                                    writer.writeEndElement();
                                    continue;
                                }
                                ename = this.normalize(entry2.getName());
                                if (options.contains((Object)DirScan.Options.JUNK_SUBFOLDERS)) {
                                    ename = Paths.get(ename, new String[0]).getFileName().toString();
                                }
                                writer.writeStartElement("part", new SimpleAttribute("name", "flop" + ++ii), new SimpleAttribute("interface", "floppy_3_5"));
                                writer.writeStartElement("dataarea", new SimpleAttribute("name", "flop"), new SimpleAttribute("size", entry2.size));
                                writer.writeElement("rom", new SimpleAttribute("name", ename), new SimpleAttribute("size", entry2.size), new SimpleAttribute("crc", entry2.crc), new SimpleAttribute("sha1", options.contains((Object)DirScan.Options.NEED_SHA1) ? entry2.sha1 : null));
                                writer.writeEndElement();
                                writer.writeEndElement();
                            }
                            writer.writeEndElement();
                        }
                        writer.writeEndElement();
                    }
                    if (hashMap.size() <= 1) break;
                    writer.writeEndElement();
                    break;
                }
            }
            writer.writeEndDocument();
            writer.close();
        }
        catch (IOException | FactoryConfigurationError | XMLStreamException e) {
            JOptionPane.showMessageDialog(null, e, "Exception", 0);
            e.printStackTrace();
        }
    }

    private String normalize(String entry) {
        if (File.separatorChar == '/') {
            return entry.replace('\\', '/');
        }
        return entry.replace('/', '\\');
    }

    private static class SL {
        private SoftwareList sl = null;
        private String name;
        private HashMap<String, SW> sw = new HashMap();

        private SL(String name, SoftwareList sl) {
            this.name = name;
            this.sl = sl;
        }

        private static class SW {
            private Software sw = null;
            private Container c = null;
            private String name;

            private SW(String name, Software sw, Container c) {
                this.name = name;
                this.sw = sw;
                this.c = c;
            }
        }
    }
}

