/*
 * Decompiled with CFR 0.152.
 */
package org.dbuml.base.transform;

import java.io.StringWriter;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Vector;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.app.VelocityEngine;
import org.dbuml.base.model.Column;
import org.dbuml.base.model.DBElement;
import org.dbuml.base.model.Database;
import org.dbuml.base.model.FKey;
import org.dbuml.base.model.PKeyInterface;
import org.dbuml.base.model.Schema;
import org.dbuml.base.model.Table;
import org.dbuml.base.model.View;
import org.dbuml.base.transform.DBUMLToSQL;
import org.dbuml.base.transform.FKConstraint;
import org.dbuml.base.transform.PKConstraint;

public class GenericDBUMLToSQL
extends DBUMLToSQL {
    private VelocityEngine engine = new VelocityEngine();
    private Template templateCreateAlter;
    private Template templateCreateAlterConstraints;
    private Template templateCreateAlterFKConstraints;
    private Template templateCreateTop;
    private Template templateDropTables;
    private Template templateDropViews;
    private Template templateDropSchema;
    private Template templateCreateSchema;
    private Template templateCreateTables;
    private Template templateCreateViews;
    private static final String TEMPLATES_DIR = "org/dbuml/base/transform/templates/";

    public GenericDBUMLToSQL() {
        try {
            this.engine.init(this.getEngineProperties());
            this.initTemplateDropTables(this.getTemplatePathDropTable());
            this.initTemplateDropViews(this.getTemplatePathDropView());
            this.initTemplateDropSchema(this.getTemplatePathDropSchema());
            this.initTemplateCreateSchema(this.getTemplatePathCreateSchema());
            this.initTemplateCreateTables(this.getTemplatePathCreateTable());
            this.initTemplateCreateViews(this.getTemplatePathCreateView());
            this.initTemplateCreateAlter(this.getTemplatePathAlter());
            this.initTemplateCreateTop(this.getTemplatePathCreateTop());
            this.initTemplateCreateAlterConstraints(this.getTemplatePathAlterConstraints());
            this.initTemplateCreateAlterFKConstraints(this.getTemplatePathAlterFKConstraints());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected String getTemplatePathCreateTable() {
        return "org/dbuml/base/transform/templates/GenericCreateTables.vm";
    }

    protected String getTemplatePathDropTable() {
        return "org/dbuml/base/transform/templates/GenericDropTables.vm";
    }

    protected String getTemplatePathCreateView() {
        return "org/dbuml/base/transform/templates/GenericCreateViews.vm";
    }

    protected String getTemplatePathDropView() {
        return "org/dbuml/base/transform/templates/GenericDropViews.vm";
    }

    protected String getTemplatePathCreateSchema() {
        return "org/dbuml/base/transform/templates/GenericCreateSchema.vm";
    }

    protected String getTemplatePathDropSchema() {
        return "org/dbuml/base/transform/templates/GenericDropSchema.vm";
    }

    protected String getTemplatePathAlter() {
        return "org/dbuml/base/transform/templates/GenericCreateAlterDBUMLToSQL.vm";
    }

    protected String getTemplatePathCreateTop() {
        return "org/dbuml/base/transform/templates/GenericCreateTopDBUMLToSQL.vm";
    }

    protected String getTemplatePathAlterConstraints() {
        return "org/dbuml/base/transform/templates/GenericCreateAlterConstraintsDBUMLToSQL.vm";
    }

    protected String getTemplatePathAlterFKConstraints() {
        return "org/dbuml/base/transform/templates/GenericCreateAlterFKConstraintsDBUMLToSQL.vm";
    }

    private Template initializeTemplate(String vmTemplateName) throws Exception {
        return this.engine.getTemplate(vmTemplateName);
    }

    protected void initTemplateDropTables(String template) throws Exception {
        this.templateDropTables = this.initializeTemplate(template);
    }

    public Template getTemplateDropTables() {
        return this.templateDropTables;
    }

    protected void initTemplateCreateTables(String template) throws Exception {
        this.templateCreateTables = this.initializeTemplate(template);
    }

    public Template getTemplateCreateTables() {
        return this.templateCreateTables;
    }

    protected void initTemplateDropViews(String template) throws Exception {
        this.templateDropViews = this.initializeTemplate(template);
    }

    public Template getTemplateDropViews() {
        return this.templateDropViews;
    }

    protected void initTemplateCreateViews(String template) throws Exception {
        this.templateCreateViews = this.initializeTemplate(template);
    }

    public Template getTemplateCreateViews() {
        return this.templateCreateViews;
    }

    protected void initTemplateDropSchema(String template) throws Exception {
        this.templateDropSchema = this.initializeTemplate(template);
    }

    public Template getTemplateDropSchema() {
        return this.templateDropSchema;
    }

    protected void initTemplateCreateSchema(String template) throws Exception {
        this.templateCreateSchema = this.initializeTemplate(template);
    }

    public Template getTemplateCreateSchema() {
        return this.templateCreateSchema;
    }

    protected void initTemplateCreateAlter(String template) throws Exception {
        this.templateCreateAlter = this.initializeTemplate(template);
    }

    public Template getTemplateCreateAlter() {
        return this.templateCreateAlter;
    }

    protected void initTemplateCreateTop(String template) throws Exception {
        this.templateCreateTop = this.initializeTemplate(template);
    }

    public Template getTemplateCreateTop() {
        return this.templateCreateTop;
    }

    protected void initTemplateCreateAlterConstraints(String template) throws Exception {
        this.templateCreateAlterConstraints = this.initializeTemplate(template);
    }

    public Template getTemplateCreateAlterConstraints() {
        return this.templateCreateAlterConstraints;
    }

    protected void initTemplateCreateAlterFKConstraints(String template) throws Exception {
        this.templateCreateAlterFKConstraints = this.initializeTemplate(template);
    }

    public Template getTemplateCreateAlterFKConstraints() {
        return this.templateCreateAlterFKConstraints;
    }

    public String genCreateSQL(DBElement dbe, String sNamespace, String sDialect) {
        VelocityContext context = new VelocityContext();
        if (dbe instanceof Database) {
            context.put("Database", (Database)dbe);
        } else if (dbe instanceof Schema) {
            context.put("Schema", (Schema)dbe);
        } else if (dbe instanceof View) {
            context.put("View", (View)dbe);
        } else if (dbe instanceof Table) {
            context.put("Table", (Table)dbe);
            context.put("FKCons", this.makeFKConstraints((Table)dbe));
            context.put("PKCon", this.makePKConstraint((Table)dbe));
        } else if (dbe instanceof Column) {
            context.put("Column", (Column)dbe);
        }
        context.put("Namespace", sNamespace);
        StringWriter writer = new StringWriter();
        try {
            if (sDialect.equals("createAlterSQL")) {
                this.templateCreateAlter.merge(context, writer);
            } else if (sDialect.equals("createTopSQL")) {
                this.templateCreateTop.merge(context, writer);
            } else if (sDialect.equals("createAlterConstraintsSQL")) {
                this.templateCreateAlterConstraints.merge(context, writer);
            } else if (sDialect.equals("createAlterFKConstraintsSQL")) {
                this.templateCreateAlterFKConstraints.merge(context, writer);
            } else if (sDialect.equals("dropSQLTables")) {
                this.templateDropTables.merge(context, writer);
            } else if (sDialect.equals("dropSQLViews")) {
                this.templateDropViews.merge(context, writer);
            } else if (sDialect.equals("dropSQLSchema")) {
                this.templateDropSchema.merge(context, writer);
            } else if (sDialect.equals("createSQLSchema")) {
                this.templateCreateSchema.merge(context, writer);
            } else if (sDialect.equals("createSQLTables")) {
                this.templateCreateTables.merge(context, writer);
            } else if (sDialect.equals("createSQLViews")) {
                this.templateCreateViews.merge(context, writer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return writer.toString();
    }

    private Vector makeFKConstraints(Table table) {
        Hashtable<String, FKConstraint> hashFKs = new Hashtable<String, FKConstraint>();
        Column[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isForeignKey()) continue;
            FKey fkey = columns[i].getKey().getForeignKey();
            String fname = fkey.getKeyName();
            FKConstraint fkconstraint = (FKConstraint)hashFKs.get(fname);
            if (fkconstraint == null) {
                fkconstraint = new FKConstraint(fname);
                hashFKs.put(fname, fkconstraint);
            }
            fkconstraint.setInfo(fkey);
        }
        return new Vector(hashFKs.values());
    }

    private PKConstraint makePKConstraint(Table table) {
        PKConstraint pkconstraint = null;
        Column[] columns = table.getColumns();
        for (int i = 0; i < columns.length; ++i) {
            if (!columns[i].isPrimaryKey()) continue;
            PKeyInterface pkey = columns[i].getKey();
            if (pkconstraint == null) {
                pkconstraint = new PKConstraint();
                pkconstraint.setPkName(pkey.getKeyName());
            }
            pkconstraint.getPkColumnNames().add(pkey.getKeySequence() - 1, pkey.getColumnName());
        }
        return pkconstraint;
    }

    protected Properties getEngineProperties() {
        Properties prop = new Properties();
        prop.setProperty("resource.loader", "class");
        prop.setProperty("class.resource.loader.class", "org.apache.velocity.runtime.resource.loader.ClasspathResourceLoader");
        prop.setProperty("velocimacro.library", "org/dbuml/base/transform/templates/VM_global_library.vm");
        prop.setProperty("velocimacro.permissions.allow.inline", "true");
        prop.setProperty("velocimacro.permissions.allow.inline.global.scope", "true");
        prop.setProperty("velocimacro.library.autoreload", "true");
        return prop;
    }
}

