/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.jdiskreport.gui.node;

import com.jgoodies.application.Application;
import com.jgoodies.application.ResourceMap;
import com.jgoodies.chart.TreeChartModel;
import com.jgoodies.common.base.Preconditions;
import com.jgoodies.jdiskreport.domain.DirectorySnapshot;
import com.jgoodies.jdiskreport.domain.FileSnapshot;
import com.jgoodies.jdiskreport.gui.node.AbstractNode;
import com.jgoodies.jdiskreport.gui.node.CollapsedFilesNode;
import com.jgoodies.jdiskreport.gui.node.FileNode;
import com.jgoodies.jdiskreport.gui.node.FileTreeChartModel;
import com.jgoodies.jdiskreport.gui.node.RootNode;
import com.jgoodies.jdiskreport.gui.settings.GUISettings;
import com.jgoodies.jdiskreport.gui.statistic.Statistics;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.swing.event.TableModelListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.table.TableModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class DirectoryNode
extends AbstractNode {
    private static final ResourceMap RESOURCES = Application.getResourceMap(DirectoryNode.class);
    private static final Comparator<AbstractNode> FILE_SIZE_COMPARATOR = new FileSizeComparator();
    private static final Comparator<AbstractNode> FILE_COUNT_COMPARATOR = new FileCountComparator();
    private static final Comparator<AbstractNode> NAME_COMPARATOR = new NameComparator();
    private final DirectorySnapshot directory;
    private final long size;
    private final long directoryCount;
    private final long fileCount;
    private final DirectoryNode[] childDirectories;
    private final FileNode[] childFiles;
    private List<AbstractNode> sortedChildren;
    private CollapsedFilesNode collapsedFilesNode;
    private Statistics statistics;
    private FileNode largestFile;
    private FileNode leastRecentlyModifiedFile;
    private FileNode mostRecentlyModifiedFile;
    private FileNode leastRecentlyAccessedFile;
    private FileNode mostRecentlyAccessedFile;
    private FileNode leastRecentlyUsedFile;
    private FileNode mostRecentlyUsedFile;
    private GUISettings.SortMode lastSortMode = null;
    private GUISettings.SizeMode lastSizeMode = null;
    private Boolean lastShowFiles = null;

    protected DirectoryNode(DirectorySnapshot directory, long size, long directoryCount, long fileCount, DirectoryNode[] childDirectories, FileNode[] childFiles) {
        this.directory = directory;
        this.size = size;
        this.directoryCount = directoryCount;
        this.fileCount = fileCount;
        this.childDirectories = childDirectories;
        this.childFiles = childFiles;
        for (DirectoryNode directoryNode : childDirectories) {
            directoryNode.setParent(this);
        }
        for (AbstractNode abstractNode : childFiles) {
            abstractNode.setParent(this);
        }
    }

    static DirectoryNode createFrom(DirectorySnapshot directory) {
        long size = 0L;
        long directoryCount = 1L;
        long fileCount = 0L;
        DirectorySnapshot[] childDirs = directory.getDirectories().toArray(new DirectorySnapshot[directory.getDirectories().size()]);
        DirectoryNode[] childDirNodes = new DirectoryNode[childDirs.length];
        for (int i = 0; i < childDirNodes.length; ++i) {
            DirectoryNode childNode;
            childDirNodes[i] = childNode = DirectoryNode.createFrom(childDirs[i]);
            size += childNode.getSize();
            directoryCount += childNode.getDirectoryCount();
            fileCount += childNode.getFileCount();
        }
        FileSnapshot[] childFiles = directory.getFiles().toArray(new FileSnapshot[directory.getFiles().size()]);
        FileNode[] childFileNodes = new FileNode[childFiles.length];
        for (int i = 0; i < childFileNodes.length; ++i) {
            FileNode childNode;
            childFileNodes[i] = childNode = new FileNode(childFiles[i]);
            size += childNode.getSize();
            fileCount += childNode.getFileCount();
        }
        return new DirectoryNode(directory, size, directoryCount, fileCount, childDirNodes, childFileNodes);
    }

    @Override
    public String getName() {
        return Paths.get(this.directory.getName(), new String[0]).getFileName().toString();
    }

    @Override
    public boolean isFileLeaf() {
        return false;
    }

    public TreePath getPathToRoot() {
        if (this.getParent() == null) {
            return new TreePath(this);
        }
        return this.getParent().getPathToRoot().pathByAddingChild(this);
    }

    public String getNodeName() {
        return this.getName();
    }

    public String getPathName() {
        return this.directory.getName();
    }

    @Override
    public long getSize() {
        return this.size;
    }

    public long getDirectoryCount() {
        return this.directoryCount;
    }

    @Override
    public long getFileCount() {
        return this.fileCount;
    }

    public DirectoryNode[] getChildDirectories() {
        return this.childDirectories;
    }

    public FileNode[] getChildFiles() {
        return this.childFiles;
    }

    public Statistics getStatistics() {
        return this.statistics;
    }

    private void setStatistics(Statistics statistics) {
        this.statistics = statistics;
    }

    public FileNode getLargestFile() {
        return this.statistics != null ? this.statistics.getLargestFiles().first() : this.largestFile;
    }

    public FileNode getLargestFileAt(int index) {
        return this.statistics.getLargestFiles().get(index);
    }

    public FileNode getLeastRecentlyModifiedFile() {
        return this.statistics != null ? this.statistics.getLeastRecentlyModifiedFiles().first() : this.leastRecentlyModifiedFile;
    }

    public FileNode getMostRecentlyModifiedFile() {
        return this.statistics != null ? this.statistics.getMostRecentlyModifiedFiles().first() : this.mostRecentlyModifiedFile;
    }

    public FileNode getLeastRecentlyAccessedFile() {
        return this.statistics != null ? this.statistics.getLeastRecentlyAccessedFiles().first() : this.leastRecentlyAccessedFile;
    }

    public FileNode getMostRecentlyAccessedFile() {
        return this.statistics != null ? this.statistics.getMostRecentlyAccessedFiles().first() : this.mostRecentlyAccessedFile;
    }

    public FileNode getLeastRecentlyUsedFile() {
        return this.statistics != null ? this.statistics.getLeastRecentlyUsedFiles().first() : this.leastRecentlyUsedFile;
    }

    public FileNode getMostRecentlyUsedFile() {
        return this.statistics != null ? this.statistics.getMostRecentlyUsedFiles().first() : this.mostRecentlyUsedFile;
    }

    protected void computeAndSetStatistics(int level) {
        DirectoryNode[] childDirs = this.getChildDirectories();
        ArrayList<Statistics> allStatistics = new ArrayList<Statistics>(childDirs.length);
        for (DirectoryNode directoryNode : childDirs) {
            directoryNode.computeAndSetStatistics(level - 1);
            Statistics nodeStatistics = directoryNode.getStatistics();
            allStatistics.add(nodeStatistics);
            if (level > 0) continue;
            if (directoryNode.getFileCount() > 0L) {
                directoryNode.largestFile = directoryNode.getLargestFile();
                directoryNode.leastRecentlyModifiedFile = directoryNode.getLeastRecentlyModifiedFile();
                directoryNode.mostRecentlyModifiedFile = directoryNode.getMostRecentlyModifiedFile();
                directoryNode.leastRecentlyAccessedFile = directoryNode.getLeastRecentlyAccessedFile();
                directoryNode.mostRecentlyAccessedFile = directoryNode.getMostRecentlyAccessedFile();
                directoryNode.leastRecentlyUsedFile = directoryNode.getLeastRecentlyUsedFile();
                directoryNode.mostRecentlyUsedFile = directoryNode.getMostRecentlyUsedFile();
            }
            directoryNode.setStatistics(null);
            directoryNode.clearCachedFiles();
        }
        allStatistics.add(Statistics.createFrom(this.getChildFiles()));
        this.setStatistics(Statistics.createFrom(allStatistics));
        for (Statistics s : allStatistics) {
            s.getTypeDistribution().replaceMapByArrays();
        }
        Arrays.sort(this.getChildDirectories(), FILE_SIZE_COMPARATOR);
        Arrays.sort(this.getChildFiles(), FILE_SIZE_COMPARATOR);
    }

    @Override
    public void clearCachedFiles() {
        super.clearCachedFiles();
        for (DirectoryNode directoryNode : this.getChildDirectories()) {
            directoryNode.clearCachedFiles();
        }
        for (AbstractNode abstractNode : this.getChildFiles()) {
            abstractNode.clearCachedFiles();
        }
    }

    final int getChildCount() {
        return this.childDirectories.length;
    }

    final DirectoryNode getChildAt(int childIndex, GUISettings.SortMode sortMode) {
        this.ensureChildDirectoriesSortedBy(sortMode);
        return this.childDirectories[childIndex];
    }

    final int getIndex(DirectoryNode node, GUISettings.SortMode sortMode) {
        this.ensureChildDirectoriesSortedBy(sortMode);
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (node != this.childDirectories[i]) continue;
            return i;
        }
        return -1;
    }

    private void ensureChildDirectoriesSortedBy(GUISettings.SortMode sortMode) {
        if (sortMode == this.lastSortMode) {
            return;
        }
        this.sortedChildren = null;
        Comparator<AbstractNode> comparator = sortMode == GUISettings.SortMode.BY_SIZE ? FILE_SIZE_COMPARATOR : NAME_COMPARATOR;
        Arrays.sort(this.childDirectories, comparator);
        this.lastSortMode = sortMode;
    }

    public final TableModel getTableModel(GUISettings.SortMode sortMode, GUISettings.SizeMode sizeMode, boolean showFiles) {
        return new SizeTableModel(this.getSortedChildren(sortMode, sizeMode, showFiles));
    }

    final List<AbstractNode> getSortedChildren(GUISettings.SortMode sortMode, GUISettings.SizeMode sizeMode, boolean showFiles) {
        if (this.sortedChildren != null && this.lastSortMode == sortMode && this.lastSizeMode == sizeMode && this.lastShowFiles == Boolean.valueOf(showFiles)) {
            return this.sortedChildren;
        }
        this.sortedChildren = this.createSortedChildren(sortMode, sizeMode, showFiles);
        this.lastSortMode = sortMode;
        this.lastSizeMode = sizeMode;
        this.lastShowFiles = showFiles;
        return this.sortedChildren;
    }

    private List<AbstractNode> createSortedChildren(GUISettings.SortMode sortMode, GUISettings.SizeMode sizeMode, boolean showFiles) {
        int length = this.childDirectories.length + (showFiles ? this.childFiles.length : 1);
        ArrayList<AbstractNode> children = new ArrayList<AbstractNode>(length);
        Collections.addAll(children, this.childDirectories);
        if (showFiles) {
            Collections.addAll(children, this.childFiles);
        } else if (this.childFiles.length > 0) {
            System.out.println("Adding a collapsed files node. Size: " + this.getCollapsedFilesNode().getSize());
            children.add(this.getCollapsedFilesNode());
        }
        Collections.sort(children, sortMode == GUISettings.SortMode.BY_NAME ? NAME_COMPARATOR : (sizeMode == GUISettings.SizeMode.SIZE ? FILE_SIZE_COMPARATOR : FILE_COUNT_COMPARATOR));
        return children;
    }

    private CollapsedFilesNode getCollapsedFilesNode() {
        if (this.collapsedFilesNode == null) {
            System.out.println("computing collapsed files\u2026");
            int collapsedSize = 0;
            for (FileNode childFile : this.childFiles) {
                collapsedSize = (int)((long)collapsedSize + childFile.getSize());
            }
            this.collapsedFilesNode = new CollapsedFilesNode(this, collapsedSize, this.childFiles.length);
        }
        return this.collapsedFilesNode;
    }

    public final TreeChartModel<AbstractNode> getTreeChartModel(GUISettings.SortMode sortMode, GUISettings.SizeMode sizeMode, boolean showFiles) {
        return new FileTreeChartModel(this, sortMode, sizeMode, showFiles);
    }

    protected DirectorySnapshot getDirectory() {
        return this.directory;
    }

    public String toString() {
        return this.getPathName();
    }

    private static final class FileCountComparator
    implements Comparator<AbstractNode> {
        private FileCountComparator() {
        }

        @Override
        public int compare(AbstractNode node1, AbstractNode node2) {
            long size2;
            long size1 = node1.getFileCount();
            if (size1 < (size2 = node2.getFileCount())) {
                return 1;
            }
            if (size1 > size2) {
                return -1;
            }
            return node1.getFile().compareTo(node2.getFile());
        }
    }

    private static final class FileSizeComparator
    implements Comparator<AbstractNode> {
        private FileSizeComparator() {
        }

        @Override
        public int compare(AbstractNode node1, AbstractNode node2) {
            long size2;
            long size1 = node1.getSize();
            if (size1 < (size2 = node2.getSize())) {
                return 1;
            }
            if (size1 > size2) {
                return -1;
            }
            return node1.getFile().compareTo(node2.getFile());
        }
    }

    public static final class FileTreeModel
    implements TreeModel {
        private final List<TreeModelListener> listenerList;
        private RootNode root;
        private GUISettings.SortMode sortMode;

        FileTreeModel(RootNode root, GUISettings.SortMode sortMode) {
            this.root = root;
            this.sortMode = sortMode;
            this.listenerList = new CopyOnWriteArrayList<TreeModelListener>();
        }

        public void setSortMode(GUISettings.SortMode newSortMode) {
            if (this.sortMode == newSortMode) {
                return;
            }
            this.sortMode = newSortMode;
            this.fireTreeStructureChanged();
        }

        public void setRoot(RootNode newRoot) {
            this.root = newRoot;
            this.fireTreeStructureChanged();
        }

        @Override
        public Object getRoot() {
            return this.root;
        }

        @Override
        public int getChildCount(Object parent) {
            DirectoryNode node = (DirectoryNode)parent;
            return node.getChildCount();
        }

        @Override
        public Object getChild(Object parent, int index) {
            DirectoryNode node = (DirectoryNode)parent;
            return node.getChildAt(index, this.sortMode);
        }

        @Override
        public int getIndexOfChild(Object parent, Object child) {
            DirectoryNode node = (DirectoryNode)parent;
            return node.getIndex((DirectoryNode)child, this.sortMode);
        }

        @Override
        public boolean isLeaf(Object node) {
            DirectoryNode directoryNode = (DirectoryNode)node;
            return directoryNode.getChildCount() == 0;
        }

        @Override
        public void addTreeModelListener(TreeModelListener listener) {
            Preconditions.checkNotNull(listener, "The %s must not be null.", "listener to add");
            this.listenerList.add(listener);
        }

        @Override
        public void removeTreeModelListener(TreeModelListener listener) {
            Preconditions.checkNotNull(listener, "The %s must not be null.", "listener to add");
            this.listenerList.add(listener);
        }

        private void fireTreeStructureChanged() {
            TreeModelEvent event = new TreeModelEvent((Object)this, new TreePath(this.getRoot()), null, null);
            for (TreeModelListener listener : this.listenerList) {
                listener.treeStructureChanged(event);
            }
        }

        @Override
        public void valueForPathChanged(TreePath path, Object newValue) {
        }
    }

    private static final class NameComparator
    implements Comparator<AbstractNode> {
        private NameComparator() {
        }

        @Override
        public int compare(AbstractNode node1, AbstractNode node2) {
            return node1.getFile().compareTo(node2.getFile());
        }
    }

    static final class SizeTableModel
    implements TableModel {
        private static final String COLUMN_NAME_KEY_PREFIX = "SizeTable";
        private static final String[] COLUMN_NAME_KEY_SUFFIXES = new String[]{"name", "size", "files", "relativeSize", "absoluteSize"};
        private static final Class<?>[] COLUMN_CLASSES = new Class[]{AbstractNode.class, Long.class, Long.class, Double.class, Double.class};
        private final List<AbstractNode> children;

        SizeTableModel(List<AbstractNode> children) {
            this.children = children;
        }

        @Override
        public int getColumnCount() {
            return COLUMN_NAME_KEY_SUFFIXES.length;
        }

        @Override
        public String getColumnName(int columnIndex) {
            String key = "SizeTable.columnName." + COLUMN_NAME_KEY_SUFFIXES[columnIndex];
            return RESOURCES.getString(key, new Object[0]);
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            return COLUMN_CLASSES[columnIndex];
        }

        @Override
        public int getRowCount() {
            return this.children.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            AbstractNode node = this.children.get(rowIndex);
            switch (columnIndex) {
                case 0: {
                    return node;
                }
                case 1: {
                    return node.getSize();
                }
                case 2: {
                    return node.getFileCount();
                }
                case 3: {
                    return node.getRelativeSize();
                }
                case 4: {
                    return node.getAbsoluteSize();
                }
            }
            throw new IllegalStateException("Unknown column index: " + columnIndex);
        }

        @Override
        public void setValueAt(Object value, int rowIndex, int columnIndex) {
            throw new UnsupportedOperationException("Size table models are not editable.");
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }

        @Override
        public void addTableModelListener(TableModelListener l) {
        }

        @Override
        public void removeTableModelListener(TableModelListener l) {
        }
    }
}

