/*
 * Decompiled with CFR 0.152.
 */
package com.eclipsesource.v8.utils;

import com.eclipsesource.v8.JavaVoidCallback;
import com.eclipsesource.v8.Releasable;
import com.eclipsesource.v8.V8;
import com.eclipsesource.v8.V8Array;
import com.eclipsesource.v8.V8Object;
import java.util.LinkedList;

public class V8Executor
extends Thread {
    private final String script;
    private V8 runtime;
    private String result;
    private volatile boolean terminated = false;
    private volatile boolean shuttingDown = false;
    private volatile boolean forceTerminating = false;
    private Exception exception = null;
    private LinkedList<String[]> messageQueue = new LinkedList();
    private boolean longRunning;
    private String messageHandler;

    public V8Executor(String script, boolean longRunning, String messageHandler) {
        this.script = script;
        this.longRunning = longRunning;
        this.messageHandler = messageHandler;
    }

    public V8Executor(String script) {
        this(script, false, null);
    }

    protected void setup(V8 runtime) {
    }

    public String getResult() {
        return this.result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postMessage(String ... message) {
        V8Executor v8Executor = this;
        synchronized (v8Executor) {
            this.messageQueue.add(message);
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        String[] stringArray = this;
        // MONITORENTER : this
        this.runtime = V8.createV8Runtime();
        this.runtime.registerJavaMethod((V8Executor)this.new ExecutorTermination(), "__j2v8__checkThreadTerminate");
        this.setup(this.runtime);
        // MONITOREXIT : stringArray
        try {
            Object scriptResult;
            if (!this.forceTerminating) {
                scriptResult = this.runtime.executeScript("__j2v8__checkThreadTerminate();\n" + this.script, this.getName(), -1);
                if (scriptResult != null) {
                    this.result = scriptResult.toString();
                }
                if (scriptResult instanceof Releasable) {
                    ((Releasable)scriptResult).release();
                }
                if (scriptResult instanceof Releasable) {
                    ((Releasable)scriptResult).release();
                }
            }
            while (!this.forceTerminating) {
                if (!this.longRunning) return;
                scriptResult = this;
                // MONITORENTER : this
                if (this.messageQueue.isEmpty() && !this.shuttingDown) {
                    this.wait();
                }
                if (this.messageQueue.isEmpty() && this.shuttingDown || this.forceTerminating) {
                    // MONITOREXIT : scriptResult
                    return;
                }
                // MONITOREXIT : scriptResult
                if (this.messageQueue.isEmpty()) continue;
                String[] message = this.messageQueue.remove(0);
                V8Array parameters = new V8Array(this.runtime);
                V8Array strings = new V8Array(this.runtime);
                try {
                    for (String string : message) {
                        strings.push(string);
                    }
                    parameters.push(strings);
                    this.runtime.executeVoidFunction(this.messageHandler, parameters);
                }
                finally {
                    strings.release();
                    parameters.release();
                }
            }
            return;
        }
        catch (Exception e) {
            this.exception = e;
            return;
        }
        finally {
            String[] stringArray2 = this;
        }
    }

    public boolean hasException() {
        return this.exception != null;
    }

    public Exception getException() {
        return this.exception;
    }

    public boolean hasTerminated() {
        return this.terminated;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceTermination() {
        V8Executor v8Executor = this;
        synchronized (v8Executor) {
            this.forceTerminating = true;
            this.shuttingDown = true;
            if (this.runtime != null) {
                this.runtime.terminateExecution();
            }
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        V8Executor v8Executor = this;
        synchronized (v8Executor) {
            this.shuttingDown = true;
            this.notify();
        }
    }

    public boolean isShuttingDown() {
        return this.shuttingDown;
    }

    public boolean isTerminating() {
        return this.forceTerminating;
    }

    class ExecutorTermination
    implements JavaVoidCallback {
        ExecutorTermination() {
        }

        @Override
        public void invoke(V8Object receiver, V8Array parameters) {
            if (V8Executor.this.forceTerminating) {
                throw new RuntimeException("V8Thread Termination");
            }
        }
    }
}

