/*
 * Decompiled with CFR 0.152.
 */
package guru.nidi.graphviz.engine;

import guru.nidi.graphviz.engine.EngineResult;
import guru.nidi.graphviz.engine.Format;
import guru.nidi.graphviz.engine.GraphvizPostProcessor;
import guru.nidi.graphviz.engine.Options;
import guru.nidi.graphviz.engine.ProcessOptions;
import guru.nidi.graphviz.engine.StringFunctions;
import java.util.regex.Pattern;

class SvgImagePathsRestorer
implements GraphvizPostProcessor {
    private static final Pattern LINK_PATTERN = Pattern.compile("xlink:href=\"(.+?)\"");

    SvgImagePathsRestorer() {
    }

    @Override
    public EngineResult postProcess(EngineResult result2, Options options, ProcessOptions processOptions) {
        if (options.format != Format.SVG && options.format != Format.SVG_STANDALONE) {
            return result2;
        }
        return result2.mapString(svg -> StringFunctions.replaceRegex(svg, LINK_PATTERN, options::originalImagePath));
    }
}

