/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.provider.sources.process;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.Describable;
import org.gradle.api.file.Directory;
import org.gradle.api.file.DirectoryProperty;
import org.gradle.api.provider.ListProperty;
import org.gradle.api.provider.MapProperty;
import org.gradle.api.provider.Property;
import org.gradle.api.provider.ValueSource;
import org.gradle.api.provider.ValueSourceParameters;
import org.gradle.process.ExecOperations;
import org.gradle.process.ExecResult;

public abstract class ProcessOutputValueSource
implements ValueSource<ExecOutputData, Parameters>,
Describable {
    private final ExecOperations execOperations;

    @Inject
    public ProcessOutputValueSource(ExecOperations execOperations) {
        this.execOperations = execOperations;
        if (this.hasFullEnvironment() && this.hasAdditionalEnvVars()) {
            throw new IllegalArgumentException("Providing both full environment and additional environment variables isn't supported");
        }
    }

    private boolean hasAdditionalEnvVars() {
        return ((Parameters)this.getParameters()).getAdditionalEnvironmentVariables().isPresent();
    }

    private boolean hasFullEnvironment() {
        return ((Parameters)this.getParameters()).getFullEnvironment().isPresent();
    }

    @Nullable
    public ExecOutputData obtain() {
        ByteArrayOutputStream stdout = new ByteArrayOutputStream();
        ByteArrayOutputStream stderr = new ByteArrayOutputStream();
        ExecResult r = this.execOperations.exec(spec -> {
            spec.commandLine((Iterable)((Parameters)this.getParameters()).getCommandLine().get());
            spec.setIgnoreExitValue(((Boolean)((Parameters)this.getParameters()).getIgnoreExitValue().getOrElse((Object)false)).booleanValue());
            if (((Parameters)this.getParameters()).getWorkingDirectory().isPresent()) {
                spec.setWorkingDir(((Directory)((Parameters)this.getParameters()).getWorkingDirectory().get()).getAsFile());
            }
            if (this.hasFullEnvironment()) {
                spec.setEnvironment((Map)((Parameters)this.getParameters()).getFullEnvironment().get());
            } else if (this.hasAdditionalEnvVars()) {
                spec.environment((Map)((Parameters)this.getParameters()).getAdditionalEnvironmentVariables().get());
            }
            spec.setStandardOutput((OutputStream)stdout);
            spec.setErrorOutput((OutputStream)stderr);
        });
        return new ExecOutputData(r, stdout.toByteArray(), stderr.toByteArray());
    }

    public String getDisplayName() {
        return "output of the external process '" + Parameters.getExecutable((Parameters)this.getParameters()) + "'";
    }

    public static class ExecOutputData {
        private final ExecResult result;
        private final byte[] output;
        private final byte[] error;

        public ExecOutputData(ExecResult result, byte[] output, byte[] error) {
            this.result = result;
            this.output = output;
            this.error = error;
        }

        public ExecResult getResult() {
            return this.result;
        }

        public byte[] getOutput() {
            return (byte[])this.output.clone();
        }

        public byte[] getError() {
            return (byte[])this.error.clone();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ExecOutputData that = (ExecOutputData)o;
            return this.result.getExitValue() == that.result.getExitValue() && Arrays.equals(this.output, that.output) && Arrays.equals(this.error, that.error);
        }

        public int hashCode() {
            int hash = Objects.hash(this.result);
            hash = 31 * hash + Arrays.hashCode(this.output);
            hash = 31 * hash + Arrays.hashCode(this.error);
            return hash;
        }
    }

    public static interface Parameters
    extends ValueSourceParameters {
        public ListProperty<String> getCommandLine();

        public MapProperty<String, Object> getFullEnvironment();

        public MapProperty<String, Object> getAdditionalEnvironmentVariables();

        public DirectoryProperty getWorkingDirectory();

        public Property<Boolean> getIgnoreExitValue();

        public static String getExecutable(Parameters p) {
            List command = (List)p.getCommandLine().get();
            return !command.isEmpty() ? (String)command.get(0) : "";
        }
    }
}

