/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.component;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import org.gradle.api.Action;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.component.AdhocComponentWithVariants;
import org.gradle.api.component.ConfigurationVariantDetails;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.internal.component.UsageContext;
import org.gradle.api.model.ObjectFactory;
import org.gradle.api.publish.internal.component.ConfigurationVariantMapping;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;

public class DefaultAdhocSoftwareComponent
implements AdhocComponentWithVariants,
SoftwareComponentInternal {
    private final String componentName;
    private final Map<Configuration, ConfigurationVariantMapping> variants = Maps.newLinkedHashMapWithExpectedSize((int)4);
    private final ObjectFactory objectFactory;
    private Set<UsageContext> cachedVariants;

    @Inject
    public DefaultAdhocSoftwareComponent(String componentName, ObjectFactory objectFactory) {
        this.componentName = componentName;
        this.objectFactory = objectFactory;
    }

    public String getName() {
        return this.componentName;
    }

    public void addVariantsFromConfiguration(Configuration outgoingConfiguration, Action<? super ConfigurationVariantDetails> spec) {
        this.checkNotObserved();
        this.variants.put(outgoingConfiguration, new ConfigurationVariantMapping((ConfigurationInternal)outgoingConfiguration, spec, this.objectFactory));
    }

    public void withVariantsFromConfiguration(Configuration outgoingConfiguration, Action<? super ConfigurationVariantDetails> action) {
        this.checkNotObserved();
        if (!this.variants.containsKey(outgoingConfiguration)) {
            throw new InvalidUserDataException("Variant for configuration " + outgoingConfiguration.getName() + " does not exist in component " + this.componentName);
        }
        this.variants.get(outgoingConfiguration).addAction(action);
    }

    public Set<? extends UsageContext> getUsages() {
        if (this.cachedVariants == null) {
            ImmutableSet.Builder builder = new ImmutableSet.Builder();
            for (ConfigurationVariantMapping variant : this.variants.values()) {
                variant.collectVariants(arg_0 -> ((ImmutableSet.Builder)builder).add(arg_0));
            }
            this.cachedVariants = builder.build();
        }
        return this.cachedVariants;
    }

    protected boolean isRegisteredAsLegacyVariant(Configuration outgoingConfiguration) {
        return this.variants.containsKey(outgoingConfiguration);
    }

    protected void checkNotObserved() {
        if (this.cachedVariants != null) {
            ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateBehaviour((String)"Gradle Module Metadata is modified after an eagerly populated publication.").willBecomeAnErrorInGradle9().withUpgradeGuideSection(8, "gmm_modification_after_publication_populated")).nagUser();
        }
    }
}

