/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.mapping;

import com.google.common.annotations.VisibleForTesting;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.artifacts.Configuration;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.artifacts.ImmutableModuleIdentifierFactory;
import org.gradle.api.internal.artifacts.dependencies.DefaultProjectDependencyConstraint;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.AttributeDesugaring;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.publish.internal.component.ResolutionBackedVariant;
import org.gradle.api.publish.internal.mapping.ComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.DependencyCoordinateResolverFactory;
import org.gradle.api.publish.internal.mapping.ResolutionBackedComponentDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolutionBackedVariantDependencyResolver;
import org.gradle.api.publish.internal.mapping.ResolvedCoordinates;
import org.gradle.api.publish.internal.mapping.VariantDependencyResolver;
import org.gradle.api.publish.internal.mapping.VersionMappingComponentDependencyResolver;
import org.gradle.api.publish.internal.validation.VariantWarningCollector;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.util.Path;

public class DefaultDependencyCoordinateResolverFactory
implements DependencyCoordinateResolverFactory {
    private static final boolean USE_LEGACY_VERSION_MAPPING = true;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final ImmutableModuleIdentifierFactory moduleIdentifierFactory;
    private final AttributeDesugaring attributeDesugaring;

    @Inject
    public DefaultDependencyCoordinateResolverFactory(ProjectDependencyPublicationResolver projectDependencyResolver, ImmutableModuleIdentifierFactory moduleIdentifierFactory, AttributeDesugaring attributeDesugaring) {
        this.projectDependencyResolver = projectDependencyResolver;
        this.moduleIdentifierFactory = moduleIdentifierFactory;
        this.attributeDesugaring = attributeDesugaring;
    }

    @Override
    public DependencyCoordinateResolverFactory.DependencyResolvers createCoordinateResolvers(SoftwareComponentVariant variant, VersionMappingStrategyInternal versionMappingStrategy) {
        Configuration configuration = null;
        if (variant instanceof ResolutionBackedVariant) {
            ResolutionBackedVariant resolutionBackedVariant = (ResolutionBackedVariant)variant;
            configuration = resolutionBackedVariant.getResolutionConfiguration();
            boolean useResolvedCoordinates = resolutionBackedVariant.getPublishResolvedCoordinates();
            if (useResolvedCoordinates && configuration == null) {
                throw new InvalidUserDataException("Cannot enable dependency mapping without configuring a resolution configuration.");
            }
            if (useResolvedCoordinates) {
                ResolutionBackedComponentDependencyResolver componentResolver = new ResolutionBackedComponentDependencyResolver(configuration, this.moduleIdentifierFactory, this.projectDependencyResolver);
                ResolutionBackedVariantDependencyResolver variantResolver = new ResolutionBackedVariantDependencyResolver(this.projectDependencyResolver, this.moduleIdentifierFactory, configuration, this.attributeDesugaring, componentResolver);
                return new DependencyCoordinateResolverFactory.DependencyResolvers(variantResolver, componentResolver);
            }
        }
        ImmutableAttributes attributes = ((AttributeContainerInternal)variant.getAttributes()).asImmutable();
        VariantVersionMappingStrategyInternal versionMapping = versionMappingStrategy.findStrategyForVariant(attributes);
        ComponentDependencyResolver componentResolver = null;
        if (versionMapping.isEnabled()) {
            if (versionMapping.getUserResolutionConfiguration() != null) {
                configuration = versionMapping.getUserResolutionConfiguration();
            } else if (versionMapping.getDefaultResolutionConfiguration() != null && configuration == null) {
                configuration = versionMapping.getDefaultResolutionConfiguration();
            }
            if (configuration != null) {
                componentResolver = new VersionMappingComponentDependencyResolver(this.projectDependencyResolver, configuration);
            }
        }
        if (componentResolver == null) {
            componentResolver = new ProjectOnlyComponentDependencyResolver(this.projectDependencyResolver);
        }
        return new DependencyCoordinateResolverFactory.DependencyResolvers(new VariantResolverAdapter(componentResolver), componentResolver);
    }

    @VisibleForTesting
    static class ProjectOnlyComponentDependencyResolver
    implements ComponentDependencyResolver {
        private final ProjectDependencyPublicationResolver projectDependencyResolver;

        public ProjectOnlyComponentDependencyResolver(ProjectDependencyPublicationResolver projectDependencyResolver) {
            this.projectDependencyResolver = projectDependencyResolver;
        }

        @Override
        @Nullable
        public ResolvedCoordinates resolveComponentCoordinates(ExternalDependency dependency) {
            return null;
        }

        @Override
        public ResolvedCoordinates resolveComponentCoordinates(ProjectDependency dependency) {
            Path identityPath = ((ProjectDependencyInternal)dependency).getIdentityPath();
            return ResolvedCoordinates.create((ModuleVersionIdentifier)this.projectDependencyResolver.resolveComponent(ModuleVersionIdentifier.class, identityPath));
        }

        @Override
        @Nullable
        public ResolvedCoordinates resolveComponentCoordinates(DependencyConstraint dependency) {
            return null;
        }

        @Override
        public ResolvedCoordinates resolveComponentCoordinates(DefaultProjectDependencyConstraint dependency) {
            return this.resolveComponentCoordinates(dependency.getProjectDependency());
        }
    }

    private static class VariantResolverAdapter
    implements VariantDependencyResolver {
        private final ComponentDependencyResolver delegate;

        public VariantResolverAdapter(ComponentDependencyResolver delegate) {
            this.delegate = delegate;
        }

        @Override
        @Nullable
        public ResolvedCoordinates resolveVariantCoordinates(ExternalDependency dependency, VariantWarningCollector warnings) {
            return this.delegate.resolveComponentCoordinates(dependency);
        }

        @Override
        public ResolvedCoordinates resolveVariantCoordinates(ProjectDependency dependency, VariantWarningCollector warnings) {
            return this.delegate.resolveComponentCoordinates(dependency);
        }
    }
}

