/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.ir.backend.js.utils;

import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.ir.IrElement;
import org.jetbrains.kotlin.ir.declarations.IrAnonymousInitializer;
import org.jetbrains.kotlin.ir.declarations.IrClass;
import org.jetbrains.kotlin.ir.declarations.IrConstructor;
import org.jetbrains.kotlin.ir.declarations.IrDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationBase;
import org.jetbrains.kotlin.ir.declarations.IrDeclarationWithName;
import org.jetbrains.kotlin.ir.declarations.IrEnumEntry;
import org.jetbrains.kotlin.ir.declarations.IrErrorDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrExternalPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrField;
import org.jetbrains.kotlin.ir.declarations.IrFile;
import org.jetbrains.kotlin.ir.declarations.IrFunction;
import org.jetbrains.kotlin.ir.declarations.IrLocalDelegatedProperty;
import org.jetbrains.kotlin.ir.declarations.IrModuleFragment;
import org.jetbrains.kotlin.ir.declarations.IrOverridableDeclaration;
import org.jetbrains.kotlin.ir.declarations.IrPackageFragment;
import org.jetbrains.kotlin.ir.declarations.IrProperty;
import org.jetbrains.kotlin.ir.declarations.IrScript;
import org.jetbrains.kotlin.ir.declarations.IrSimpleFunction;
import org.jetbrains.kotlin.ir.declarations.IrSymbolOwner;
import org.jetbrains.kotlin.ir.declarations.IrTypeAlias;
import org.jetbrains.kotlin.ir.declarations.IrTypeParameter;
import org.jetbrains.kotlin.ir.declarations.IrValueParameter;
import org.jetbrains.kotlin.ir.declarations.IrVariable;
import org.jetbrains.kotlin.ir.expressions.IrBlock;
import org.jetbrains.kotlin.ir.expressions.IrBlockBody;
import org.jetbrains.kotlin.ir.expressions.IrBody;
import org.jetbrains.kotlin.ir.expressions.IrBranch;
import org.jetbrains.kotlin.ir.expressions.IrBreak;
import org.jetbrains.kotlin.ir.expressions.IrBreakContinue;
import org.jetbrains.kotlin.ir.expressions.IrCall;
import org.jetbrains.kotlin.ir.expressions.IrCallableReference;
import org.jetbrains.kotlin.ir.expressions.IrCatch;
import org.jetbrains.kotlin.ir.expressions.IrClassReference;
import org.jetbrains.kotlin.ir.expressions.IrComposite;
import org.jetbrains.kotlin.ir.expressions.IrConst;
import org.jetbrains.kotlin.ir.expressions.IrConstantArray;
import org.jetbrains.kotlin.ir.expressions.IrConstantObject;
import org.jetbrains.kotlin.ir.expressions.IrConstantPrimitive;
import org.jetbrains.kotlin.ir.expressions.IrConstantValue;
import org.jetbrains.kotlin.ir.expressions.IrConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrContainerExpression;
import org.jetbrains.kotlin.ir.expressions.IrContinue;
import org.jetbrains.kotlin.ir.expressions.IrDeclarationReference;
import org.jetbrains.kotlin.ir.expressions.IrDelegatingConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrDoWhileLoop;
import org.jetbrains.kotlin.ir.expressions.IrDynamicExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicMemberExpression;
import org.jetbrains.kotlin.ir.expressions.IrDynamicOperatorExpression;
import org.jetbrains.kotlin.ir.expressions.IrElseBranch;
import org.jetbrains.kotlin.ir.expressions.IrEnumConstructorCall;
import org.jetbrains.kotlin.ir.expressions.IrErrorCallExpression;
import org.jetbrains.kotlin.ir.expressions.IrErrorExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpression;
import org.jetbrains.kotlin.ir.expressions.IrExpressionBody;
import org.jetbrains.kotlin.ir.expressions.IrFieldAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionExpression;
import org.jetbrains.kotlin.ir.expressions.IrFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrGetClass;
import org.jetbrains.kotlin.ir.expressions.IrGetEnumValue;
import org.jetbrains.kotlin.ir.expressions.IrGetField;
import org.jetbrains.kotlin.ir.expressions.IrGetObjectValue;
import org.jetbrains.kotlin.ir.expressions.IrGetSingletonValue;
import org.jetbrains.kotlin.ir.expressions.IrGetValue;
import org.jetbrains.kotlin.ir.expressions.IrInstanceInitializerCall;
import org.jetbrains.kotlin.ir.expressions.IrLocalDelegatedPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrLoop;
import org.jetbrains.kotlin.ir.expressions.IrMemberAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrPropertyReference;
import org.jetbrains.kotlin.ir.expressions.IrRawFunctionReference;
import org.jetbrains.kotlin.ir.expressions.IrReturn;
import org.jetbrains.kotlin.ir.expressions.IrSetField;
import org.jetbrains.kotlin.ir.expressions.IrSetValue;
import org.jetbrains.kotlin.ir.expressions.IrSpreadElement;
import org.jetbrains.kotlin.ir.expressions.IrStringConcatenation;
import org.jetbrains.kotlin.ir.expressions.IrSuspendableExpression;
import org.jetbrains.kotlin.ir.expressions.IrSuspensionPoint;
import org.jetbrains.kotlin.ir.expressions.IrSyntheticBody;
import org.jetbrains.kotlin.ir.expressions.IrThrow;
import org.jetbrains.kotlin.ir.expressions.IrTry;
import org.jetbrains.kotlin.ir.expressions.IrTypeOperatorCall;
import org.jetbrains.kotlin.ir.expressions.IrValueAccessExpression;
import org.jetbrains.kotlin.ir.expressions.IrVararg;
import org.jetbrains.kotlin.ir.expressions.IrWhen;
import org.jetbrains.kotlin.ir.expressions.IrWhileLoop;
import org.jetbrains.kotlin.ir.symbols.IrSymbol;
import org.jetbrains.kotlin.ir.util.IrUtilsKt;
import org.jetbrains.kotlin.ir.visitors.IrElementVisitor;
import org.jetbrains.kotlin.name.FqName;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001:\u0001\u0018B\u0013\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0002\u0010\u0007J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u000e\u0010\u000f\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\nJ\u0018\u0010\u0010\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0013\u001a\u00020\u00022\u0006\u0010\r\u001a\u00020\u00142\u0006\u0010\u0012\u001a\u00020\u0003H\u0016J\u0018\u0010\u0015\u001a\u00020\u00022\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0012\u001a\u00020\u0003H\u0016R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper;", "Lorg/jetbrains/kotlin/ir/visitors/IrElementVisitor;", "", "Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper$KeepData;", "keep", "", "", "(Ljava/util/Set;)V", "keptDeclarations", "", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclaration;", "isInKeep", "", "declaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationWithName;", "shouldKeep", "visitClass", "Lorg/jetbrains/kotlin/ir/declarations/IrClass;", "data", "visitDeclaration", "Lorg/jetbrains/kotlin/ir/declarations/IrDeclarationBase;", "visitElement", "element", "Lorg/jetbrains/kotlin/ir/IrElement;", "KeepData", "backend.js"})
@SourceDebugExtension(value={"SMAP\nKeeper.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Keeper.kt\norg/jetbrains/kotlin/ir/backend/js/utils/Keeper\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,68:1\n1747#2,3:69\n*S KotlinDebug\n*F\n+ 1 Keeper.kt\norg/jetbrains/kotlin/ir/backend/js/utils/Keeper\n*L\n18#1:69,3\n*E\n"})
public final class Keeper
implements IrElementVisitor<Unit, KeepData> {
    @NotNull
    private final Set<String> keep;
    @NotNull
    private final Set<IrDeclaration> keptDeclarations;

    public Keeper(@NotNull Set<String> keep) {
        Intrinsics.checkNotNullParameter(keep, (String)"keep");
        this.keep = keep;
        this.keptDeclarations = new LinkedHashSet();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final boolean shouldKeep(@NotNull IrDeclaration declaration) {
        IrSymbolOwner irSymbolOwner;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        if (this.keptDeclarations.contains(declaration)) return true;
        if (!(declaration instanceof IrOverridableDeclaration)) return false;
        Iterable $this$any$iv = ((IrOverridableDeclaration)declaration).getOverriddenSymbols();
        boolean $i$f$any = false;
        if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
            return false;
        }
        Iterator iterator2 = $this$any$iv.iterator();
        do {
            if (!iterator2.hasNext()) return false;
            Object element$iv = iterator2.next();
            IrSymbol it = (IrSymbol)element$iv;
            boolean bl = false;
            irSymbolOwner = it.getOwner();
            Intrinsics.checkNotNull((Object)irSymbolOwner, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.ir.declarations.IrDeclaration");
        } while (!this.shouldKeep((IrDeclaration)irSymbolOwner));
        return true;
    }

    @Override
    public void visitElement(@NotNull IrElement element, @NotNull KeepData data2) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        element.acceptChildren(this, data2);
    }

    @Override
    public void visitClass(@NotNull IrClass declaration, @NotNull KeepData data2) {
        boolean keptClass;
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        boolean prevShouldBeKept = data2.getClassShouldBeKept();
        boolean prevClassInKeep = data2.getClassInKeep();
        data2.setClassShouldBeKept(false);
        boolean bl = keptClass = data2.getClassInKeep() || this.isInKeep(declaration);
        if (keptClass) {
            this.keptDeclarations.add(declaration);
        }
        data2.setClassInKeep(keptClass);
        IrElementVisitor.DefaultImpls.visitClass(this, declaration, data2);
        if (data2.getClassShouldBeKept()) {
            this.keptDeclarations.add(declaration);
        }
        data2.setClassShouldBeKept(prevShouldBeKept);
        data2.setClassInKeep(prevClassInKeep);
    }

    @Override
    public void visitDeclaration(@NotNull IrDeclarationBase declaration, @NotNull KeepData data2) {
        Intrinsics.checkNotNullParameter((Object)declaration, (String)"declaration");
        Intrinsics.checkNotNullParameter((Object)data2, (String)"data");
        IrElementVisitor.DefaultImpls.visitDeclaration(this, declaration, data2);
        if (this.keptDeclarations.contains(declaration)) {
            return;
        }
        if (declaration instanceof IrDeclarationWithName && this.isInKeep((IrDeclarationWithName)((Object)declaration)) || data2.getClassInKeep()) {
            this.keptDeclarations.add(declaration);
            data2.setClassShouldBeKept(true);
            return;
        }
    }

    private final boolean isInKeep(IrDeclarationWithName declaration) {
        FqName fqName2 = IrUtilsKt.getFqNameWhenAvailable(declaration);
        return CollectionsKt.contains((Iterable)this.keep, (Object)(fqName2 != null ? fqName2.asString() : null));
    }

    @Override
    public void visitAnonymousInitializer(@NotNull IrAnonymousInitializer declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitAnonymousInitializer(this, declaration, data2);
    }

    @Override
    public void visitBlock(@NotNull IrBlock expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitBlock(this, expression2, data2);
    }

    @Override
    public void visitBlockBody(@NotNull IrBlockBody body2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitBlockBody(this, body2, data2);
    }

    @Override
    public void visitBody(@NotNull IrBody body2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitBody(this, body2, data2);
    }

    @Override
    public void visitBranch(@NotNull IrBranch branch, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitBranch(this, branch, data2);
    }

    @Override
    public void visitBreak(@NotNull IrBreak jump, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitBreak(this, jump, data2);
    }

    @Override
    public void visitBreakContinue(@NotNull IrBreakContinue jump, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitBreakContinue(this, jump, data2);
    }

    @Override
    public void visitCall(@NotNull IrCall expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitCall(this, expression2, data2);
    }

    @Override
    public void visitCallableReference(@NotNull IrCallableReference<?> expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitCallableReference(this, expression2, data2);
    }

    @Override
    public void visitCatch(@NotNull IrCatch aCatch, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitCatch(this, aCatch, data2);
    }

    @Override
    public void visitClassReference(@NotNull IrClassReference expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitClassReference(this, expression2, data2);
    }

    @Override
    public void visitComposite(@NotNull IrComposite expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitComposite(this, expression2, data2);
    }

    @Override
    public void visitConst(@NotNull IrConst<?> expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConst(this, expression2, data2);
    }

    @Override
    public void visitConstantArray(@NotNull IrConstantArray expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConstantArray(this, expression2, data2);
    }

    @Override
    public void visitConstantObject(@NotNull IrConstantObject expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConstantObject(this, expression2, data2);
    }

    @Override
    public void visitConstantPrimitive(@NotNull IrConstantPrimitive expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConstantPrimitive(this, expression2, data2);
    }

    @Override
    public void visitConstantValue(@NotNull IrConstantValue expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConstantValue(this, expression2, data2);
    }

    @Override
    public void visitConstructor(@NotNull IrConstructor declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConstructor(this, declaration, data2);
    }

    @Override
    public void visitConstructorCall(@NotNull IrConstructorCall expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitContainerExpression(@NotNull IrContainerExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitContainerExpression(this, expression2, data2);
    }

    @Override
    public void visitContinue(@NotNull IrContinue jump, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitContinue(this, jump, data2);
    }

    @Override
    public void visitDeclarationReference(@NotNull IrDeclarationReference expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitDeclarationReference(this, expression2, data2);
    }

    @Override
    public void visitDelegatingConstructorCall(@NotNull IrDelegatingConstructorCall expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitDelegatingConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitDoWhileLoop(@NotNull IrDoWhileLoop loop2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitDoWhileLoop(this, loop2, data2);
    }

    @Override
    public void visitDynamicExpression(@NotNull IrDynamicExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitDynamicExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicMemberExpression(@NotNull IrDynamicMemberExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitDynamicMemberExpression(this, expression2, data2);
    }

    @Override
    public void visitDynamicOperatorExpression(@NotNull IrDynamicOperatorExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitDynamicOperatorExpression(this, expression2, data2);
    }

    @Override
    public void visitElseBranch(@NotNull IrElseBranch branch, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitElseBranch(this, branch, data2);
    }

    @Override
    public void visitEnumConstructorCall(@NotNull IrEnumConstructorCall expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitEnumConstructorCall(this, expression2, data2);
    }

    @Override
    public void visitEnumEntry(@NotNull IrEnumEntry declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitEnumEntry(this, declaration, data2);
    }

    @Override
    public void visitErrorCallExpression(@NotNull IrErrorCallExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitErrorCallExpression(this, expression2, data2);
    }

    @Override
    public void visitErrorDeclaration(@NotNull IrErrorDeclaration declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitErrorDeclaration(this, declaration, data2);
    }

    @Override
    public void visitErrorExpression(@NotNull IrErrorExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitErrorExpression(this, expression2, data2);
    }

    @Override
    public void visitExpression(@NotNull IrExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitExpression(this, expression2, data2);
    }

    @Override
    public void visitExpressionBody(@NotNull IrExpressionBody body2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitExpressionBody(this, body2, data2);
    }

    @Override
    public void visitExternalPackageFragment(@NotNull IrExternalPackageFragment declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitExternalPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitField(@NotNull IrField declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitField(this, declaration, data2);
    }

    @Override
    public void visitFieldAccess(@NotNull IrFieldAccessExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitFieldAccess(this, expression2, data2);
    }

    @Override
    public void visitFile(@NotNull IrFile declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitFile(this, declaration, data2);
    }

    @Override
    public void visitFunction(@NotNull IrFunction declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitFunction(this, declaration, data2);
    }

    @Override
    public void visitFunctionAccess(@NotNull IrFunctionAccessExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitFunctionAccess(this, expression2, data2);
    }

    @Override
    public void visitFunctionExpression(@NotNull IrFunctionExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitFunctionExpression(this, expression2, data2);
    }

    @Override
    public void visitFunctionReference(@NotNull IrFunctionReference expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitGetClass(@NotNull IrGetClass expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitGetClass(this, expression2, data2);
    }

    @Override
    public void visitGetEnumValue(@NotNull IrGetEnumValue expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitGetEnumValue(this, expression2, data2);
    }

    @Override
    public void visitGetField(@NotNull IrGetField expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitGetField(this, expression2, data2);
    }

    @Override
    public void visitGetObjectValue(@NotNull IrGetObjectValue expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitGetObjectValue(this, expression2, data2);
    }

    @Override
    public void visitGetValue(@NotNull IrGetValue expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitGetValue(this, expression2, data2);
    }

    @Override
    public void visitInstanceInitializerCall(@NotNull IrInstanceInitializerCall expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitInstanceInitializerCall(this, expression2, data2);
    }

    @Override
    public void visitLocalDelegatedProperty(@NotNull IrLocalDelegatedProperty declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedProperty(this, declaration, data2);
    }

    @Override
    public void visitLocalDelegatedPropertyReference(@NotNull IrLocalDelegatedPropertyReference expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitLocalDelegatedPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitLoop(@NotNull IrLoop loop2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitLoop(this, loop2, data2);
    }

    @Override
    public void visitMemberAccess(@NotNull IrMemberAccessExpression<?> expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitMemberAccess(this, expression2, data2);
    }

    @Override
    public void visitModuleFragment(@NotNull IrModuleFragment declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitModuleFragment(this, declaration, data2);
    }

    @Override
    public void visitPackageFragment(@NotNull IrPackageFragment declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitPackageFragment(this, declaration, data2);
    }

    @Override
    public void visitProperty(@NotNull IrProperty declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitProperty(this, declaration, data2);
    }

    @Override
    public void visitPropertyReference(@NotNull IrPropertyReference expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitPropertyReference(this, expression2, data2);
    }

    @Override
    public void visitRawFunctionReference(@NotNull IrRawFunctionReference expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitRawFunctionReference(this, expression2, data2);
    }

    @Override
    public void visitReturn(@NotNull IrReturn expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitReturn(this, expression2, data2);
    }

    @Override
    public void visitScript(@NotNull IrScript declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitScript(this, declaration, data2);
    }

    @Override
    public void visitSetField(@NotNull IrSetField expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSetField(this, expression2, data2);
    }

    @Override
    public void visitSetValue(@NotNull IrSetValue expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSetValue(this, expression2, data2);
    }

    @Override
    public void visitSimpleFunction(@NotNull IrSimpleFunction declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSimpleFunction(this, declaration, data2);
    }

    @Override
    public void visitSingletonReference(@NotNull IrGetSingletonValue expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSingletonReference(this, expression2, data2);
    }

    @Override
    public void visitSpreadElement(@NotNull IrSpreadElement spread, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSpreadElement(this, spread, data2);
    }

    @Override
    public void visitStringConcatenation(@NotNull IrStringConcatenation expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitStringConcatenation(this, expression2, data2);
    }

    @Override
    public void visitSuspendableExpression(@NotNull IrSuspendableExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSuspendableExpression(this, expression2, data2);
    }

    @Override
    public void visitSuspensionPoint(@NotNull IrSuspensionPoint expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSuspensionPoint(this, expression2, data2);
    }

    @Override
    public void visitSyntheticBody(@NotNull IrSyntheticBody body2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitSyntheticBody(this, body2, data2);
    }

    @Override
    public void visitThrow(@NotNull IrThrow expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitThrow(this, expression2, data2);
    }

    @Override
    public void visitTry(@NotNull IrTry aTry, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitTry(this, aTry, data2);
    }

    @Override
    public void visitTypeAlias(@NotNull IrTypeAlias declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitTypeAlias(this, declaration, data2);
    }

    @Override
    public void visitTypeOperator(@NotNull IrTypeOperatorCall expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitTypeOperator(this, expression2, data2);
    }

    @Override
    public void visitTypeParameter(@NotNull IrTypeParameter declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitTypeParameter(this, declaration, data2);
    }

    @Override
    public void visitValueAccess(@NotNull IrValueAccessExpression expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitValueAccess(this, expression2, data2);
    }

    @Override
    public void visitValueParameter(@NotNull IrValueParameter declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitValueParameter(this, declaration, data2);
    }

    @Override
    public void visitVararg(@NotNull IrVararg expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitVararg(this, expression2, data2);
    }

    @Override
    public void visitVariable(@NotNull IrVariable declaration, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitVariable(this, declaration, data2);
    }

    @Override
    public void visitWhen(@NotNull IrWhen expression2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitWhen(this, expression2, data2);
    }

    @Override
    public void visitWhileLoop(@NotNull IrWhileLoop loop2, @NotNull KeepData data2) {
        IrElementVisitor.DefaultImpls.visitWhileLoop(this, loop2, data2);
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\t\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u0007\"\u0004\b\u000b\u0010\t\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/ir/backend/js/utils/Keeper$KeepData;", "", "classInKeep", "", "classShouldBeKept", "(ZZ)V", "getClassInKeep", "()Z", "setClassInKeep", "(Z)V", "getClassShouldBeKept", "setClassShouldBeKept", "backend.js"})
    public static final class KeepData {
        private boolean classInKeep;
        private boolean classShouldBeKept;

        public KeepData(boolean classInKeep, boolean classShouldBeKept) {
            this.classInKeep = classInKeep;
            this.classShouldBeKept = classShouldBeKept;
        }

        public final boolean getClassInKeep() {
            return this.classInKeep;
        }

        public final void setClassInKeep(boolean bl) {
            this.classInKeep = bl;
        }

        public final boolean getClassShouldBeKept() {
            return this.classShouldBeKept;
        }

        public final void setClassShouldBeKept(boolean bl) {
            this.classShouldBeKept = bl;
        }
    }
}

