/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.execution;

import com.google.common.collect.ImmutableSortedMap;
import java.io.File;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.gradle.api.Describable;
import org.gradle.api.file.FileCollection;
import org.gradle.internal.execution.InputFingerprinter;
import org.gradle.internal.execution.WorkValidationContext;
import org.gradle.internal.execution.caching.CachingDisabledReason;
import org.gradle.internal.execution.caching.CachingState;
import org.gradle.internal.execution.history.OverlappingOutputs;
import org.gradle.internal.execution.history.changes.InputChangesInternal;
import org.gradle.internal.execution.workspace.WorkspaceProvider;
import org.gradle.internal.file.TreeType;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.DirectorySensitivity;
import org.gradle.internal.fingerprint.FileNormalizer;
import org.gradle.internal.fingerprint.LineEndingSensitivity;
import org.gradle.internal.properties.InputBehavior;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.ValueSnapshot;
import org.gradle.internal.snapshot.impl.ImplementationSnapshot;

public interface UnitOfWork
extends Describable {
    default public Optional<String> getBuildOperationWorkType() {
        return Optional.empty();
    }

    public Identity identify(Map<String, ValueSnapshot> var1, Map<String, CurrentFileCollectionFingerprint> var2);

    public WorkOutput execute(ExecutionRequest var1);

    @Nullable
    public Object loadAlreadyProducedOutput(File var1);

    public WorkspaceProvider getWorkspaceProvider();

    default public Optional<Duration> getTimeout() {
        return Optional.empty();
    }

    default public ExecutionBehavior getExecutionBehavior() {
        return ExecutionBehavior.NON_INCREMENTAL;
    }

    default public void visitImplementations(ImplementationVisitor visitor) {
        visitor.visitImplementation(this.getClass());
    }

    public InputFingerprinter getInputFingerprinter();

    default public void visitIdentityInputs(InputVisitor visitor) {
    }

    default public void visitRegularInputs(InputVisitor visitor) {
    }

    public void visitOutputs(File var1, OutputVisitor var2);

    default public Optional<CachingDisabledReason> shouldDisableCaching(@Nullable OverlappingOutputs detectedOverlappingOutputs) {
        return Optional.empty();
    }

    default public boolean isAllowedToLoadFromCache() {
        return true;
    }

    default public OverlappingOutputHandling getOverlappingOutputHandling() {
        return OverlappingOutputHandling.IGNORE_OVERLAPS;
    }

    default public void validate(WorkValidationContext validationContext) {
    }

    default public boolean shouldCleanupOutputsOnNonIncrementalExecution() {
        return true;
    }

    default public boolean shouldCleanupStaleOutputs() {
        return false;
    }

    default public void markLegacySnapshottingInputsStarted() {
    }

    default public void markLegacySnapshottingInputsFinished(CachingState cachingState) {
    }

    default public void ensureLegacySnapshottingInputsClosed() {
    }

    default public WorkValidationContext.TypeOriginInspector getTypeOriginInspector() {
        return WorkValidationContext.TypeOriginInspector.NO_OP;
    }

    public static enum OverlappingOutputHandling {
        DETECT_OVERLAPS,
        IGNORE_OVERLAPS;

    }

    public static interface OutputVisitor {
        default public void visitOutputProperty(String propertyName, TreeType type, OutputFileValueSupplier value) {
        }

        default public void visitLocalState(File localStateRoot) {
        }

        default public void visitDestroyable(File destroyableRoot) {
        }
    }

    public static abstract class OutputFileValueSupplier
    implements FileValueSupplier {
        private final FileCollection files;

        public OutputFileValueSupplier(FileCollection files) {
            this.files = files;
        }

        public static OutputFileValueSupplier fromStatic(final File root, FileCollection fileCollection) {
            return new OutputFileValueSupplier(fileCollection){

                @Override
                @Nonnull
                public File getValue() {
                    return root;
                }
            };
        }

        public static OutputFileValueSupplier fromSupplier(final Supplier<File> root, FileCollection fileCollection) {
            return new OutputFileValueSupplier(fileCollection){

                @Override
                @Nonnull
                public File getValue() {
                    return (File)root.get();
                }
            };
        }

        @Override
        @Nonnull
        public abstract File getValue();

        @Override
        public FileCollection getFiles() {
            return this.files;
        }
    }

    public static class InputFileValueSupplier
    implements FileValueSupplier {
        private final Object value;
        private final FileNormalizer normalizer;
        private final DirectorySensitivity directorySensitivity;
        private final LineEndingSensitivity lineEndingSensitivity;
        private final Supplier<FileCollection> files;

        public InputFileValueSupplier(@Nullable Object value, FileNormalizer normalizer, DirectorySensitivity directorySensitivity, LineEndingSensitivity lineEndingSensitivity, Supplier<FileCollection> files) {
            this.value = value;
            this.normalizer = normalizer;
            this.directorySensitivity = directorySensitivity;
            this.lineEndingSensitivity = lineEndingSensitivity;
            this.files = files;
        }

        @Override
        @Nullable
        public Object getValue() {
            return this.value;
        }

        public FileNormalizer getNormalizer() {
            return this.normalizer;
        }

        public DirectorySensitivity getDirectorySensitivity() {
            return this.directorySensitivity;
        }

        public LineEndingSensitivity getLineEndingNormalization() {
            return this.lineEndingSensitivity;
        }

        @Override
        public FileCollection getFiles() {
            return this.files.get();
        }
    }

    public static interface FileValueSupplier
    extends ValueSupplier {
        public FileCollection getFiles();
    }

    public static interface ValueSupplier {
        @Nullable
        public Object getValue();
    }

    public static interface InputVisitor {
        default public void visitInputProperty(String propertyName, ValueSupplier value) {
        }

        default public void visitInputFileProperty(String propertyName, InputBehavior behavior, InputFileValueSupplier value) {
        }
    }

    public static interface ImplementationVisitor {
        public void visitImplementation(Class<?> var1);

        public void visitImplementation(ImplementationSnapshot var1);
    }

    public static enum ExecutionBehavior {
        INCREMENTAL,
        NON_INCREMENTAL;

    }

    public static enum WorkResult {
        DID_WORK,
        DID_NO_WORK;

    }

    public static interface WorkOutput {
        public WorkResult getDidWork();

        @Nullable
        public Object getOutput();

        default public boolean canStoreInCache() {
            return true;
        }
    }

    public static interface ExecutionRequest {
        public File getWorkspace();

        public Optional<InputChangesInternal> getInputChanges();

        public Optional<ImmutableSortedMap<String, FileSystemSnapshot>> getPreviouslyProducedOutputs();
    }

    public static interface Identity {
        public String getUniqueId();
    }
}

