/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.file.copy;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.gradle.api.Transformer;

public class RegExpNameMapper
implements Transformer<String, String> {
    private final Pattern pattern;
    private transient Matcher matcher;
    private final String replacement;

    public RegExpNameMapper(String sourceRegEx, String replaceWith) {
        this(Pattern.compile(sourceRegEx), replaceWith);
    }

    public RegExpNameMapper(Pattern sourceRegEx, String replaceWith) {
        this.pattern = sourceRegEx;
        this.replacement = replaceWith;
    }

    public String transform(String source) {
        if (this.matcher == null) {
            this.matcher = this.pattern.matcher(source);
        } else {
            this.matcher.reset(source);
        }
        String result = source;
        if (this.matcher.find()) {
            result = this.matcher.replaceFirst(this.replacement);
        }
        return result;
    }
}

