/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transport.http;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Iterables;
import java.io.Closeable;
import java.io.IOException;
import java.net.SocketException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.transport.http.HttpClientConfigurer;
import org.gradle.internal.resource.transport.http.HttpClientResponse;
import org.gradle.internal.resource.transport.http.HttpErrorStatusCodeException;
import org.gradle.internal.resource.transport.http.HttpRequestException;
import org.gradle.internal.resource.transport.http.HttpSettings;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpClientHelper
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(HttpClientHelper.class);
    private CloseableHttpClient client;
    private final DocumentationRegistry documentationRegistry;
    private final HttpSettings settings;
    private Collection<String> supportedTlsVersions;
    private final ConcurrentLinkedQueue<HttpContext> sharedContext;

    @VisibleForTesting
    HttpClientHelper(DocumentationRegistry documentationRegistry, HttpSettings settings) {
        this.documentationRegistry = documentationRegistry;
        this.settings = settings;
        this.sharedContext = !settings.getAuthenticationSettings().isEmpty() ? new ConcurrentLinkedQueue() : null;
    }

    private HttpClientResponse performRawHead(String source, boolean revalidate) {
        return this.performRequest((HttpRequestBase)new HttpHead(source), revalidate);
    }

    public HttpClientResponse performHead(String source, boolean revalidate) {
        return this.processResponse(this.performRawHead(source, revalidate));
    }

    HttpClientResponse performRawGet(String source, boolean revalidate) {
        return this.performRequest((HttpRequestBase)new HttpGet(source), revalidate);
    }

    @Nonnull
    public HttpClientResponse performGet(String source, boolean revalidate) {
        return this.processResponse(this.performRawGet(source, revalidate));
    }

    public HttpClientResponse performRequest(HttpRequestBase request, boolean revalidate) {
        String method = request.getMethod();
        if (revalidate) {
            request.addHeader("Cache-Control", "max-age=0");
        }
        try {
            return this.executeGetOrHead(request);
        }
        catch (FailureFromRedirectLocation e) {
            throw HttpClientHelper.createHttpRequestException(method, e.getCause(), e.getLastRedirectLocation());
        }
        catch (IOException e) {
            throw HttpClientHelper.createHttpRequestException(method, this.wrapWithExplanation(e), request.getURI());
        }
    }

    @Nonnull
    private static HttpRequestException createHttpRequestException(String method, Throwable cause, URI uri) {
        return new HttpRequestException(String.format("Could not %s '%s'.", method, HttpClientHelper.stripUserCredentials(uri)), cause);
    }

    private Exception wrapWithExplanation(IOException e) {
        if (e instanceof SocketException || e instanceof SSLException && e.getMessage().contains("readHandshakeRecord")) {
            return new HttpRequestException("Got socket exception during request. It might be caused by SSL misconfiguration", e);
        }
        if (!(e instanceof SSLHandshakeException)) {
            return e;
        }
        SSLHandshakeException sslException = (SSLHandshakeException)e;
        String message = e.getMessage().contains("PKIX path building failed") || e.getMessage().contains("certificate_unknown") ? "Got SSL handshake exception during request. It might be caused by SSL misconfiguration" : String.format("The server %s not support the client's requested TLS protocol versions: (%s). You may need to configure the client to allow other protocols to be used. %s", HttpClientHelper.getConfidenceNote(sslException), String.join((CharSequence)", ", this.supportedTlsVersions), this.documentationRegistry.getDocumentationRecommendationFor("on this", "build_environment", "sec:gradle_system_properties"));
        return new HttpRequestException(message, e);
    }

    @Nonnull
    private static String getConfidenceNote(SSLHandshakeException sslException) {
        if (sslException.getMessage() != null && sslException.getMessage().contains("protocol_version")) {
            return "does";
        }
        return "may";
    }

    protected HttpClientResponse executeGetOrHead(HttpRequestBase method) throws IOException {
        HttpClientResponse response = this.performHttpRequest(method);
        if (!response.wasSuccessful()) {
            response.close();
        }
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HttpClientResponse performHttpRequest(HttpRequestBase request) throws IOException {
        if (this.sharedContext == null) {
            return this.performHttpRequest(request, (HttpContext)new BasicHttpContext());
        }
        HttpContext httpContext = this.nextAvailableSharedContext();
        try {
            HttpClientResponse httpClientResponse = this.performHttpRequest(request, httpContext);
            return httpClientResponse;
        }
        finally {
            this.sharedContext.add(httpContext);
        }
    }

    private HttpContext nextAvailableSharedContext() {
        HttpContext context = this.sharedContext.poll();
        if (context == null) {
            return new BasicHttpContext();
        }
        return context;
    }

    private HttpClientResponse performHttpRequest(HttpRequestBase request, HttpContext httpContext) throws IOException {
        httpContext.removeAttribute("http.protocol.redirect-locations");
        LOGGER.debug("Performing HTTP {}: {}", (Object)request.getMethod(), (Object)HttpClientHelper.stripUserCredentials(request.getURI()));
        try {
            CloseableHttpResponse response = this.getClient().execute((HttpUriRequest)request, httpContext);
            return this.toHttpClientResponse(request, httpContext, response);
        }
        catch (IOException e) {
            this.validateRedirectChain(httpContext);
            URI lastRedirectLocation = HttpClientHelper.stripUserCredentials(HttpClientHelper.getLastRedirectLocation(httpContext));
            throw lastRedirectLocation == null ? e : new FailureFromRedirectLocation(lastRedirectLocation, e);
        }
    }

    private HttpClientResponse toHttpClientResponse(HttpRequestBase request, HttpContext httpContext, CloseableHttpResponse response) {
        this.validateRedirectChain(httpContext);
        URI lastRedirectLocation = HttpClientHelper.getLastRedirectLocation(httpContext);
        URI effectiveUri = lastRedirectLocation == null ? request.getURI() : lastRedirectLocation;
        return new HttpClientResponse(request.getMethod(), effectiveUri, response);
    }

    private void validateRedirectChain(HttpContext httpContext) {
        this.settings.getRedirectVerifier().validateRedirects(HttpClientHelper.getRedirectLocations(httpContext));
    }

    @Nonnull
    private static List<URI> getRedirectLocations(HttpContext httpContext) {
        List redirects = (List)httpContext.getAttribute("http.protocol.redirect-locations");
        return redirects == null ? Collections.emptyList() : redirects;
    }

    private static URI getLastRedirectLocation(HttpContext httpContext) {
        List<URI> redirectLocations = HttpClientHelper.getRedirectLocations(httpContext);
        return redirectLocations.isEmpty() ? null : (URI)Iterables.getLast(redirectLocations);
    }

    @Nonnull
    private HttpClientResponse processResponse(HttpClientResponse response) {
        if (response.wasMissing()) {
            LOGGER.info("Resource missing. [HTTP {}: {}]", (Object)response.getMethod(), (Object)HttpClientHelper.stripUserCredentials(response.getEffectiveUri()));
            return response;
        }
        if (response.wasSuccessful()) {
            return response;
        }
        URI effectiveUri = HttpClientHelper.stripUserCredentials(response.getEffectiveUri());
        LOGGER.info("Failed to get resource: {}. [HTTP {}: {})]", new Object[]{response.getMethod(), response.getStatusLine(), effectiveUri});
        throw new HttpErrorStatusCodeException(response.getMethod(), effectiveUri.toString(), response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase());
    }

    private synchronized CloseableHttpClient getClient() {
        if (this.client == null) {
            HttpClientBuilder builder = HttpClientBuilder.create();
            HttpClientConfigurer configurer = new HttpClientConfigurer(this.settings);
            configurer.configure(builder);
            this.supportedTlsVersions = configurer.supportedTlsVersions();
            this.client = builder.build();
        }
        return this.client;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.client != null) {
            this.client.close();
            if (this.sharedContext != null) {
                this.sharedContext.clear();
            }
        }
    }

    @Nullable
    @VisibleForTesting
    static URI stripUserCredentials(@CheckForNull URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URIBuilder(uri).setUserInfo(null).build();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException((Throwable)e, (boolean)true);
        }
    }

    @FunctionalInterface
    public static interface Factory {
        public HttpClientHelper create(HttpSettings var1);

        public static Factory createFactory(DocumentationRegistry documentationRegistry) {
            return settings -> new HttpClientHelper(documentationRegistry, settings);
        }
    }

    private static class FailureFromRedirectLocation
    extends IOException {
        private final URI lastRedirectLocation;

        private FailureFromRedirectLocation(URI lastRedirectLocation, Throwable cause) {
            super(cause);
            this.lastRedirectLocation = lastRedirectLocation;
        }

        private URI getLastRedirectLocation() {
            return this.lastRedirectLocation;
        }
    }
}

