/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.ivy.internal.publication;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.artifacts.DependencyConstraint;
import org.gradle.api.artifacts.ExcludeRule;
import org.gradle.api.artifacts.ExternalDependency;
import org.gradle.api.artifacts.ModuleDependency;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.ProjectDependency;
import org.gradle.api.artifacts.PublishArtifact;
import org.gradle.api.attributes.HasConfigurableAttributes;
import org.gradle.api.capabilities.Capability;
import org.gradle.api.component.SoftwareComponentVariant;
import org.gradle.api.internal.CollectionCallbackActionDecorator;
import org.gradle.api.internal.DocumentationRegistry;
import org.gradle.api.internal.artifacts.dependencies.ProjectDependencyInternal;
import org.gradle.api.internal.artifacts.dsl.dependencies.PlatformSupport;
import org.gradle.api.internal.artifacts.ivyservice.projectmodule.ProjectDependencyPublicationResolver;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.attributes.ImmutableAttributes;
import org.gradle.api.internal.component.SoftwareComponentInternal;
import org.gradle.api.logging.Logger;
import org.gradle.api.logging.Logging;
import org.gradle.api.publish.internal.component.IvyPublishingAwareVariant;
import org.gradle.api.publish.internal.validation.PublicationErrorChecker;
import org.gradle.api.publish.internal.validation.PublicationWarningsCollector;
import org.gradle.api.publish.internal.versionmapping.VariantVersionMappingStrategyInternal;
import org.gradle.api.publish.internal.versionmapping.VersionMappingStrategyInternal;
import org.gradle.api.publish.ivy.IvyArtifact;
import org.gradle.api.publish.ivy.IvyConfiguration;
import org.gradle.api.publish.ivy.IvyConfigurationContainer;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyDependencySet;
import org.gradle.api.publish.ivy.internal.dependency.DefaultIvyExcludeRule;
import org.gradle.api.publish.ivy.internal.dependency.IvyDependency;
import org.gradle.api.publish.ivy.internal.dependency.IvyExcludeRule;
import org.gradle.api.publish.ivy.internal.publication.DefaultIvyConfigurationContainer;
import org.gradle.internal.reflect.Instantiator;
import org.gradle.internal.typeconversion.NotationParser;
import org.gradle.util.Path;

public class IvyComponentParser {
    @VisibleForTesting
    public static final String UNSUPPORTED_FEATURE = " contains dependencies that cannot be represented in a published ivy descriptor.";
    @VisibleForTesting
    public static final String PUBLICATION_WARNING_FOOTER = "These issues indicate information that is lost in the published 'ivy.xml' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Ivy.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.";
    private static final Logger LOG = Logging.getLogger(IvyComponentParser.class);
    private static final String API_VARIANT = "api";
    private static final String API_ELEMENTS_VARIANT = "apiElements";
    private static final String RUNTIME_VARIANT = "runtime";
    private static final String RUNTIME_ELEMENTS_VARIANT = "runtimeElements";
    private final Instantiator instantiator;
    private final PlatformSupport platformSupport;
    private final ProjectDependencyPublicationResolver projectDependencyResolver;
    private final NotationParser<Object, IvyArtifact> ivyArtifactParser;
    private final DocumentationRegistry documentationRegistry;
    private final CollectionCallbackActionDecorator collectionCallbackActionDecorator;
    private final PublicationWarningsCollector publicationWarningsCollector = new PublicationWarningsCollector(LOG, " contains dependencies that cannot be represented in a published ivy descriptor.", "", "These issues indicate information that is lost in the published 'ivy.xml' metadata file, which may be an issue if the published library is consumed by an old Gradle version or Apache Ivy.\nThe 'module' metadata file, which is used by Gradle 6+ is not affected.", "suppressIvyMetadataWarningsFor");

    public IvyComponentParser(Instantiator instantiator, PlatformSupport platformSupport, ProjectDependencyPublicationResolver projectDependencyResolver, NotationParser<Object, IvyArtifact> ivyArtifactParser, DocumentationRegistry documentationRegistry, CollectionCallbackActionDecorator collectionCallbackActionDecorator) {
        this.instantiator = instantiator;
        this.platformSupport = platformSupport;
        this.projectDependencyResolver = projectDependencyResolver;
        this.ivyArtifactParser = ivyArtifactParser;
        this.documentationRegistry = documentationRegistry;
        this.collectionCallbackActionDecorator = collectionCallbackActionDecorator;
    }

    public IvyConfigurationContainer parseConfigurations(SoftwareComponentInternal component) {
        IvyConfigurationContainer configurations = (IvyConfigurationContainer)this.instantiator.newInstance(DefaultIvyConfigurationContainer.class, new Object[]{this.instantiator, this.collectionCallbackActionDecorator});
        IvyConfiguration defaultConfiguration = (IvyConfiguration)configurations.maybeCreate("default");
        for (SoftwareComponentVariant variant : component.getUsages()) {
            String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
            configurations.maybeCreate(conf);
            if (!IvyComponentParser.defaultShouldExtend(variant)) continue;
            defaultConfiguration.extend(conf);
        }
        return configurations;
    }

    private static boolean defaultShouldExtend(SoftwareComponentVariant variant) {
        if (!(variant instanceof IvyPublishingAwareVariant)) {
            return true;
        }
        if (((IvyPublishingAwareVariant)variant).isOptional()) {
            return false;
        }
        return !IvyComponentParser.isJavaApiVariant(variant.getName());
    }

    private static boolean isJavaRuntimeVariant(String variantName) {
        return RUNTIME_VARIANT.equals(variantName) || RUNTIME_ELEMENTS_VARIANT.equals(variantName);
    }

    private static boolean isJavaApiVariant(String variantName) {
        return API_VARIANT.equals(variantName) || API_ELEMENTS_VARIANT.equals(variantName);
    }

    public Set<IvyArtifact> parseArtifacts(SoftwareComponentInternal component) {
        LinkedHashSet<IvyArtifact> artifacts = new LinkedHashSet<IvyArtifact>();
        HashMap seenArtifacts = Maps.newHashMap();
        for (SoftwareComponentVariant variant : component.getUsages()) {
            String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
            for (PublishArtifact publishArtifact : variant.getArtifacts()) {
                String key = IvyComponentParser.artifactKey(publishArtifact);
                IvyArtifact ivyArtifact = (IvyArtifact)seenArtifacts.get(key);
                if (ivyArtifact == null) {
                    ivyArtifact = (IvyArtifact)this.ivyArtifactParser.parseNotation((Object)publishArtifact);
                    ivyArtifact.setConf(conf);
                    seenArtifacts.put(key, ivyArtifact);
                    artifacts.add(ivyArtifact);
                    continue;
                }
                ivyArtifact.setConf(ivyArtifact.getConf() + "," + conf);
            }
        }
        return artifacts;
    }

    private static String artifactKey(PublishArtifact publishArtifact) {
        return publishArtifact.getName() + ":" + publishArtifact.getType() + ":" + publishArtifact.getExtension() + ":" + publishArtifact.getClassifier();
    }

    public DependencyResult parseDependencies(SoftwareComponentInternal component, VersionMappingStrategyInternal versionMappingStrategy) {
        PublicationErrorChecker.checkForUnpublishableAttributes((SoftwareComponentInternal)component, (DocumentationRegistry)this.documentationRegistry);
        DefaultIvyDependencySet ivyDependencies = (DefaultIvyDependencySet)((Object)this.instantiator.newInstance(DefaultIvyDependencySet.class, new Object[]{this.collectionCallbackActionDecorator}));
        for (SoftwareComponentVariant variant : component.getUsages()) {
            this.publicationWarningsCollector.newContext(variant.getName());
            ImmutableAttributes attributes = ((AttributeContainerInternal)variant.getAttributes()).asImmutable();
            VariantVersionMappingStrategyInternal variantVersionMappingStrategy = versionMappingStrategy.findStrategyForVariant(attributes);
            VariantDependencyFactory dependencyFactory = new VariantDependencyFactory(this.projectDependencyResolver, variantVersionMappingStrategy, this.publicationWarningsCollector);
            for (ModuleDependency dependency : variant.getDependencies()) {
                String confMapping = IvyComponentParser.confMappingFor(variant, dependency);
                if (!dependency.getAttributes().isEmpty()) {
                    this.publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared with Gradle attributes", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                if (dependency instanceof ProjectDependency) {
                    ivyDependencies.add(dependencyFactory.asProjectDependency((ProjectDependency)dependency, confMapping));
                    continue;
                }
                ExternalDependency externalDependency = (ExternalDependency)dependency;
                if (this.platformSupport.isTargetingPlatform((HasConfigurableAttributes)dependency)) {
                    this.publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared as platform", dependency.getGroup(), dependency.getName(), dependency.getVersion()));
                }
                ivyDependencies.add(dependencyFactory.asExternalDependency(externalDependency, confMapping));
            }
            if (!variant.getDependencyConstraints().isEmpty()) {
                for (DependencyConstraint constraint : variant.getDependencyConstraints()) {
                    this.publicationWarningsCollector.addUnsupported(String.format("%s:%s:%s declared as a dependency constraint", constraint.getGroup(), constraint.getName(), constraint.getVersion()));
                }
            }
            if (variant.getCapabilities().isEmpty()) continue;
            for (Capability capability : variant.getCapabilities()) {
                this.publicationWarningsCollector.addVariantUnsupported(String.format("Declares capability %s:%s:%s which cannot be mapped to Ivy", capability.getGroup(), capability.getName(), capability.getVersion()));
            }
        }
        return new DependencyResult(ivyDependencies, this.publicationWarningsCollector);
    }

    public Set<IvyExcludeRule> parseGlobalExcludes(SoftwareComponentInternal component) {
        LinkedHashSet<IvyExcludeRule> globalExcludes = new LinkedHashSet<IvyExcludeRule>();
        for (SoftwareComponentVariant variant : component.getUsages()) {
            String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
            for (ExcludeRule excludeRule : variant.getGlobalExcludes()) {
                globalExcludes.add(new DefaultIvyExcludeRule(excludeRule, conf));
            }
        }
        return globalExcludes;
    }

    private static String confMappingFor(SoftwareComponentVariant variant, ModuleDependency dependency) {
        String conf = IvyComponentParser.mapVariantNameToIvyConfiguration(variant.getName());
        String targetConfiguration = dependency.getTargetConfiguration();
        String confMappingTarget = targetConfiguration == null ? "default" : IvyComponentParser.mapVariantNameToIvyConfiguration(dependency.getTargetConfiguration());
        return conf + "->" + confMappingTarget;
    }

    private static String mapVariantNameToIvyConfiguration(String variantName) {
        if (IvyComponentParser.isJavaApiVariant(variantName)) {
            return "compile";
        }
        if (IvyComponentParser.isJavaRuntimeVariant(variantName)) {
            return RUNTIME_VARIANT;
        }
        return variantName;
    }

    public static class DependencyResult {
        private final DefaultIvyDependencySet dependencies;
        private final PublicationWarningsCollector warnings;

        public DependencyResult(DefaultIvyDependencySet ivyDependencies, PublicationWarningsCollector warnings) {
            this.dependencies = ivyDependencies;
            this.warnings = warnings;
        }

        public DefaultIvyDependencySet getDependencies() {
            return this.dependencies;
        }

        public PublicationWarningsCollector getWarnings() {
            return this.warnings;
        }
    }

    private static class VariantDependencyFactory {
        private final ProjectDependencyPublicationResolver projectDependencyResolver;
        private final VariantVersionMappingStrategyInternal versionMappingStrategy;
        private final PublicationWarningsCollector publicationWarningsCollector;

        public VariantDependencyFactory(ProjectDependencyPublicationResolver projectDependencyResolver, VariantVersionMappingStrategyInternal versionMappingStrategy, PublicationWarningsCollector publicationWarningsCollector) {
            this.projectDependencyResolver = projectDependencyResolver;
            this.versionMappingStrategy = versionMappingStrategy;
            this.publicationWarningsCollector = publicationWarningsCollector;
        }

        private IvyDependency asProjectDependency(ProjectDependency dependency, String confMapping) {
            Path identityPath = ((ProjectDependencyInternal)dependency).getIdentityPath();
            ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, identityPath);
            return new DefaultIvyDependency(identifier.getGroup(), identifier.getName(), identifier.getVersion(), confMapping, dependency.isTransitive(), this.resolveCoordinates(identityPath), Collections.emptySet(), dependency.getExcludeRules());
        }

        private IvyDependency asExternalDependency(ExternalDependency dependency, String confMapping) {
            return new DefaultIvyDependency(dependency.getGroup(), dependency.getName(), Strings.nullToEmpty((String)dependency.getVersion()), confMapping, dependency.isTransitive(), this.resolveCoordinates(dependency.getGroup(), dependency.getName(), dependency.getVersion(), null), dependency.getArtifacts(), dependency.getExcludeRules());
        }

        @Nullable
        private ModuleVersionIdentifier resolveCoordinates(Path identityPath) {
            ModuleVersionIdentifier identifier = (ModuleVersionIdentifier)this.projectDependencyResolver.resolve(ModuleVersionIdentifier.class, identityPath);
            return this.resolveCoordinates(identifier.getGroup(), identifier.getName(), identifier.getVersion(), identityPath);
        }

        @Nullable
        private ModuleVersionIdentifier resolveCoordinates(String organization, String module, @Nullable String revision, @Nullable Path identityPath) {
            ModuleVersionIdentifier resolvedVersion = this.versionMappingStrategy.maybeResolveVersion(organization, module, identityPath);
            if (resolvedVersion != null) {
                return resolvedVersion;
            }
            if (revision == null) {
                this.publicationWarningsCollector.addUnsupported(String.format("%s:%s declared without version", organization, module));
            }
            return null;
        }
    }
}

