/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.DefaultResolverResults;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolveExceptionContextualizer;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.artifacts.result.ResolutionResultInternal;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;

public class ErrorHandlingConfigurationResolver
implements ConfigurationResolver {
    private final ConfigurationResolver delegate;
    private final ResolveExceptionContextualizer contextualizer;

    public ErrorHandlingConfigurationResolver(ConfigurationResolver delegate, ResolveExceptionContextualizer contextualizer) {
        this.delegate = delegate;
        this.contextualizer = contextualizer;
    }

    @Override
    public List<ResolutionAwareRepository> getRepositories() {
        return this.delegate.getRepositories();
    }

    @Override
    public ResolverResults resolveBuildDependencies(ResolveContext resolveContext) {
        try {
            return this.delegate.resolveBuildDependencies(resolveContext);
        }
        catch (Exception e) {
            return DefaultResolverResults.failed(e, this.contextualizer.contextualize(e, resolveContext));
        }
    }

    @Override
    public ResolverResults resolveGraph(ResolveContext resolveContext) throws ResolveException {
        ResolverResults results;
        try {
            results = this.delegate.resolveGraph(resolveContext);
        }
        catch (Exception e) {
            return DefaultResolverResults.failed(e, this.contextualizer.contextualize(e, resolveContext));
        }
        return results.updateResolutionResult(result -> new ErrorHandlingResolutionResult((ResolutionResult)result, resolveContext, this.contextualizer));
    }

    @Override
    public ResolverResults resolveArtifacts(ResolveContext resolveContext, ResolverResults graphResults) throws ResolveException {
        ResolverResults artifactResults;
        try {
            artifactResults = this.delegate.resolveArtifacts(resolveContext, graphResults);
        }
        catch (Exception e) {
            return DefaultResolverResults.failed(graphResults.getResolutionResult(), graphResults.getResolvedLocalComponents(), e, this.contextualizer.contextualize(e, resolveContext));
        }
        ErrorHandlingResolvedConfiguration wrappedConfiguration = new ErrorHandlingResolvedConfiguration(artifactResults.getResolvedConfiguration(), resolveContext, this.contextualizer);
        return DefaultResolverResults.artifactsResolved(graphResults.getResolutionResult(), graphResults.getResolvedLocalComponents(), wrappedConfiguration, artifactResults.getVisitedArtifacts());
    }

    private static class ErrorHandlingResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolvedConfiguration resolvedConfiguration;
        private final ResolveContext resolveContext;
        private final ResolveExceptionContextualizer contextualizer;

        public ErrorHandlingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, ResolveContext resolveContext, ResolveExceptionContextualizer contextualizer) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.resolveContext = resolveContext;
            this.contextualizer = contextualizer;
        }

        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        public LenientConfiguration getLenientConfiguration() {
            try {
                return new ErrorHandlingLenientConfiguration(this.resolvedConfiguration.getLenientConfiguration(), this.resolveContext, this.contextualizer);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public void rethrowFailure() throws ResolveException {
            try {
                this.resolvedConfiguration.rethrowFailure();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles();
            }
            catch (ResolveException e) {
                throw this.contextualizer.contextualize((Throwable)e, this.resolveContext);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            try {
                return this.resolvedConfiguration.getResolvedArtifacts();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }
    }

    private static class ErrorHandlingResolutionResult
    implements ResolutionResultInternal {
        private final ResolutionResultInternal resolutionResult;
        private final ResolveContext resolveContext;
        private final ResolveExceptionContextualizer contextualizer;

        public ErrorHandlingResolutionResult(ResolutionResult resolutionResult, ResolveContext configuration, ResolveExceptionContextualizer contextualizer) {
            this.resolutionResult = (ResolutionResultInternal)resolutionResult;
            this.resolveContext = configuration;
            this.contextualizer = contextualizer;
        }

        public ResolvedComponentResult getRoot() {
            try {
                return this.resolutionResult.getRoot();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Provider<ResolvedComponentResult> getRootComponent() {
            return new DefaultProvider(this::getRoot);
        }

        @Override
        public Provider<Throwable> getNonFatalFailure() {
            return this.resolutionResult.getNonFatalFailure().map(e -> this.contextualizer.contextualize((Throwable)e, this.resolveContext));
        }

        public void allDependencies(Action<? super DependencyResult> action) {
            this.resolutionResult.allDependencies(action);
        }

        public Set<? extends DependencyResult> getAllDependencies() {
            try {
                return this.resolutionResult.getAllDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public void allDependencies(Closure closure) {
            this.resolutionResult.allDependencies(closure);
        }

        public Set<ResolvedComponentResult> getAllComponents() {
            try {
                return this.resolutionResult.getAllComponents();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public void allComponents(Action<? super ResolvedComponentResult> action) {
            this.resolutionResult.allComponents(action);
        }

        public void allComponents(Closure closure) {
            this.resolutionResult.allComponents(closure);
        }

        public AttributeContainer getRequestedAttributes() {
            return this.resolutionResult.getRequestedAttributes();
        }
    }

    private static class ErrorHandlingLenientConfiguration
    implements LenientConfiguration {
        private final LenientConfiguration lenientConfiguration;
        private final ResolveContext resolveContext;
        private final ResolveExceptionContextualizer contextualizer;

        private ErrorHandlingLenientConfiguration(LenientConfiguration lenientConfiguration, ResolveContext resolveContext, ResolveExceptionContextualizer contextualizer) {
            this.lenientConfiguration = lenientConfiguration;
            this.resolveContext = resolveContext;
            this.contextualizer = contextualizer;
        }

        public Set<ResolvedArtifact> getArtifacts() {
            try {
                return this.lenientConfiguration.getArtifacts();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getArtifacts(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<ResolvedDependency> getAllModuleDependencies() {
            try {
                return this.lenientConfiguration.getAllModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
            try {
                return this.lenientConfiguration.getUnresolvedModuleDependencies();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles() {
            try {
                return this.lenientConfiguration.getFiles();
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }

        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFiles(dependencySpec);
            }
            catch (Exception e) {
                throw this.contextualizer.contextualize(e, this.resolveContext);
            }
        }
    }
}

