/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.transformers;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirFile;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.transformers.FirGlobalResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirResolveProcessor;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTotalResolveProcessorKt;
import org.jetbrains.kotlin.fir.resolve.transformers.FirTransformerBasedResolveProcessor;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0006R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor;", "", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "(Lorg/jetbrains/kotlin/fir/FirSession;)V", "processors", "", "Lorg/jetbrains/kotlin/fir/resolve/transformers/FirResolveProcessor;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "getScopeSession", "()Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "process", "", "files", "Lorg/jetbrains/kotlin/fir/declarations/FirFile;", "resolve"})
@SourceDebugExtension(value={"SMAP\nFirTotalResolveProcessor.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FirTotalResolveProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor\n+ 2 Utils.kt\norg/jetbrains/kotlin/fir/UtilsKt\n*L\n1#1,93:1\n153#2,4:94\n*S KotlinDebug\n*F\n+ 1 FirTotalResolveProcessor.kt\norg/jetbrains/kotlin/fir/resolve/transformers/FirTotalResolveProcessor\n*L\n35#1:94,4\n*E\n"})
public final class FirTotalResolveProcessor {
    @NotNull
    private final FirSession session;
    @NotNull
    private final ScopeSession scopeSession;
    @NotNull
    private final List<FirResolveProcessor> processors;

    public FirTotalResolveProcessor(@NotNull FirSession session) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        this.session = session;
        this.scopeSession = new ScopeSession();
        this.processors = FirTotalResolveProcessorKt.createAllCompilerResolveProcessors(this.session, this.scopeSession);
    }

    @NotNull
    public final ScopeSession getScopeSession() {
        return this.scopeSession;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void process(@NotNull List<? extends FirFile> files2) {
        Intrinsics.checkNotNullParameter(files2, (String)"files");
        for (FirResolveProcessor processor2 : this.processors) {
            processor2.beforePhase();
            try {
                FirResolveProcessor firResolveProcessor = processor2;
                if (firResolveProcessor instanceof FirTransformerBasedResolveProcessor) {
                    for (FirFile firFile : files2) {
                        boolean $i$f$withFileAnalysisExceptionWrapping = false;
                        try {
                            boolean bl = false;
                            ((FirTransformerBasedResolveProcessor)processor2).processFile(firFile);
                            Unit unit2 = Unit.INSTANCE;
                        }
                        catch (Throwable throwable$iv) {
                            UtilsKt.getExceptionHandler(firFile.getModuleData().getSession()).handleExceptionOnFileAnalysis(firFile, throwable$iv);
                            throw null;
                        }
                    }
                    continue;
                }
                if (!(firResolveProcessor instanceof FirGlobalResolveProcessor)) continue;
                ((FirGlobalResolveProcessor)processor2).process((Collection<? extends FirFile>)files2);
            }
            finally {
                processor2.afterPhase();
            }
        }
    }
}

