/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.border;

import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.border.Border;
import net.yura.mobile.gui.components.Component;

public class CompoundBorder
implements Border {
    private Border outsideBorder;
    private Border insideBorder;

    public CompoundBorder(Border outside, Border inside) {
        this.outsideBorder = outside;
        this.insideBorder = inside;
    }

    public Border getInsideBorder() {
        return this.insideBorder;
    }

    public Border getOutsideBorder() {
        return this.outsideBorder;
    }

    public void setInsideBorder(Border insideBorder) {
        this.insideBorder = insideBorder;
    }

    public void setOutsideBorder(Border outsideBorder) {
        this.outsideBorder = outsideBorder;
    }

    public void paintBorder(Component c, Graphics2D g, int width, int height) {
        g.translate(-this.insideBorder.getLeft(), -this.insideBorder.getTop());
        this.outsideBorder.paintBorder(c, g, width + this.insideBorder.getLeft() + this.insideBorder.getRight(), height + this.insideBorder.getTop() + this.insideBorder.getBottom());
        g.translate(this.insideBorder.getLeft(), this.insideBorder.getTop());
        this.insideBorder.paintBorder(c, g, width, height);
    }

    public int getTop() {
        return this.outsideBorder.getTop() + this.insideBorder.getTop();
    }

    public int getBottom() {
        return this.outsideBorder.getBottom() + this.insideBorder.getBottom();
    }

    public int getRight() {
        return this.outsideBorder.getRight() + this.insideBorder.getRight();
    }

    public int getLeft() {
        return this.outsideBorder.getLeft() + this.insideBorder.getLeft();
    }

    public boolean isBorderOpaque() {
        return this.outsideBorder.isBorderOpaque() || this.insideBorder.isBorderOpaque();
    }
}

