/*
 * Decompiled with CFR 0.152.
 */
package net.yura.mobile.gui.components;

import java.util.Vector;
import net.yura.mobile.gui.DesktopPane;
import net.yura.mobile.gui.Graphics2D;
import net.yura.mobile.gui.Icon;
import net.yura.mobile.gui.KeyEvent;
import net.yura.mobile.gui.components.Component;
import net.yura.mobile.gui.components.Panel;
import net.yura.mobile.gui.components.Slider;
import net.yura.mobile.gui.layout.Layout;
import net.yura.mobile.logging.Logger;

public class ScrollPane
extends Panel
implements Runnable {
    public static final int MODE_NONE = -1;
    public static final int MODE_SCROLLBARS = 0;
    public static final int MODE_SCROLLARROWS = 1;
    public static final int MODE_INDICATOR = 2;
    private int mode;
    private int barThickness;
    private Icon rightArrow;
    private Icon leftArrow;
    private Icon upArrow;
    private Icon downArrow;
    private Slider slider;
    private boolean clip = true;
    final int BOUNCE_LEFT = 1;
    final int BOUNCE_RIGHT = 2;
    final int BOUNCE_TOP = 4;
    final int BOUNCE_BOTTOM = 8;
    final int BOUNCE_HORIZONTAL = 3;
    final int BOUNCE_VERTICAL = 12;
    private int bounceMode;
    private static final int DRAG_NONE = 0;
    private static final int DRAG_CLICKED_ARROW = 1;
    private static final int DRAG_CLICKED_TRACK = 2;
    private static final int DRAG_SLIDER_HORZ = 3;
    private static final int DRAG_SLIDER_VERT = 4;
    private static final int DRAG_BUFFER_SIZE = 50;
    private static final int DRAG_PAGE_RATE = 10;
    private static final int DRAG_FRAME_RATE = 50;
    private static ScrollPane dragScrollPane;
    private int dragScrollBarMode;
    private int dragStartViewY;
    private int dragStartViewX;
    private int dragStartY;
    private int dragStartX;
    private int dragLastY;
    private int dragLastX;
    private int dragVelocityY;
    private int dragVelocityX;
    private int dragFriction;
    private int dragTimeY;
    private int dragTimeX;
    private int fitSizeTime;
    private long[] dragTimes = new long[50];
    private int[] dragBufferX = new int[50];
    private int[] dragBufferY = new int[50];
    private int dragBufferPos;

    public ScrollPane() {
        this(0);
    }

    public ScrollPane(Component view) {
        this(view, 0);
    }

    public ScrollPane(int m) {
        super(null);
        this.setName("ScrollPane");
        this.slider = new Slider();
        this.slider.setName("ScrollBar");
        this.setMode(m);
    }

    public ScrollPane(Component view, int a) {
        this(a);
        this.add(view);
    }

    public void setLayout(Layout lt) {
        if (lt != null) {
            throw new IllegalArgumentException();
        }
    }

    public void setMode(int m) {
        this.mode = m;
    }

    public void setClip(boolean c) {
        this.clip = c;
    }

    public void setBounceMode(int bounceMode) {
        this.bounceMode = bounceMode;
    }

    public int getBarThickness() {
        return this.slider.getHeight();
    }

    public Component getView() {
        return (Component)this.getComponents().elementAt(0);
    }

    protected void addImpl(Component component, Object cons, int index) {
        if (cons != null || index != -1) {
            throw new RuntimeException("must use add, cons=" + cons + " index=" + index);
        }
        this.removeAll();
        super.addImpl(component, null, -1);
        this.setViewLocation(this.getViewPortX(), this.getViewPortY());
    }

    public boolean scrollRectToVisible(int x, int y, int w, int h, boolean smart) {
        Component v = this.getView();
        int oldx = v.getX();
        int oldy = v.getY();
        boolean reached = this.makeVisible(x - oldx, y - oldy, w, h, smart);
        if (oldx != v.getX() || oldy != v.getY()) {
            return reached;
        }
        return super.scrollRectToVisible(x, y, w, h, smart);
    }

    public boolean isRectVisible(int x, int y, int w, int h) {
        boolean visible;
        int viewX = this.getViewPortX();
        int viewY = this.getViewPortY();
        int viewHeight = this.getViewPortHeight();
        int viewWidth = this.getViewPortWidth(viewHeight);
        boolean bl = visible = (x >= viewX && x + w <= viewX + viewWidth || x <= viewX && x + w >= viewX + viewWidth) && (y >= viewY && y + h <= viewY + viewHeight || y <= viewY && y + h >= viewY + viewHeight);
        if (!visible) {
            return false;
        }
        return super.isRectVisible(x, y, w, h);
    }

    protected boolean scrollUpDown(int d) {
        Component v = this.getView();
        int oldx = v.getX();
        int oldy = v.getY();
        if (d == 5) {
            this.makeVisible(v.getWidth() - 1, -oldy + this.getViewPortY(), 1, 1, true);
        } else if (d == 2) {
            this.makeVisible(0, -oldy + this.getViewPortY(), 1, 1, true);
        } else if (d == 1) {
            this.makeVisible(-oldx + this.getViewPortX(), 0, 1, 1, true);
        } else {
            this.makeVisible(-oldx + this.getViewPortX(), v.getHeight() - 1, 1, 1, true);
        }
        return oldx != v.getX() || oldy != v.getY();
    }

    private boolean makeVisible(int x, int y, int w, int h, boolean smartscroll) {
        return this.makeVisible(x, y, w, h, smartscroll, true);
    }

    private boolean makeVisible(int x, int y, int w, int h, boolean smartscroll, boolean bond) {
        boolean topTooFar;
        boolean leftTooFar;
        Component component = this.getView();
        int oldX = component.getX();
        int oldY = component.getY();
        int viewPortX = this.getViewPortX();
        int viewPortY = this.getViewPortY();
        int viewPortHeight = this.getViewPortHeight();
        int viewPortWidth = this.getViewPortWidth(viewPortHeight);
        int right = x + w;
        int bottom = y + h;
        int componentX = -oldX;
        int componentY = -oldY;
        boolean rightTooFar = right > viewPortX + componentX + viewPortWidth;
        boolean bl = leftTooFar = x < viewPortX + componentX;
        if (!leftTooFar || !rightTooFar) {
            boolean tooWide;
            boolean bl2 = tooWide = w > viewPortWidth;
            if (rightTooFar && !tooWide || leftTooFar && tooWide) {
                componentX = right - viewPortWidth - viewPortX;
            }
            if (rightTooFar && tooWide || leftTooFar && !tooWide) {
                componentX = x - viewPortX;
            }
        }
        boolean bottomTooFar = bottom > viewPortY + componentY + viewPortHeight;
        boolean bl3 = topTooFar = y < viewPortY + componentY;
        if (!topTooFar || !bottomTooFar) {
            boolean tooTall;
            boolean bl4 = tooTall = h > viewPortHeight;
            if (bottomTooFar && !tooTall || topTooFar && tooTall) {
                componentY = bottom - viewPortHeight - viewPortY;
            }
            if (bottomTooFar && tooTall || topTooFar && !tooTall) {
                componentY = y - viewPortY;
            }
        }
        if (bond) {
            componentX = Math.min(componentX, component.getWidth() - viewPortWidth - viewPortX);
            componentY = Math.min(componentY, component.getHeight() - viewPortHeight - viewPortY);
            componentX = Math.max(componentX, -viewPortX);
            componentY = Math.max(componentY, -viewPortY);
        }
        int xdiff = -componentX - oldX;
        int ydiff = -componentY - oldY;
        boolean goodscroll = true;
        if (smartscroll) {
            if (Math.abs(xdiff) > viewPortWidth) {
                xdiff = xdiff > 0 ? viewPortWidth * 2 / 3 : -viewPortWidth * 2 / 3;
                goodscroll = false;
            }
            if (Math.abs(ydiff) > viewPortHeight) {
                ydiff = ydiff > 0 ? viewPortHeight * 2 / 3 : -viewPortHeight * 2 / 3;
                goodscroll = false;
            }
        }
        int newX = oldX + xdiff;
        int newY = oldY + ydiff;
        if (oldX != newX || oldY != newY) {
            this.setViewLocation(newX, newY);
            this.repaint();
        }
        return goodscroll;
    }

    public int getViewPortHeight() {
        switch (this.mode) {
            case 0: {
                return this.height - this.getViewPortY() - (this.getView().getWidth() > this.width - this.getViewPortX() ? this.barThickness : 0);
            }
            case 1: {
                return this.getView().getHeight() > this.height ? this.height - this.barThickness * 2 : this.height;
            }
            case -1: 
            case 2: {
                return this.height;
            }
        }
        throw new RuntimeException();
    }

    public int getViewPortWidth() {
        return this.getViewPortWidth(this.getViewPortHeight());
    }

    private int getViewPortWidth(int vph) {
        switch (this.mode) {
            case 0: {
                return this.width - this.getViewPortX() - (this.getView().getHeight() > vph ? this.barThickness : 0);
            }
            case 1: {
                return this.getView().getWidth() > this.width ? this.width - this.barThickness * 2 : this.width;
            }
            case -1: 
            case 2: {
                return this.width;
            }
        }
        throw new RuntimeException();
    }

    public int getViewPortX() {
        switch (this.mode) {
            case 1: {
                return this.getView().getWidth() > this.width ? this.barThickness : 0;
            }
            case -1: 
            case 0: 
            case 2: {
                return 0;
            }
        }
        throw new RuntimeException();
    }

    public int getViewPortY() {
        switch (this.mode) {
            case 1: {
                return this.getView().getHeight() > this.height ? this.barThickness : 0;
            }
            case -1: 
            case 0: 
            case 2: {
                return 0;
            }
        }
        throw new RuntimeException();
    }

    protected void workoutMinimumSize() {
        this.slider.workoutPreferredSize();
        switch (this.mode) {
            case 0: {
                this.barThickness = this.getBarThickness();
                break;
            }
            case 1: 
            case 2: {
                this.barThickness = this.rightArrow != null ? this.rightArrow.getIconWidth() : 0;
                break;
            }
            case -1: {
                this.barThickness = 0;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        super.workoutMinimumSize();
        Component view = this.getView();
        this.width = view.getWidth();
        this.height = view.getHeight();
    }

    public void doLayout() {
        if (this.getComponents().size() == 1) {
            Component comp = this.getView();
            int viewHeight = this.getViewPortHeight();
            int viewWidth = this.getViewPortWidth(viewHeight);
            int cw = comp.getWidth();
            int ch = comp.getHeight();
            if (cw < viewWidth) {
                cw = viewWidth;
            }
            if (ch < viewHeight) {
                ch = viewHeight;
            }
            comp.setSize(cw, ch);
            if (DesktopPane.myLastRevalidate(this)) {
                if (comp.getX() > this.getViewPortX()) {
                    this.setViewLocation(this.getViewPortX(), comp.getY());
                }
                if (comp.getY() > this.getViewPortY()) {
                    this.setViewLocation(comp.getX(), this.getViewPortY());
                }
                if (cw - this.getViewPortX() + comp.getX() < this.getViewPortWidth()) {
                    this.setViewLocation(-cw + this.getViewPortX() + this.getViewPortWidth(), comp.getY());
                }
                if (ch - this.getViewPortY() + comp.getY() < this.getViewPortHeight()) {
                    this.setViewLocation(comp.getX(), -ch + this.getViewPortY() + this.getViewPortHeight());
                }
            }
        }
    }

    public void paintChildren(Graphics2D g) {
        int[] a = null;
        if (this.clip) {
            a = g.getClip();
            int viewX = this.getViewPortX();
            int viewY = this.getViewPortY();
            int viewHeight = this.getViewPortHeight();
            int viewWidth = this.getViewPortWidth(viewHeight);
            g.clipRect(viewX, viewY, viewWidth, viewHeight);
        }
        super.paintChildren(g);
        if (this.clip) {
            g.setClip(a);
        }
        this.paintDecoration(g);
    }

    protected void paintDecoration(Graphics2D g) {
        switch (this.mode) {
            case -1: {
                return;
            }
            case 0: {
                this.drawScrollBars(g);
                return;
            }
            case 1: {
                this.drawScrollArrows(g, false);
                return;
            }
            case 2: {
                this.drawScrollArrows(g, true);
                return;
            }
        }
        throw new RuntimeException();
    }

    private void drawScrollBars(Graphics2D g) {
        boolean horizontal;
        int viewPortX = this.getViewPortX();
        int viewPortY = this.getViewPortY();
        int viewPortHeight = this.getViewPortHeight();
        int viewPortWidth = this.getViewPortWidth(viewPortHeight);
        Component view = this.getView();
        int viewWidth = view.getWidth();
        int viewHeight = view.getHeight();
        boolean vertical = viewHeight > viewPortHeight;
        boolean bl = horizontal = viewWidth > this.width - viewPortX;
        if (vertical) {
            int t = g.getTransform();
            g.setTransform(4);
            this.slider.drawScrollBar(g, viewPortY, this.width - this.barThickness, this.height - viewPortY - (horizontal ? this.barThickness : 0), this.barThickness, viewPortY - view.getY(), viewPortHeight, viewHeight);
            g.setTransform(t);
        }
        if (horizontal) {
            this.slider.drawScrollBar(g, viewPortX, this.height - this.barThickness, this.width - viewPortX - (vertical ? this.barThickness : 0), this.barThickness, viewPortX - view.getX(), viewPortWidth, viewWidth);
        }
    }

    private void drawScrollArrows(Graphics2D g, boolean indicator) {
        boolean canScroll;
        int viewHeight = this.getViewPortHeight();
        int viewWidth = this.getViewPortWidth(viewHeight);
        int viewX = this.getViewPortX();
        int viewY = this.getViewPortY();
        Component view = this.getView();
        int d = this.barThickness * 2;
        int gap = 2;
        if (view.getWidth() > this.width) {
            boolean bl = canScroll = view.getX() < viewX;
            if (indicator) {
                this.drawArrow(g, this.width / 2 - gap - d, this.height + (d + 3 * gap) / 2 - this.barThickness, this.barThickness, d, canScroll, 4);
            } else {
                this.drawArrow(g, 0, (this.height - d) / 2, this.barThickness, d, canScroll, 4);
            }
            boolean bl2 = canScroll = view.getWidth() + view.getX() - viewX > viewWidth;
            if (indicator) {
                this.drawArrow(g, this.width / 2 + gap + this.barThickness, this.height + (d + 3 * gap) / 2 - this.barThickness, this.barThickness, d, canScroll, 8);
            } else {
                this.drawArrow(g, this.width - this.barThickness, (this.height - d) / 2, this.barThickness, d, canScroll, 8);
            }
        }
        if (view.getHeight() > this.height) {
            boolean bl = canScroll = view.getY() < viewY;
            if (indicator) {
                this.drawArrow(g, (this.width - d) / 2, this.height + gap, d, this.barThickness, canScroll, 16);
            } else {
                this.drawArrow(g, (this.width - d) / 2, 0, d, this.barThickness, canScroll, 16);
            }
            boolean bl3 = canScroll = view.getHeight() + view.getY() - viewY > viewHeight;
            if (indicator) {
                this.drawArrow(g, (this.width - d) / 2, this.height + this.barThickness + gap * 2, d, this.barThickness, canScroll, 32);
            } else {
                this.drawArrow(g, (this.width - d) / 2, this.height - this.barThickness, d, this.barThickness, canScroll, 32);
            }
        }
    }

    public void drawArrow(Graphics2D g, int x, int y, int w, int h, boolean canScroll, int direction) {
        switch (direction) {
            case 4: {
                if (this.leftArrow == null || !canScroll) break;
                this.leftArrow.paintIcon(this, g, x + (w - this.leftArrow.getIconWidth()) / 2, y + (h - this.leftArrow.getIconHeight()) / 2);
                break;
            }
            case 8: {
                if (this.rightArrow == null || !canScroll) break;
                this.rightArrow.paintIcon(this, g, x + (w - this.rightArrow.getIconWidth()) / 2, y + (h - this.rightArrow.getIconHeight()) / 2);
                break;
            }
            case 16: {
                if (this.upArrow == null || !canScroll) break;
                this.upArrow.paintIcon(this, g, x + (w - this.upArrow.getIconWidth()) / 2, y + (h - this.upArrow.getIconHeight()) / 2);
                break;
            }
            case 32: {
                if (this.downArrow == null || !canScroll) break;
                this.downArrow.paintIcon(this, g, x + (w - this.downArrow.getIconWidth()) / 2, y + (h - this.downArrow.getIconHeight()) / 2);
            }
        }
    }

    public void computeVisibleRect(int[] v) {
        if (this.clip) {
            int d;
            int c;
            int b;
            int a;
            int viewPortX = this.getXOnScreen() + this.getViewPortX();
            int viewPortY = this.getYOnScreen() + this.getViewPortY();
            int viewPortHeight = this.getViewPortHeight();
            int viewPortWidth = this.getViewPortWidth(viewPortHeight);
            if (viewPortX > v[0]) {
                v[2] = v[2] - (viewPortX - v[0]);
                v[0] = viewPortX;
            }
            if (viewPortY > v[1]) {
                v[3] = v[3] - (viewPortY - v[1]);
                v[1] = viewPortY;
            }
            if ((a = viewPortX + viewPortWidth) < (b = v[0] + v[2])) {
                v[2] = v[2] - (b - a);
            }
            if ((c = viewPortY + viewPortHeight) < (d = v[1] + v[3])) {
                v[3] = v[3] - (d - c);
            }
            if (v[2] <= 0 || v[3] <= 0) {
                v[3] = 0;
                v[2] = 0;
                v[1] = 0;
                v[0] = 0;
            }
        }
        super.computeVisibleRect(v);
    }

    public boolean isOpaque() {
        boolean mine = super.isOpaque();
        return mine ? mine : this.getView().isOpaque();
    }

    public void updateUI() {
        super.updateUI();
        this.rightArrow = (Icon)this.theme.getProperty("rightArrow", 0);
        this.leftArrow = (Icon)this.theme.getProperty("leftArrow", 0);
        this.upArrow = (Icon)this.theme.getProperty("upArrow", 0);
        this.downArrow = (Icon)this.theme.getProperty("downArrow", 0);
        if (this.slider != null) {
            this.slider.updateUI();
        }
    }

    public Component getComponentAt(int x, int y) {
        int viewPortHeight;
        int viewPortWidth;
        int viewYPortY;
        int viewPortX = this.getViewPortX();
        if (ScrollPane.isPointInsideRect(x, y, viewPortX, viewYPortY = this.getViewPortY(), viewPortWidth = this.getViewPortWidth(viewPortHeight = this.getViewPortHeight()), viewPortHeight)) {
            return super.getComponentAt(x, y);
        }
        return this;
    }

    public static boolean isPointInsideRect(int x, int y, int recX, int recY, int recWidth, int recHeight) {
        return x >= recX && x < recX + recWidth && y >= recY && y < recY + recHeight;
    }

    private int doClickInScrollbar(int click, int dragSlider, int extent1) {
        int velocity;
        int dragMode;
        if (this.dragScrollBarMode != 0) {
            return 0;
        }
        switch (click) {
            case 1: {
                dragMode = 1;
                velocity = 200;
                break;
            }
            case 2: {
                dragMode = 2;
                velocity = extent1 * 50;
                break;
            }
            case 3: {
                velocity = 0;
                dragMode = dragSlider;
                break;
            }
            case 4: {
                dragMode = 2;
                velocity = -extent1 * 50;
                break;
            }
            case 5: {
                dragMode = 1;
                velocity = -200;
                break;
            }
            default: {
                velocity = 0;
                dragMode = 0;
            }
        }
        this.dragScrollBarMode = dragMode;
        return velocity;
    }

    private static synchronized void animateScrollPane(ScrollPane dragScrollPane) {
        boolean startThread = dragScrollPane != null && ScrollPane.dragScrollPane != dragScrollPane;
        ScrollPane.dragScrollPane = dragScrollPane;
        if (startThread) {
            new Thread((Runnable)dragScrollPane, "SwingME-Scroll").start();
        }
        ScrollPane.class.notifyAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        long startAnimTime = System.currentTimeMillis();
        try {
            while (true) {
                Class clazz = class$net$yura$mobile$gui$components$ScrollPane == null ? ScrollPane.class$("net.yura.mobile.gui.components.ScrollPane") : class$net$yura$mobile$gui$components$ScrollPane;
                synchronized (clazz) {
                    Vector uiLock;
                    long time = System.currentTimeMillis();
                    Vector vector = uiLock = this.getWindow().getDesktopPane().getAllFrames();
                    synchronized (vector) {
                        boolean animate = this.dragScrollBars((int)(time - startAnimTime));
                        if (!animate) {
                            if (dragScrollPane != this) return;
                            dragScrollPane = null;
                            return;
                        }
                    }
                    int rate = this.dragScrollBarMode == 2 ? 10 : 50;
                    long timeToWait = time - System.currentTimeMillis() + 1000L / (long)rate;
                    if (timeToWait > 0L) {
                        (class$net$yura$mobile$gui$components$ScrollPane == null ? ScrollPane.class$("net.yura.mobile.gui.components.ScrollPane") : class$net$yura$mobile$gui$components$ScrollPane).wait(timeToWait);
                    }
                }
            }
        }
        catch (Throwable e) {
            Logger.info(null, e);
            dragScrollPane = dragScrollPane == this ? null : dragScrollPane;
        }
    }

    private void updateDragSpeed(int x, int y, long time) {
        ++this.dragBufferPos;
        if (this.dragBufferPos >= 50) {
            this.dragBufferPos = 0;
        }
        this.dragTimes[this.dragBufferPos] = time;
        this.dragBufferX[this.dragBufferPos] = x;
        this.dragBufferY[this.dragBufferPos] = y;
    }

    private int getDragVelocity(int[] dragBuffer) {
        int lastPos;
        int pos = lastPos = this.dragBufferPos;
        int firstPos = lastPos;
        long oldestTime = this.dragTimes[lastPos] - 200L;
        while (this.dragTimes[pos] > 0L && this.dragTimes[pos] >= oldestTime) {
            firstPos = pos--;
            if (pos < 0) {
                pos = 49;
            }
            if (pos != lastPos) continue;
        }
        long elapsedTime = Math.max(this.dragTimes[lastPos] - this.dragTimes[firstPos], 1L);
        int traveledPixels = dragBuffer[lastPos] - dragBuffer[firstPos];
        return (int)((long)(traveledPixels * 1000) / elapsedTime);
    }

    protected int getDragVelocity(boolean horizontal) {
        return this.getDragVelocity(horizontal ? this.dragBufferX : this.dragBufferY);
    }

    protected void resetDragSpeed() {
        this.updateDragSpeed(0, 0, 0L);
        this.dragFriction = 1000;
        this.dragVelocityX = 0;
        this.dragVelocityY = 0;
    }

    public void processMouseEvent(int type, int pointX, int pointY, KeyEvent keys) {
        Component view = this.getView();
        int viewY = view.getY();
        int viewX = view.getX();
        int viewHeight = view.getHeight();
        int viewWidth = view.getWidth();
        int viewPortX = this.getViewPortX();
        int viewPortY = this.getViewPortY();
        int viewPortHeight = this.getViewPortHeight();
        int viewPortWidth = this.getViewPortWidth(viewPortHeight);
        this.updateDragSpeed(pointX, pointY, System.currentTimeMillis());
        if (type == 1) {
            this.dragScrollBarMode = 0;
            this.dragFriction = 0;
            this.dragLastX = pointX;
            this.dragStartX = pointX;
            this.dragStartViewX = viewX - viewPortX;
            this.dragVelocityX = 0;
            this.dragTimeX = -1;
            this.dragLastY = pointY;
            this.dragStartY = pointY;
            this.dragStartViewY = viewY - viewPortY;
            this.dragVelocityY = 0;
            this.dragTimeY = -1;
            this.animateToFit(0, true);
            if (this.mode == 0) {
                int clickX = this.slider.doClickInScrollbar(viewPortX, viewPortY + viewPortHeight, viewPortWidth, this.height - viewPortY - viewPortHeight, viewPortX - viewX, viewPortWidth, viewWidth, pointX, pointY);
                this.dragVelocityX = this.doClickInScrollbar(clickX, 3, viewPortWidth);
                int clickY = this.slider.doClickInScrollbar(viewPortY, viewPortX + viewPortWidth, viewPortHeight, this.width - viewPortX - viewPortWidth, viewPortY - viewY, viewPortHeight, viewHeight, pointY, pointX);
                this.dragVelocityY = this.doClickInScrollbar(clickY, 4, viewPortHeight);
            } else if (this.mode == 1) {
                if (viewWidth > this.width) {
                    if (ScrollPane.isPointInsideRect(pointX, pointY, 0, 0, this.barThickness, this.height)) {
                        this.dragVelocityX = 200;
                    } else if (ScrollPane.isPointInsideRect(pointX, pointY, this.width - this.barThickness, 0, this.barThickness, this.height)) {
                        this.dragVelocityX = -200;
                    }
                }
                if (viewHeight > this.height) {
                    if (ScrollPane.isPointInsideRect(pointX, pointY, 0, 0, this.width, this.barThickness)) {
                        this.dragVelocityY = 200;
                    } else if (ScrollPane.isPointInsideRect(pointX, pointY, 0, this.height - this.barThickness, this.width, this.barThickness)) {
                        this.dragVelocityY = -200;
                    }
                }
                if (this.dragVelocityX != 0 || this.dragVelocityY != 0) {
                    this.dragScrollBarMode = 1;
                }
            }
            if (this.dragVelocityX != 0 || this.dragVelocityY != 0) {
                ScrollPane.animateScrollPane(this);
            }
        } else if (type == 0) {
            if (this.dragScrollBarMode == 3) {
                this.dragLastX = this.slider.getNewValue(viewPortX, viewPortY + viewHeight, viewPortWidth, this.height - viewPortY - viewPortHeight, this.dragStartX, viewPortWidth, viewWidth, this.dragStartX - pointX);
                this.dragScrollBarsSync(true);
            } else if (this.dragScrollBarMode == 4) {
                this.dragLastY = this.slider.getNewValue(viewPortY, viewPortX + viewWidth, viewPortHeight, this.width - viewPortX - viewPortWidth, this.dragStartY, viewPortHeight, viewHeight, this.dragStartY - pointY);
                this.dragScrollBarsSync(true);
            } else if (this.dragScrollBarMode == 0 && this.getDesktopPane().IPHONE_SCROLL) {
                this.dragLastX = pointX;
                this.dragLastY = pointY;
                this.dragScrollBarsSync(false);
            }
        } else if (type == 2) {
            if (this.dragScrollBarMode == 0) {
                if (this.getDesktopPane().IPHONE_SCROLL) {
                    this.dragVelocityX = this.getDragVelocity(true);
                    this.dragVelocityY = this.getDragVelocity(false);
                }
            } else {
                this.dragVelocityX = 0;
                this.dragVelocityY = 0;
            }
            this.dragFriction = 1000;
            ScrollPane.animateScrollPane(this);
            this.updateDragSpeed(0, 0, 0L);
        }
    }

    private void dragScrollBarsSync(boolean forceBound) {
        boolean springBackBottom;
        Component view = this.getView();
        int cX = view.getX() - this.getViewPortX();
        int cY = view.getY() - this.getViewPortY();
        int cW = view.getWidth();
        int cH = view.getHeight();
        int viewPortHeight = this.getViewPortHeight();
        int viewPortWidth = this.getViewPortWidth(viewPortHeight);
        boolean springBackLeft = (this.bounceMode & 1) == 0;
        boolean springBackRight = (this.bounceMode & 2) == 0;
        boolean springBackTop = (this.bounceMode & 4) == 0;
        boolean bl = springBackBottom = (this.bounceMode & 8) == 0;
        if (cW > viewPortWidth || !springBackLeft || !springBackRight) {
            cX = this.dragScrollBarSync(forceBound, this.dragStartX, this.dragLastX, this.dragStartViewX, cX, cW, viewPortWidth, springBackLeft, springBackRight);
        }
        if (cH > viewPortHeight || !springBackTop || !springBackBottom) {
            cY = this.dragScrollBarSync(forceBound, this.dragStartY, this.dragLastY, this.dragStartViewY, cY, cH, viewPortHeight, springBackTop, springBackBottom);
        }
        this.makeVisible(cX, cY, viewPortWidth, viewPortHeight, false, false);
    }

    private int dragScrollBarSync(boolean bound, int dragStartY, int dragLastY, int dragStartViewY, int cY, int cH, int viewPortHeight, boolean springBackTop, boolean springBackBottom) {
        int diffBottomY = viewPortHeight - cY - cH;
        int jumpY = dragStartY - dragLastY - (dragStartViewY - cY);
        if (jumpY != 0 || bound) {
            diffBottomY += jumpY;
            if ((cY -= jumpY) >= 0) {
                if (bound) {
                    cY = 0;
                } else if (springBackTop) {
                    cY /= 2;
                }
            } else if (diffBottomY >= 0) {
                if (bound) {
                    cY += diffBottomY;
                } else if (springBackBottom) {
                    cY += diffBottomY / 2;
                }
            }
        }
        return -cY;
    }

    private boolean dragScrollBars(int time) {
        boolean forceBound;
        boolean endThread;
        boolean bl = endThread = dragScrollPane != this;
        if (this.animateToFit(time, endThread) && !endThread) {
            return true;
        }
        Component view = this.getView();
        int cX = view.getX() - this.getViewPortX();
        int cY = view.getY() - this.getViewPortY();
        int cW = view.getWidth();
        int cH = view.getHeight();
        int viewPortHeight = this.getViewPortHeight();
        int viewPortWidth = this.getViewPortWidth(viewPortHeight);
        boolean res = false;
        boolean bl2 = forceBound = this.dragScrollBarMode != 0 || endThread;
        if (cW == viewPortWidth && (this.bounceMode & 3) == 0) {
            this.dragVelocityX = 0;
        }
        if (cH == viewPortHeight && (this.bounceMode & 0xC) == 0) {
            this.dragVelocityY = 0;
        }
        boolean springBackLeft = (this.bounceMode & 1) == 0;
        boolean springBackRight = (this.bounceMode & 2) == 0;
        boolean springBackTop = (this.bounceMode & 4) == 0;
        boolean springBackBottom = (this.bounceMode & 8) == 0;
        int[] newPosX = this.dragScrollBar(this.dragVelocityX, this.dragFriction, forceBound, cX, cW, viewPortWidth, time, this.dragTimeX, springBackLeft, springBackRight);
        cX = newPosX[0];
        this.dragVelocityX = newPosX[1];
        res |= newPosX[2] != 0;
        this.dragTimeX = newPosX[3];
        int[] newPosY = this.dragScrollBar(this.dragVelocityY, this.dragFriction, forceBound, cY, cH, viewPortHeight, time, this.dragTimeY, springBackTop, springBackBottom);
        cY = newPosY[0];
        this.dragVelocityY = newPosY[1];
        boolean bl3 = newPosY[2] != 0;
        this.dragTimeY = newPosY[3];
        this.makeVisible(cX, cY, viewPortWidth, viewPortHeight, false, false);
        return endThread ? false : (res |= bl3);
    }

    private int[] dragScrollBar(int dragVelocityY, int dragFriction, boolean bound, int cY, int cH, int viewPortHeight, int time, int springBackTime, boolean springBackTop, boolean springBackBottom) {
        boolean springBack;
        int diffBottomY = viewPortHeight - cY - cH;
        int jumpY = 0;
        if (dragVelocityY != 0) {
            int velocityInc = dragFriction / 50;
            if (Math.abs(dragVelocityY) < velocityInc) {
                dragVelocityY = 0;
            } else if (dragVelocityY > 0) {
                dragVelocityY -= velocityInc;
            } else if (dragVelocityY < 0) {
                dragVelocityY += velocityInc;
            }
            jumpY = -(dragVelocityY / 50);
            if (jumpY == 0) {
                dragVelocityY = 0;
            }
        }
        boolean bl = springBack = dragVelocityY == 0 && dragFriction != 0;
        if (springBack) {
            if (cY >= 0) {
                jumpY = cY;
            } else if (diffBottomY >= 0) {
                jumpY = -diffBottomY;
            }
        }
        if (springBack && jumpY != 0) {
            int[] vals = this.calculateSpringBack(time, springBackTime, jumpY);
            jumpY -= vals[0];
            springBackTime = vals[1];
        }
        if (jumpY != 0 || bound) {
            cY -= jumpY;
            diffBottomY += jumpY;
            if (!springBack) {
                int MAX_SPRING = viewPortHeight / 4;
                if (cY >= 0) {
                    if (bound) {
                        cY = 0;
                        jumpY = 0;
                    } else if (dragVelocityY != 0 && cY >= MAX_SPRING && springBackTop) {
                        dragVelocityY = 0;
                        cY = MAX_SPRING;
                    }
                } else if (diffBottomY >= 0) {
                    if (bound) {
                        cY += diffBottomY;
                        jumpY = 0;
                    } else if (dragVelocityY != 0 && diffBottomY >= MAX_SPRING && springBackBottom) {
                        dragVelocityY = 0;
                        cY += diffBottomY - MAX_SPRING;
                    }
                }
            }
        }
        return new int[]{-cY, dragVelocityY, jumpY, springBackTime};
    }

    private int[] calculateSpringBack(int time, int springBackTime, int dist) {
        int newDist;
        float springDrag = 3.0E-4f;
        if (springBackTime < 0) {
            springBackTime = time + (int)Math.sqrt((float)Math.abs(dist) / 3.0E-4f);
        }
        int n = newDist = (time = springBackTime - time) >= 0 ? (int)(3.0E-4f * (float)time * (float)time) : 0;
        if (dist < 0) {
            newDist = -newDist;
        }
        if (newDist == dist && newDist != 0) {
            newDist = dist > 0 ? dist - 1 : dist + 1;
        } else if (Math.abs(newDist) > Math.abs(dist)) {
            newDist = dist;
        }
        return new int[]{newDist, springBackTime};
    }

    private boolean animateToFit(int time, boolean force) {
        boolean res;
        Component view = this.getView();
        int cW = view.getWidth();
        int cH = view.getHeight();
        int cX = view.getX();
        int cY = view.getY();
        int viewPortHeight = this.getViewPortHeight();
        int viewPortWidth = this.getViewPortWidth(viewPortHeight);
        int viewPortX = this.getViewPortX();
        int viewPortY = this.getViewPortY();
        int diffW = viewPortWidth - cW;
        int diffH = viewPortHeight - cH;
        int viewPosX = view.getX();
        int viewPosY = view.getY();
        if (!force && diffW > 0 && diffH > 0) {
            int minDiff = diffW < diffH ? diffW : diffH;
            double ratioW = diffW < diffH ? 1.0 : (double)viewPortWidth / (double)viewPortHeight;
            double ratioH = diffW < diffH ? (double)viewPortHeight / (double)viewPortWidth : 1.0;
            int[] vals = this.calculateSpringBack(time, this.fitSizeTime, minDiff);
            int newMaxDiff = vals[0];
            this.fitSizeTime = vals[1];
            view.width = (int)((double)viewPortWidth - (double)newMaxDiff * ratioW);
            view.height = (int)((double)viewPortHeight - (double)newMaxDiff * ratioH);
            viewPosX = viewPortX + (viewPortWidth - view.width) / 2;
            viewPosY = viewPortY + (viewPortHeight - view.height) / 2;
        } else {
            if (diffW > 0) {
                view.width = viewPortWidth;
                viewPosX = viewPortX;
            }
            if (diffH > 0) {
                view.height = viewPortHeight;
                viewPosY = viewPortY;
            }
        }
        view.setLocation(viewPosX, viewPosY);
        boolean bl = res = cW != view.getWidth() || cH != view.getHeight() || cX != view.getX() || cY != view.getY();
        if (res) {
            this.repaint();
        }
        return res;
    }

    public void animateToFit(boolean startAnimation) {
        this.dragVelocityX = 0;
        this.dragVelocityY = 0;
        this.dragFriction = 1000;
        this.resetDragSpeed();
        this.fitSizeTime = -1;
        ScrollPane.animateScrollPane(startAnimation ? this : null);
    }

    protected void setViewLocation(int viewX, int viewY) {
        this.getView().setLocation(viewX, viewY);
    }
}

