/*
 * Decompiled with CFR 0.152.
 */
package net.yura.domination.engine.guishared;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.awt.Stroke;
import java.util.Vector;
import javax.swing.JPanel;
import net.yura.domination.engine.Risk;
import net.yura.domination.engine.core.Player;
import net.yura.domination.engine.core.StatType;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.ChartTheme;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.StandardChartTheme;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.xy.DefaultXYItemRenderer;
import org.jfree.chart.renderer.xy.XYItemRenderer;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class JFreeStatsPanel
extends JPanel {
    private Risk risk;

    public JFreeStatsPanel(Risk myrisk) {
        this.risk = myrisk;
        this.setLayout(new BorderLayout());
        ChartFactory.setChartTheme((ChartTheme)StandardChartTheme.createDarknessTheme());
    }

    public void repaintStats(StatType statType) {
        JFreeChart chart = ChartFactory.createXYLineChart(null, null, null, (XYDataset)this.getDataset(statType), (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)true);
        chart.getXYPlot().setRenderer(this.getRenderer());
        this.removeAll();
        this.add((Component)new ChartPanel(chart));
        this.revalidate();
        this.repaint();
    }

    private XYItemRenderer getRenderer() {
        DefaultXYItemRenderer renderer = new DefaultXYItemRenderer();
        renderer.setBaseShapesVisible(false);
        Vector players = this.risk.getGame().getPlayers();
        for (int c = 0; c < players.size(); ++c) {
            Color color = new Color(((Player)players.get(c)).getColor());
            renderer.setSeriesPaint(c, (Paint)color);
            renderer.setSeriesStroke(c, (Stroke)new BasicStroke(2.0f));
        }
        return renderer;
    }

    private XYSeriesCollection getDataset(StatType statType) {
        XYSeriesCollection dataset = new XYSeriesCollection();
        Vector players = this.risk.getGame().getPlayersStats();
        for (Player player : players) {
            XYSeries series = new XYSeries((Comparable)((Object)player.getName()));
            double[] PointToDraw = player.getStatistics(statType);
            double newPoint = 0.0;
            series.add(0.0, newPoint);
            for (int c = 0; c < PointToDraw.length; ++c) {
                double aPointToDraw = PointToDraw[c];
                newPoint = statType.isSummable() ? (newPoint += aPointToDraw) : aPointToDraw;
                series.add((double)(c + 1), newPoint);
            }
            dataset.addSeries(series);
        }
        return dataset;
    }
}

