/*
 * Decompiled with CFR 0.152.
 */
package com.impossibl.postgres.jdbc;

import com.impossibl.postgres.api.jdbc.PGSQLOutput;
import com.impossibl.postgres.jdbc.Exceptions;
import com.impossibl.postgres.jdbc.PGConnectionImpl;
import com.impossibl.postgres.jdbc.SQLTypeUtils;
import com.impossibl.postgres.types.CompositeType;
import com.impossibl.postgres.utils.guava.ByteStreams;
import com.impossibl.postgres.utils.guava.CharStreams;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLData;
import java.sql.SQLException;
import java.sql.SQLType;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Collections;

public class PGSQLOutputImpl
implements PGSQLOutput {
    private PGConnectionImpl connection;
    private CompositeType type;
    private int currentAttributeIdx;
    private Object[] attributeValues;

    public PGSQLOutputImpl(PGConnectionImpl connection, CompositeType type) {
        this.connection = connection;
        this.type = type;
        this.attributeValues = new Object[type.getAttributes().size()];
    }

    public Object[] getAttributeValues() {
        return this.attributeValues;
    }

    void writeNextAttributeValue(Object val) throws SQLException {
        CompositeType.Attribute attr = this.type.getAttribute(this.currentAttributeIdx + 1);
        if (attr == null) {
            throw new SQLException("invalid attribute access");
        }
        Class<?> targetType = SQLTypeUtils.mapSetType(attr.getType());
        this.attributeValues[this.currentAttributeIdx++] = SQLTypeUtils.coerce(val, attr.getType(), targetType, Collections.emptyMap(), this.connection);
    }

    @Override
    public void writeString(String x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeBoolean(boolean x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeByte(byte x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeShort(short x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeInt(int x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeLong(long x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeFloat(float x) throws SQLException {
        this.writeNextAttributeValue(Float.valueOf(x));
    }

    @Override
    public void writeDouble(double x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeBigDecimal(BigDecimal x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeBytes(byte[] x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeDate(Date x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeTime(Time x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeTimestamp(Timestamp x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeCharacterStream(Reader x) throws SQLException {
        try {
            this.writeNextAttributeValue(CharStreams.toString(x));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void writeAsciiStream(InputStream x) throws SQLException {
        try {
            this.writeNextAttributeValue(new String(ByteStreams.toByteArray(x), StandardCharsets.US_ASCII));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void writeBinaryStream(InputStream x) throws SQLException {
        try {
            this.writeNextAttributeValue(ByteStreams.toByteArray(x));
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    @Override
    public void writeArray(Array x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeURL(URL x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeObject(SQLData x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeObject(Object x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeBlob(Blob x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeClob(Clob x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeStruct(Struct x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeSQLXML(SQLXML x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeRowId(RowId x) throws SQLException {
        this.writeNextAttributeValue(x);
    }

    @Override
    public void writeRef(Ref x) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }

    @Override
    public void writeNString(String x) throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void writeNClob(NClob x) throws SQLException {
        throw Exceptions.NOT_SUPPORTED;
    }

    @Override
    public void writeObject(Object x, SQLType targetSqlType) throws SQLException {
        throw Exceptions.NOT_IMPLEMENTED;
    }
}

