/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.AbstractAction;
import javax.swing.JPanel;
import javax.swing.LayoutFocusTraversalPolicy;
import javax.swing.text.JTextComponent;
import org.jabref.Globals;
import org.jabref.gui.BasePanel;
import org.jabref.gui.IconTheme;
import org.jabref.gui.JabRefDialog;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.fieldeditors.FieldEditor;
import org.jabref.gui.fieldeditors.TextArea;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.undo.UndoablePreambleChange;
import org.jabref.gui.util.WindowLocation;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabase;

class PreambleEditor
extends JabRefDialog {
    private final BibDatabase database;
    private final BasePanel panel;
    private final FieldEditor editor;
    private final UndoAction undoAction = new UndoAction();
    private final StoreFieldAction storeFieldAction = new StoreFieldAction();
    private final RedoAction redoAction = new RedoAction();
    private final CloseAction closeAction = new CloseAction();

    public PreambleEditor(JabRefFrame baseFrame, BasePanel panel, BibDatabase database) {
        super((Frame)baseFrame, PreambleEditor.class);
        this.panel = panel;
        this.database = database;
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                PreambleEditor.this.closeAction.actionPerformed(null);
            }

            @Override
            public void windowOpened(WindowEvent e) {
                PreambleEditor.this.editor.requestFocus();
            }
        });
        this.setFocusTraversalPolicy(new LayoutFocusTraversalPolicy(){

            @Override
            protected boolean accept(Component c) {
                return super.accept(c) && c instanceof FieldEditor;
            }
        });
        JPanel pan = new JPanel();
        GridBagLayout gbl = new GridBagLayout();
        pan.setLayout(gbl);
        GridBagConstraints con = new GridBagConstraints();
        con.fill = 1;
        con.weighty = 1.0;
        con.insets = new Insets(10, 5, 10, 5);
        this.editor = new TextArea(Localization.lang("Preamble", new String[0]), database.getPreamble().orElse(""));
        con.weightx = 1.0;
        gbl.setConstraints(this.editor.getPane(), con);
        pan.add(this.editor.getPane());
        Container conPane = this.getContentPane();
        conPane.add((Component)pan, "Center");
        this.setTitle(Localization.lang("Edit preamble", new String[0]));
        WindowLocation pw = new WindowLocation(this, "preamblePosX", "preamblePosY", "preambleSizeX", "preambleSizeY");
        pw.displayWindowAtStoredLocation();
    }

    private void setupJTextComponent(JTextComponent ta) {
        ta.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.CLOSE_DIALOG), "close");
        ta.getActionMap().put("close", this.closeAction);
        ta.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.PREAMBLE_EDITOR_STORE_CHANGES), "store");
        ta.getActionMap().put("store", this.storeFieldAction);
        ta.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.UNDO), "undo");
        ta.getActionMap().put("undo", this.undoAction);
        ta.getInputMap().put(Globals.getKeyPrefs().getKey(KeyBinding.REDO), "redo");
        ta.getActionMap().put("redo", this.redoAction);
        ta.addFocusListener(new FieldListener());
    }

    public void updatePreamble() {
        this.editor.setText(this.database.getPreamble().orElse(""));
    }

    public FieldEditor getFieldEditor() {
        return this.editor;
    }

    public void storeCurrentEdit() {
        this.storeFieldAction.actionPerformed(null);
    }

    class CloseAction
    extends AbstractAction {
        public CloseAction() {
            super(Localization.lang("Close window", new String[0]));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreambleEditor.this.storeFieldAction.actionPerformed(null);
            PreambleEditor.this.panel.preambleEditorClosing();
            PreambleEditor.this.dispose();
        }
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super("Redo", IconTheme.JabRefIcon.REDO.getIcon());
            this.putValue("ShortDescription", "Redo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreambleEditor.this.panel.runCommand("redo");
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super("Undo", IconTheme.JabRefIcon.UNDO.getIcon());
            this.putValue("ShortDescription", "Undo");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PreambleEditor.this.panel.runCommand("undo");
        }
    }

    class StoreFieldAction
    extends AbstractAction {
        public StoreFieldAction() {
            super("Store field value");
            this.putValue("ShortDescription", "Store field value");
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String toSet = PreambleEditor.this.editor.getText();
            if (!PreambleEditor.this.database.getPreamble().orElse("").equals(toSet)) {
                PreambleEditor.this.panel.getUndoManager().addEdit(new UndoablePreambleChange(PreambleEditor.this.database, PreambleEditor.this.panel, PreambleEditor.this.database.getPreamble().orElse(null), toSet));
                PreambleEditor.this.database.setPreamble(toSet);
                PreambleEditor.this.editor.setValidBackgroundColor();
                if (PreambleEditor.this.editor.hasFocus()) {
                    PreambleEditor.this.editor.setActiveBackgroundColor();
                }
                PreambleEditor.this.panel.markBaseChanged();
            }
        }
    }

    private class FieldListener
    extends FocusAdapter {
        private FieldListener() {
        }

        @Override
        public void focusLost(FocusEvent e) {
            if (!e.isTemporary()) {
                PreambleEditor.this.storeFieldAction.actionPerformed(new ActionEvent(e.getSource(), 0, ""));
            }
        }
    }
}

