/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.ObservableMap;
import org.fxmisc.easybind.EasyBind;
import org.fxmisc.easybind.monadic.MonadicBinding;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.groups.GroupTreeNode;
import org.jabref.model.util.OptionalUtil;

public class StateManager {
    private final ObjectProperty<Optional<BibDatabaseContext>> activeDatabase = new SimpleObjectProperty(Optional.empty());
    private final ReadOnlyListWrapper<GroupTreeNode> activeGroups = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final ObservableList<BibEntry> selectedEntries = FXCollections.observableArrayList();
    private final ObservableMap<BibDatabaseContext, ObservableList<GroupTreeNode>> selectedGroups = FXCollections.observableHashMap();

    public StateManager() {
        MonadicBinding<BibDatabaseContext> currentDatabase = EasyBind.map(this.activeDatabase, database -> database.orElse(null));
        this.activeGroups.bind((ObservableValue)Bindings.valueAt(this.selectedGroups, currentDatabase));
    }

    public ObjectProperty<Optional<BibDatabaseContext>> activeDatabaseProperty() {
        return this.activeDatabase;
    }

    public ReadOnlyListProperty<GroupTreeNode> activeGroupProperty() {
        return this.activeGroups.getReadOnlyProperty();
    }

    public ObservableList<BibEntry> getSelectedEntries() {
        return this.selectedEntries;
    }

    public void setSelectedEntries(List<BibEntry> newSelectedEntries) {
        this.selectedEntries.setAll(newSelectedEntries);
    }

    public void setSelectedGroups(BibDatabaseContext database, List<GroupTreeNode> newSelectedGroups) {
        Objects.requireNonNull(newSelectedGroups);
        this.selectedGroups.put((Object)database, (Object)FXCollections.observableArrayList(newSelectedGroups));
    }

    public ObservableList<GroupTreeNode> getSelectedGroup(BibDatabaseContext database) {
        ObservableList selectedGroupsForDatabase = (ObservableList)this.selectedGroups.get((Object)database);
        return selectedGroupsForDatabase != null ? selectedGroupsForDatabase : FXCollections.observableArrayList();
    }

    public void clearSelectedGroups(BibDatabaseContext database) {
        this.selectedGroups.remove((Object)database);
    }

    public Optional<BibDatabaseContext> getActiveDatabase() {
        return (Optional)this.activeDatabase.get();
    }

    public List<BibEntry> getEntriesInCurrentDatabase() {
        return OptionalUtil.flatMap((Optional)this.activeDatabase.get(), BibDatabaseContext::getEntries).collect(Collectors.toList());
    }
}

