/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.groups;

import java.awt.Color;
import java.awt.Component;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;
import org.jabref.gui.groups.GroupTreeNodeViewModel;
import org.jabref.model.groups.GroupTreeNode;

public class GroupTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Object highlight1Cell;
    private List<GroupTreeNode> overlappingGroups = new ArrayList<GroupTreeNode>();
    private List<GroupTreeNode> matchingGroups = new ArrayList<GroupTreeNode>();
    private Object highlightBorderCell;

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean tmpHasFocus) {
        this.selected = Objects.equals(this.highlight1Cell, value) || sel;
        Component c = super.getTreeCellRendererComponent(tree, value, this.selected, expanded, leaf, row, tmpHasFocus);
        if (!(value instanceof GroupTreeNodeViewModel)) {
            return c;
        }
        if (!(c instanceof JLabel)) {
            return c;
        }
        GroupTreeNodeViewModel viewModel = (GroupTreeNodeViewModel)value;
        JLabel label = (JLabel)c;
        Border border = Objects.equals(this.highlightBorderCell, value) ? BorderFactory.createLineBorder(Color.BLACK) : BorderFactory.createEmptyBorder();
        if (label.getBorder() != border) {
            label.setBorder(border);
        }
        Boolean red = this.printInRed(viewModel) && !this.selected;
        Boolean underlined = this.printUnderlined(viewModel);
        StringBuilder sb = new StringBuilder(60);
        sb.append("<html>");
        if (red.booleanValue()) {
            sb.append("<font color=\"#FF0000\">");
        }
        if (underlined.booleanValue()) {
            sb.append("<u>");
        }
        if (viewModel.printInItalics()) {
            sb.append("<i>");
        }
        sb.append(viewModel.getName());
        if (viewModel.printInItalics()) {
            sb.append("</i>");
        }
        if (underlined.booleanValue()) {
            sb.append("</u>");
        }
        if (red.booleanValue()) {
            sb.append("</font>");
        }
        sb.append("</html>");
        String text = sb.toString();
        if (!label.getText().equals(text)) {
            label.setText(text);
        }
        label.setToolTipText(viewModel.getDescription());
        return c;
    }

    private boolean printInRed(GroupTreeNodeViewModel viewModel) {
        if (viewModel.isAllEntriesGroup()) {
            return false;
        }
        return this.overlappingGroups.contains(viewModel.getNode());
    }

    private boolean printUnderlined(GroupTreeNodeViewModel viewModel) {
        if (viewModel.isAllEntriesGroup()) {
            return false;
        }
        return this.matchingGroups.contains(viewModel.getNode());
    }

    public void setHighlightBorderCell(Object highlightBorderCell) {
        this.highlightBorderCell = highlightBorderCell;
    }
}

