/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.importer;

import java.awt.event.ActionEvent;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Optional;
import java.util.SortedSet;
import javafx.stage.FileChooser;
import javax.swing.AbstractAction;
import javax.swing.JOptionPane;
import org.jabref.Globals;
import org.jabref.gui.FXDialogService;
import org.jabref.gui.JabRefFrame;
import org.jabref.gui.actions.MnemonicAwareAction;
import org.jabref.gui.importer.ImportMenuItem;
import org.jabref.gui.keyboard.KeyBinding;
import org.jabref.gui.util.DefaultTaskExecutor;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.gui.util.FileFilterConverter;
import org.jabref.logic.importer.Importer;
import org.jabref.logic.l10n.Localization;

public class ImportFormats {
    private ImportFormats() {
    }

    public static AbstractAction getImportAction(final JabRefFrame frame, boolean openInNew) {
        class ImportAction
        extends MnemonicAwareAction {
            private final boolean newDatabase;

            public ImportAction(boolean newDatabase) {
                this.newDatabase = newDatabase;
                if (newDatabase) {
                    this.putValue("Name", Localization.menuTitle("Import into new library", new String[0]));
                    this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.IMPORT_INTO_NEW_DATABASE));
                } else {
                    this.putValue("Name", Localization.menuTitle("Import into current library", new String[0]));
                    this.putValue("AcceleratorKey", Globals.getKeyPrefs().getKey(KeyBinding.IMPORT_INTO_CURRENT_DATABASE));
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SortedSet<Importer> importers = Globals.IMPORT_FORMAT_READER.getImportFormats();
                String workingDirectory = Globals.prefs.get("importWorkingDirectory");
                FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(FileFilterConverter.forAllImporters(importers)).addExtensionFilter(FileFilterConverter.ANY_FILE).addExtensionFilter(FileFilterConverter.importerToExtensionFilter(importers)).withInitialDirectory(workingDirectory).build();
                FXDialogService dialogService = new FXDialogService();
                DefaultTaskExecutor.runInJavaFXThread(() -> dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(path -> this.doImport((Path)path, importers, fileDialogConfiguration.getSelectedExtensionFilter())));
            }

            private void doImport(Path file, SortedSet<Importer> importers, FileChooser.ExtensionFilter selectedExtensionFilter) {
                if (!Files.exists(file, new LinkOption[0])) {
                    JOptionPane.showMessageDialog(frame, Localization.lang("File not found", new String[0]) + ": '" + file.getFileName() + "'.", Localization.lang("Import", new String[0]), 0);
                    return;
                }
                Optional<Importer> format = FileFilterConverter.getImporter(selectedExtensionFilter, importers);
                ImportMenuItem importMenu = new ImportMenuItem(frame, this.newDatabase, format.orElse(null));
                importMenu.automatedImport(Collections.singletonList(file.toString()));
                Globals.prefs.put("importWorkingDirectory", file.getParent().toString());
            }
        }
        return new ImportAction(openInNew);
    }
}

