/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.logic.journals.Abbreviation;

public class AbbreviationViewModel {
    private final Abbreviation abbreviationObject;
    private final StringProperty name = new SimpleStringProperty("");
    private final StringProperty abbreviation = new SimpleStringProperty("");
    private final BooleanProperty pseudoAbbreviation = new SimpleBooleanProperty();

    public AbbreviationViewModel(Abbreviation abbreviation) {
        this.abbreviationObject = abbreviation;
        this.pseudoAbbreviation.set(this.abbreviationObject == null);
        if (this.abbreviationObject != null) {
            this.name.bindBidirectional((Property)this.abbreviationObject.nameProperty());
            this.abbreviation.bindBidirectional((Property)this.abbreviationObject.abbreviationProperty());
        } else {
            this.name.set((Object)"Add new Abbreviation");
        }
    }

    public Abbreviation getAbbreviationObject() {
        return this.abbreviationObject;
    }

    public void setName(String name) {
        this.name.set((Object)name);
    }

    public void setAbbreviation(String abbreviation) {
        this.abbreviation.set((Object)abbreviation);
    }

    public String getName() {
        return (String)this.name.get();
    }

    public String getAbbreviation() {
        return (String)this.abbreviation.get();
    }

    public boolean isPseudoAbbreviation() {
        return this.pseudoAbbreviation.get();
    }

    public StringProperty nameProperty() {
        return this.name;
    }

    public StringProperty abbreviationProperty() {
        return this.abbreviation;
    }

    public BooleanProperty isPseudoAbbreviationProperty() {
        return this.pseudoAbbreviation;
    }

    public int hashCode() {
        return Objects.hash(this.abbreviationObject);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AbbreviationViewModel) {
            return Objects.equals(this.abbreviationObject, ((AbbreviationViewModel)obj).abbreviationObject);
        }
        return false;
    }
}

