/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.integrity;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.jabref.logic.integrity.IntegrityCheck;
import org.jabref.logic.integrity.IntegrityMessage;
import org.jabref.logic.integrity.ValueChecker;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.util.OptionalUtil;

public class FieldChecker
implements IntegrityCheck.Checker {
    protected final String field;
    private final ValueChecker checker;

    public FieldChecker(String field2, ValueChecker checker) {
        this.field = field2;
        this.checker = Objects.requireNonNull(checker);
    }

    @Override
    public List<IntegrityMessage> check(BibEntry entry) {
        Optional<String> value = entry.getField(this.field);
        if (!value.isPresent()) {
            return Collections.emptyList();
        }
        return OptionalUtil.toList(this.checker.checkValue(value.get()).map(message -> new IntegrityMessage((String)message, entry, this.field)));
    }
}

