/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.database;

import com.google.common.eventbus.Subscribe;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.event.EntryRemovedEvent;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.FieldProperty;
import org.jabref.model.entry.InternalBibtexFields;
import org.jabref.model.entry.event.FieldChangedEvent;

public class KeyChangeListener {
    private final BibDatabase database;
    private final List<String> keyFields = new ArrayList<String>();

    public KeyChangeListener(BibDatabase database) {
        this.database = database;
        for (String fieldName : InternalBibtexFields.getAllPublicFieldNames()) {
            if (!InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.SINGLE_ENTRY_LINK) && !InternalBibtexFields.getFieldProperties(fieldName).contains((Object)FieldProperty.MULTIPLE_ENTRY_LINK)) continue;
            this.keyFields.add(fieldName);
        }
    }

    @Subscribe
    public void listen(FieldChangedEvent event) {
        if (event.getFieldName().equals("bibtexkey")) {
            String newKey = event.getNewValue();
            String oldKey = event.getOldValue();
            this.updateEntryLinks(newKey, oldKey);
        }
    }

    @Subscribe
    public void listen(EntryRemovedEvent event) {
        event.getBibEntry().getCiteKeyOptional().ifPresent(oldKey -> this.updateEntryLinks(null, (String)oldKey));
    }

    private void updateEntryLinks(String newKey, String oldKey) {
        for (BibEntry entry : this.database.getEntries()) {
            for (String field2 : this.keyFields) {
                entry.getField(field2).ifPresent(fieldContent -> {
                    if (InternalBibtexFields.getFieldProperties(field2).contains((Object)FieldProperty.SINGLE_ENTRY_LINK)) {
                        this.replaceSingleKeyInField(newKey, oldKey, entry, field2, (String)fieldContent);
                    } else {
                        this.replaceKeyInMultiplesKeyField(newKey, oldKey, entry, field2, (String)fieldContent);
                    }
                });
            }
        }
    }

    private void replaceKeyInMultiplesKeyField(String newKey, String oldKey, BibEntry entry, String field2, String fieldContent) {
        ArrayList<String> keys = new ArrayList<String>(Arrays.asList(fieldContent.split(",")));
        int index = keys.indexOf(oldKey);
        if (index != -1) {
            if (newKey == null) {
                keys.remove(index);
            } else {
                keys.set(index, newKey);
            }
            entry.setField(field2, String.join((CharSequence)",", keys));
        }
    }

    private void replaceSingleKeyInField(String newKey, String oldKey, BibEntry entry, String field2, String fieldContent) {
        if (fieldContent.equals(oldKey)) {
            if (newKey == null) {
                entry.clearField(field2);
            } else {
                entry.setField(field2, newKey);
            }
        }
    }
}

