/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.infra.build.ant;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.netbeans.installer.infra.build.ant.utils.Utils;

public class LoadLocales
extends Task {
    private String basename;
    private String localesList;

    public void setBasename(String basename) {
        this.basename = basename;
        File basenameFile = new File(basename);
        if (!basenameFile.equals(basenameFile.getAbsoluteFile())) {
            this.basename = new File(this.getProject().getBaseDir(), basename).getPath();
        }
    }

    public void setList(String localesList) {
        this.localesList = localesList;
    }

    public void execute() throws BuildException {
        Utils.setProject(this.getProject());
        String locales = "";
        try {
            File file = new File(this.basename + ".properties");
            Properties properties = new Properties();
            properties.load(new FileInputStream(file));
            for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                this.getProject().setProperty(entry.getKey() + ".default", entry.getValue().toString());
            }
            for (Locale locale : Locale.getAvailableLocales()) {
                file = new File(this.basename + "_" + locale + ".properties");
                if (!file.exists()) continue;
                locales = locales + " " + locale;
                properties = new Properties();
                properties.load(new FileInputStream(file));
                for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                    this.getProject().setProperty("" + entry.getKey() + "." + locale, entry.getValue().toString());
                }
            }
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        this.getProject().setProperty(this.localesList, locales.trim());
    }
}

