/*
 * Decompiled with CFR 0.152.
 */
package com.google.jstestdriver.guice;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.google.jstestdriver.ActionFactory;
import com.google.jstestdriver.BrowserAction;
import com.google.jstestdriver.ResponseStreamFactory;
import com.google.jstestdriver.RunTestsAction;
import com.google.jstestdriver.guice.BrowserActionProvider;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultBrowserActionProvider
implements BrowserActionProvider {
    private final ActionFactory actionFactory;
    private final boolean reset;
    private final List<String> dryRunFor;
    private final List<String> tests;
    private final List<String> commands;
    private final ResponseStreamFactory responseStreamFactory;
    private final boolean captureConsole;

    @Inject
    public DefaultBrowserActionProvider(ActionFactory actionFactory, ResponseStreamFactory responseStreamFactory, @Named(value="reset") boolean reset, @Named(value="dryRunFor") List<String> dryRunFor, @Named(value="captureConsole") boolean captureConsole, @Named(value="tests") List<String> tests, @Named(value="arguments") List<String> commands) {
        this.actionFactory = actionFactory;
        this.reset = reset;
        this.dryRunFor = dryRunFor;
        this.captureConsole = captureConsole;
        this.tests = tests;
        this.commands = commands;
        this.responseStreamFactory = responseStreamFactory;
    }

    @Override
    public List<BrowserAction> get() {
        ArrayList<BrowserAction> threadedActions = new ArrayList<BrowserAction>();
        if (this.reset) {
            threadedActions.add(this.actionFactory.createResetAction(this.responseStreamFactory));
        }
        if (!this.dryRunFor.isEmpty()) {
            threadedActions.add(this.actionFactory.createDryRunAction(this.responseStreamFactory, this.dryRunFor));
        }
        if (!this.tests.isEmpty()) {
            RunTestsAction runTestsAction = this.actionFactory.createRunTestsAction(this.responseStreamFactory, this.tests, this.captureConsole);
            threadedActions.add(runTestsAction);
        }
        if (!this.commands.isEmpty()) {
            for (String cmd : this.commands) {
                threadedActions.add(this.actionFactory.createEvalAction(this.responseStreamFactory, cmd));
            }
        }
        return threadedActions;
    }
}

