/* taxonXref.h was originally generated by the autoSql program, which also 
 * generated taxonXref.c and taxonXref.sql.  This header links the database and
 * the RAM representation of objects. */

#ifndef TAXONXREF_H
#define TAXONXREF_H

#ifndef JKSQL_H
#include "jksql.h"
#endif

#define TAXONXREF_NUM_COLS 4

struct taxonXref
/* mapping from ucsc organism name to ncbi tax id/name */
    {
    struct taxonXref *next;  /* Next in singly linked list. */
    char *organism;	/* UCSC organism name */
    unsigned taxon;	/* NCBI taxon ID */
    char *name;	/* NCBI taxon name Binomial format  */
    char *toGenus;	/* NCBI tree down to Genus */
    };

void taxonXrefStaticLoad(char **row, struct taxonXref *ret);
/* Load a row from taxonXref table into ret.  The contents of ret will
 * be replaced at the next call to this function. */

struct taxonXref *taxonXrefLoad(char **row);
/* Load a taxonXref from row fetched with select * from taxonXref
 * from database.  Dispose of this with taxonXrefFree(). */

struct taxonXref *taxonXrefLoadAll(char *fileName);
/* Load all taxonXref from whitespace-separated file.
 * Dispose of this with taxonXrefFreeList(). */

struct taxonXref *taxonXrefLoadAllByChar(char *fileName, char chopper);
/* Load all taxonXref from chopper separated file.
 * Dispose of this with taxonXrefFreeList(). */

#define taxonXrefLoadAllByTab(a) taxonXrefLoadAllByChar(a, '\t');
/* Load all taxonXref from tab separated file.
 * Dispose of this with taxonXrefFreeList(). */

struct taxonXref *taxonXrefLoadByQuery(struct sqlConnection *conn, char *query);
/* Load all taxonXref from table that satisfy the query given.  
 * Where query is of the form 'select * from example where something=something'
 * or 'select example.* from example, anotherTable where example.something = 
 * anotherTable.something'.
 * Dispose of this with taxonXrefFreeList(). */

void taxonXrefSaveToDb(struct sqlConnection *conn, struct taxonXref *el, char *tableName, int updateSize);
/* Save taxonXref as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size
 * of a string that would contain the entire query. Arrays of native types are
 * converted to comma separated strings and loaded as such, User defined types are
 * inserted as NULL. Note that strings must be escaped to allow insertion into the database.
 * For example "autosql's features include" --> "autosql\'s features include" 
 * If worried about this use taxonXrefSaveToDbEscaped() */

void taxonXrefSaveToDbEscaped(struct sqlConnection *conn, struct taxonXref *el, char *tableName, int updateSize);
/* Save taxonXref as a row to the table specified by tableName. 
 * As blob fields may be arbitrary size updateSize specifies the approx size.
 * of a string that would contain the entire query. Automatically 
 * escapes all simple strings (not arrays of string) but may be slower than taxonXrefSaveToDb().
 * For example automatically copies and converts: 
 * "autosql's features include" --> "autosql\'s features include" 
 * before inserting into database. */ 

struct taxonXref *taxonXrefCommaIn(char **pS, struct taxonXref *ret);
/* Create a taxonXref out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new taxonXref */

void taxonXrefFree(struct taxonXref **pEl);
/* Free a single dynamically allocated taxonXref such as created
 * with taxonXrefLoad(). */

void taxonXrefFreeList(struct taxonXref **pList);
/* Free a list of dynamically allocated taxonXref's */

void taxonXrefOutput(struct taxonXref *el, FILE *f, char sep, char lastSep);
/* Print out taxonXref.  Separate fields with sep. Follow last field with lastSep. */

#define taxonXrefTabOut(el,f) taxonXrefOutput(el,f,'\t','\n');
/* Print out taxonXref as a line in a tab-separated file. */

#define taxonXrefCommaOut(el,f) taxonXrefOutput(el,f,',',',');
/* Print out taxonXref as a comma separated list including final comma. */

/* -------------------------------- End autoSql Generated Code -------------------------------- */

#endif /* TAXONXREF_H */

