/* cnpLocke.c was originally generated by the autoSql program, which also 
 * generated cnpLocke.h and cnpLocke.sql.  This module links the database and
 * the RAM representation of objects. */

#include "common.h"
#include "linefile.h"
#include "dystring.h"
#include "jksql.h"
#include "cnpLocke.h"


void cnpLockeStaticLoad(char **row, struct cnpLocke *ret)
/* Load a row from cnpLocke table into ret.  The contents of ret will
 * be replaced at the next call to this function. */
{

ret->chrom = row[0];
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = row[3];
ret->variationType = row[4];
}

struct cnpLocke *cnpLockeLoad(char **row)
/* Load a cnpLocke from row fetched with select * from cnpLocke
 * from database.  Dispose of this with cnpLockeFree(). */
{
struct cnpLocke *ret;

AllocVar(ret);
ret->chrom = cloneString(row[0]);
ret->chromStart = sqlUnsigned(row[1]);
ret->chromEnd = sqlUnsigned(row[2]);
ret->name = cloneString(row[3]);
ret->variationType = cloneString(row[4]);
return ret;
}

struct cnpLocke *cnpLockeLoadAll(char *fileName) 
/* Load all cnpLocke from a whitespace-separated file.
 * Dispose of this with cnpLockeFreeList(). */
{
struct cnpLocke *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileRow(lf, row))
    {
    el = cnpLockeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpLocke *cnpLockeLoadAllByChar(char *fileName, char chopper) 
/* Load all cnpLocke from a chopper separated file.
 * Dispose of this with cnpLockeFreeList(). */
{
struct cnpLocke *list = NULL, *el;
struct lineFile *lf = lineFileOpen(fileName, TRUE);
char *row[5];

while (lineFileNextCharRow(lf, chopper, row, ArraySize(row)))
    {
    el = cnpLockeLoad(row);
    slAddHead(&list, el);
    }
lineFileClose(&lf);
slReverse(&list);
return list;
}

struct cnpLocke *cnpLockeCommaIn(char **pS, struct cnpLocke *ret)
/* Create a cnpLocke out of a comma separated string. 
 * This will fill in ret if non-null, otherwise will
 * return a new cnpLocke */
{
char *s = *pS;

if (ret == NULL)
    AllocVar(ret);
ret->chrom = sqlStringComma(&s);
ret->chromStart = sqlUnsignedComma(&s);
ret->chromEnd = sqlUnsignedComma(&s);
ret->name = sqlStringComma(&s);
ret->variationType = sqlStringComma(&s);
*pS = s;
return ret;
}

void cnpLockeFree(struct cnpLocke **pEl)
/* Free a single dynamically allocated cnpLocke such as created
 * with cnpLockeLoad(). */
{
struct cnpLocke *el;

if ((el = *pEl) == NULL) return;
freeMem(el->chrom);
freeMem(el->name);
freeMem(el->variationType);
freez(pEl);
}

void cnpLockeFreeList(struct cnpLocke **pList)
/* Free a list of dynamically allocated cnpLocke's */
{
struct cnpLocke *el, *next;

for (el = *pList; el != NULL; el = next)
    {
    next = el->next;
    cnpLockeFree(&el);
    }
*pList = NULL;
}

void cnpLockeOutput(struct cnpLocke *el, FILE *f, char sep, char lastSep) 
/* Print out cnpLocke.  Separate fields with sep. Follow last field with lastSep. */
{
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->chrom);
if (sep == ',') fputc('"',f);
fputc(sep,f);
fprintf(f, "%u", el->chromStart);
fputc(sep,f);
fprintf(f, "%u", el->chromEnd);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->name);
if (sep == ',') fputc('"',f);
fputc(sep,f);
if (sep == ',') fputc('"',f);
fprintf(f, "%s", el->variationType);
if (sep == ',') fputc('"',f);
fputc(lastSep,f);
}

/* -------------------------------- End autoSql Generated Code -------------------------------- */

