/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.evernote;

import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.xmind.ui.evernote.EvernotePlugin;
import org.xmind.ui.evernote.signin.Evernote;
import org.xmind.ui.internal.evernote.EvernoteMessages;
import org.xmind.ui.preference.PreferenceFieldEditorPageSection;

public class EvernotePreferencePageSection
extends PreferenceFieldEditorPageSection
implements IWorkbenchPreferencePage {
    private Label accountLabel;
    private Label usernameLabel;
    private Button changeStatusButton;

    protected void createFieldEditors() {
    }

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(EvernotePlugin.getDefault().getPreferenceStore());
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(1, false);
        layout.marginLeft = 25;
        composite.setLayout((Layout)layout);
        Label descriptionLabel = new Label(composite, 64);
        descriptionLabel.setLayoutData((Object)new GridData(4, 128, true, false));
        descriptionLabel.setText(EvernoteMessages.PreferencePage_FeatureDescription_message);
        this.createAccountInfoArea(composite);
        this.updateStatusSection(false);
        return composite;
    }

    private void updateStatusSection(boolean async) {
        if (this.accountLabel == null || this.accountLabel.isDisposed() || this.usernameLabel == null || this.usernameLabel.isDisposed() || this.changeStatusButton == null || this.changeStatusButton.isDisposed()) {
            return;
        }
        if (async) {
            this.changeStatusButton.getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    EvernotePreferencePageSection.this.updateStatusSection(false);
                }
            });
        } else {
            boolean evernoteSignedIn = this.getPreferenceStore().getBoolean("signedin");
            if (evernoteSignedIn) {
                this.setEnabled((Control)this.accountLabel, true);
                this.setEnabled((Control)this.usernameLabel, true);
                this.usernameLabel.setText(this.getPreferenceStore().getString("username"));
                this.changeStatusButton.setText(EvernoteMessages.PreferencePage_UnlinkEvernote_text);
                this.changeStatusButton.getParent().layout();
                Point p = this.changeStatusButton.getParent().computeSize(-1, -1);
                this.changeStatusButton.getParent().setSize(p);
            } else {
                this.setEnabled((Control)this.accountLabel, false);
                this.setEnabled((Control)this.usernameLabel, false);
                this.changeStatusButton.setText(EvernoteMessages.PreferencePage_LinkEvernote_text);
                this.changeStatusButton.getParent().layout();
            }
        }
    }

    private void createAccountInfoArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout(3, false);
        layout.marginLeft = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        this.accountLabel = new Label(composite, 0);
        this.accountLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.accountLabel.setFont(JFaceResources.getDefaultFont());
        this.accountLabel.setText(EvernoteMessages.PreferencePage_AccountInfo_label);
        this.usernameLabel = new Label(composite, 0);
        this.usernameLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, false));
        this.usernameLabel.setFont(JFaceResources.getDefaultFont());
        this.usernameLabel.setText("");
        this.changeStatusButton = new Button(composite, 8);
        this.changeStatusButton.setText("");
        this.changeStatusButton.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                boolean evernoteSignedin = EvernotePreferencePageSection.this.getPreferenceStore().getBoolean("signedin");
                if (evernoteSignedin && !MessageDialog.openConfirm((Shell)Display.getDefault().getActiveShell(), (String)EvernoteMessages.EvernotePrefPage_unlinkAccountTitle, (String)EvernoteMessages.EvernotePrefPage_unlinkAccountText)) {
                    return;
                }
                EvernotePreferencePageSection.this.changeServiceStatus();
            }
        });
    }

    private void changeServiceStatus() {
        final Display display = Display.getDefault();
        this.changeStatusButton.setEnabled(false);
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                boolean evernoteSignedin = EvernotePreferencePageSection.this.getPreferenceStore().getBoolean("signedin");
                if (evernoteSignedin) {
                    Evernote.signOut();
                } else {
                    Evernote.signIn();
                }
                display.asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (EvernotePreferencePageSection.this.changeStatusButton != null && !EvernotePreferencePageSection.this.changeStatusButton.isDisposed()) {
                            EvernotePreferencePageSection.this.changeStatusButton.setEnabled(true);
                        }
                    }
                });
                EvernotePreferencePageSection.this.updateStatusSection(true);
            }
        });
        t.setDaemon(true);
        t.start();
    }

    private void setEnabled(Control control, boolean enabled) {
        control.setVisible(enabled);
        ((GridData)control.getLayoutData()).exclude = !enabled;
    }
}

