/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.taskinfo;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IOpenListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.OpenEvent;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.xmind.core.ISheet;
import org.xmind.core.ITopic;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.ui.internal.taskinfo.Dependency;
import org.xmind.ui.internal.taskinfo.TaskInfo;
import org.xmind.ui.internal.taskinfo.TaskInfoUtils;
import org.xmind.ui.internal.taskinfo.TaskMessages;
import org.xmind.ui.mindmap.MindMapUI;
import org.xmind.ui.resources.FontUtils;
import org.xmind.ui.util.TextFormatter;
import org.xmind.ui.viewers.ImageCachedLabelProvider;

public class DependencyEditDialog
extends TitleAreaDialog {
    public static final int REMOVE_ID = 1025;
    private static final int FILTER_DELAY = 200;
    private ITopic successor;
    private ISheet sheet;
    private Dependency dependency;
    private Text taskFilter = null;
    private TreeViewer taskViewer = null;
    private ComboViewer typeViewer = null;
    private Label previewViewer = null;
    private ITopic task = null;
    private String type = null;
    private boolean changingTaskSelection = false;
    private boolean changingTypeSelection = false;
    private boolean refreshScheduled = false;
    private Map<Object, List<? extends Object>> taskTreeContent = Collections.emptyMap();
    private Set<ITopic> selectableTasks = Collections.emptySet();
    private Map<ITopic, String> excludedTasks = null;
    private FilterJob filterJob = null;
    private boolean firstTimeRefresh = true;
    private RotatableWrapLabel titleLabel;

    public DependencyEditDialog(Shell parentShell, ITopic successor, Dependency dependency) {
        super(parentShell);
        this.successor = successor;
        this.sheet = successor.getOwnedSheet();
        this.dependency = dependency;
        this.setTask(dependency == null ? null : dependency.getPredecessor());
        this.setType(dependency == null ? "FS" : dependency.getType());
    }

    protected boolean isResizable() {
        return true;
    }

    public void create() {
        super.create();
        this.setTitleImage(null);
    }

    protected Control createDialogArea(Composite parent) {
        Composite parentComposite = (Composite)super.createDialogArea(parent);
        Composite composite = new Composite(parentComposite, 0);
        GridData gd = new GridData(4, 4, true, true);
        gd.minimumWidth = 240;
        composite.setLayoutData((Object)gd);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 7;
        layout.marginHeight = 7;
        layout.horizontalSpacing = 0;
        layout.verticalSpacing = 15;
        composite.setLayout((Layout)layout);
        Control field1 = this.createPredecessorField(composite);
        this.applyFieldLayoutData(field1, true);
        Control field2 = this.createTypeField(composite);
        this.applyFieldLayoutData(field2, false);
        Control field3 = this.createPreviewField(composite);
        this.applyFieldLayoutData(field3, false);
        return parentComposite;
    }

    private void applyFieldLayoutData(Control field, boolean grabVertical) {
        GridData gd = new GridData(4, 4, true, grabVertical);
        field.setLayoutData((Object)gd);
    }

    private Label createLabel(Composite parent, String text) {
        Label label = new Label(parent, 16384);
        label.setText(text);
        return label;
    }

    private Control createPredecessorField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 2;
        composite.setLayout((Layout)layout);
        Label label = this.createLabel(composite, TaskMessages.DependencyEditDialog_Predecessor_label);
        GridData labelLayoutData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)labelLayoutData);
        Control filter = this.createTaskFilter(composite);
        GridData filterLayoutData = new GridData(0x1000008, 0x1000000, true, false);
        filterLayoutData.minimumWidth = 200;
        filter.setLayoutData((Object)filterLayoutData);
        Control viewer = this.createTaskViewer(composite);
        GridData viewerLayoutData = new GridData(4, 4, true, true);
        viewerLayoutData.horizontalSpan = 2;
        viewerLayoutData.heightHint = 200;
        viewerLayoutData.minimumWidth = 100;
        viewerLayoutData.minimumHeight = 60;
        viewer.setLayoutData((Object)viewerLayoutData);
        return composite;
    }

    private Control createTaskFilter(Composite parent) {
        this.taskFilter = new Text(parent, 2436);
        this.taskFilter.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String filterText = ((Text)e.widget).getText();
                DependencyEditDialog.this.startFilter(filterText, false);
            }
        });
        return this.taskFilter;
    }

    private Control createTaskViewer(Composite parent) {
        this.taskViewer = new TreeViewer(parent, 2820);
        this.taskViewer.setContentProvider((IContentProvider)new TaskContentProvider());
        this.taskViewer.setLabelProvider((IBaseLabelProvider)new TaskLabelProvider());
        this.taskViewer.setAutoExpandLevel(-1);
        this.taskViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DependencyEditDialog.this.changingTaskSelection) {
                    return;
                }
                DependencyEditDialog.this.setTask((ITopic)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        this.taskViewer.addOpenListener(new IOpenListener(){

            public void open(OpenEvent event) {
                DependencyEditDialog.this.setTask((ITopic)((IStructuredSelection)event.getSelection()).getFirstElement());
                String error = DependencyEditDialog.this.validateSelection(false);
                if (error == null) {
                    DependencyEditDialog.this.close();
                }
            }
        });
        this.startFilter(null, true);
        return this.taskViewer.getControl();
    }

    private Control createTypeField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 2;
        composite.setLayout((Layout)layout);
        Label label = this.createLabel(composite, TaskMessages.DependencyEditDialog_DependencyType_label);
        GridData labelLayoutData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)labelLayoutData);
        Control viewer = this.createTypeViewer(composite);
        GridData viewerLayoutData = new GridData(4, 4, true, false);
        viewer.setLayoutData((Object)viewerLayoutData);
        return composite;
    }

    private Control createTypeViewer(Composite parent) {
        this.typeViewer = new ComboViewer(parent, 2060);
        this.typeViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new TypeLabelProvider());
        this.typeViewer.setInput((Object)Dependency.TYPES);
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                if (DependencyEditDialog.this.changingTypeSelection) {
                    return;
                }
                DependencyEditDialog.this.setType((String)((IStructuredSelection)event.getSelection()).getFirstElement());
            }
        });
        return this.typeViewer.getControl();
    }

    private Control createPreviewField(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 2;
        layout.verticalSpacing = 2;
        composite.setLayout((Layout)layout);
        Label label = this.createLabel(composite, TaskMessages.DependencyEditDialog_Description_label);
        GridData labelLayoutData = new GridData(16384, 0x1000000, false, false);
        label.setLayoutData((Object)labelLayoutData);
        Control viewer = this.createPreviewViewer(composite);
        GridData viewerLayoutData = new GridData(4, 4, true, false);
        viewer.setLayoutData((Object)viewerLayoutData);
        return composite;
    }

    private Control createPreviewViewer(Composite parent) {
        Composite composite = new Composite(parent, 0);
        StackLayout layout = new StackLayout();
        layout.marginWidth = 15;
        layout.marginHeight = 10;
        composite.setLayout((Layout)layout);
        composite.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                Control c = (Control)e.widget;
                Rectangle r = c.getBounds();
                e.gc.setForeground(e.display.getSystemColor(15));
                e.gc.drawRectangle(0, 0, r.width - 1, r.height - 1);
            }
        });
        this.previewViewer = new Label(composite, 16384);
        this.previewViewer.setFont(FontUtils.getRelativeHeight((String)"org.eclipse.jface.defaultfont", (int)-2));
        layout.topControl = this.previewViewer;
        return composite;
    }

    protected void createButtonsForButtonBar(Composite parent) {
        if (this.dependency != null) {
            this.createButton(parent, 1025, TaskMessages.DependencyEditDialog_Remove_buttonText, false);
        }
        super.createButtonsForButtonBar(parent);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 1025) {
            this.setReturnCode(1025);
            this.close();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected Control createContents(Composite parent) {
        Control contents = super.createContents(parent);
        Label tempTitleLabel = (Label)this.getTitleImageLabel().getParent().getChildren()[2];
        tempTitleLabel.setVisible(false);
        final FigureCanvas canvas = this.createTitleLabel(this.getTitleImageLabel().getParent(), tempTitleLabel);
        canvas.moveAbove((Control)tempTitleLabel);
        this.refresh();
        this.getShell().setText(this.dependency == null ? TaskMessages.DependencyEditDialog_AddDependency_windowTitle : TaskMessages.DependencyEditDialog_EditDependency_windowTitle);
        this.titleLabel.setText(NLS.bind((String)TaskMessages.TaskName_pattern, (Object)TextFormatter.removeNewLineCharacter((String)(this.successor != null ? this.successor.getTitleText() : ""))));
        this.setMessage(TaskMessages.DependencyEditDialog_ChoosePredecessorAndDependencyType_dialogMessage);
        canvas.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                DependencyEditDialog.this.titleLabel.setPrefWidth(canvas.getSize().x);
            }
        });
        return contents;
    }

    private FigureCanvas createTitleLabel(Composite parent, Label tempTitleLabel) {
        FigureCanvas canvas = new FigureCanvas(parent);
        FormData canvasData = new FormData();
        int verticalSpacing = this.convertVerticalDLUsToPixels(4);
        int horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        canvasData.top = new FormAttachment(0, verticalSpacing);
        canvasData.right = new FormAttachment((Control)this.getTitleImageLabel());
        canvasData.left = new FormAttachment(0, horizontalSpacing);
        canvasData.bottom = new FormAttachment(this.getTitleImageLabel().getParent().getChildren()[4]);
        canvas.setLayoutData((Object)canvasData);
        canvas.setVisible(true);
        canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        canvas.setBackground(tempTitleLabel.getBackground());
        this.titleLabel = new RotatableWrapLabel(0);
        this.titleLabel.setSingleLine(true);
        this.titleLabel.setAbbreviated(true);
        canvas.setContents((IFigure)this.titleLabel);
        this.titleLabel.setBackgroundColor(tempTitleLabel.getBackground());
        this.titleLabel.setForegroundColor(tempTitleLabel.getForeground());
        this.titleLabel.setFont(JFaceResources.getBannerFont());
        return canvas;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return TaskInfo.getDefault().getDialogSettings("org.xmind.ui.taskinfo.predecessorDialog");
    }

    public ITopic getTask() {
        return this.task;
    }

    public String getType() {
        return this.type;
    }

    private void setTask(ITopic task) {
        this.task = task;
        this.refresh();
    }

    private void setType(String type) {
        this.type = type;
        this.refresh();
    }

    private void refresh() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        if (this.refreshScheduled) {
            return;
        }
        this.refreshScheduled = true;
        Display.getCurrent().asyncExec(new Runnable(){

            public void run() {
                DependencyEditDialog.this.doRefresh();
                DependencyEditDialog.this.refreshScheduled = false;
            }
        });
    }

    private void doRefresh() {
        if (this.getShell() == null || this.getShell().isDisposed()) {
            return;
        }
        if (this.taskViewer != null && this.taskViewer.getControl() != null && !this.taskViewer.getControl().isDisposed()) {
            this.setTaskSelectionToViewer(this.task);
        }
        if (this.typeViewer != null && this.typeViewer.getControl() != null && !this.typeViewer.getControl().isDisposed()) {
            this.setTypeSelectionToViewer(this.type);
        }
        String validation = this.validateSelection(true);
        Button button = this.getButton(0);
        if (button != null && !button.isDisposed()) {
            button.setEnabled(validation == null);
        }
        if (this.previewViewer != null && !this.previewViewer.isDisposed()) {
            if (this.task != null && this.type != null) {
                String pattern = "FF".equals(this.type) ? TaskMessages.DependencyEditDialog_DescriptionPattern_FF : ("SF".equals(this.type) ? TaskMessages.DependencyEditDialog_DescriptionPattern_SF : ("SS".equals(this.type) ? TaskMessages.DependencyEditDialog_DescriptionPattern_SS : TaskMessages.DependencyEditDialog_DescriptionPattern_FS));
                this.previewViewer.setText(NLS.bind((String)pattern, (Object)this.successor.getTitleText(), (Object)this.task.getTitleText()));
            } else {
                this.previewViewer.setText("");
            }
        }
        this.firstTimeRefresh = false;
    }

    private String validateSelection(boolean considerFirstTimeRefresh) {
        String message = null;
        if (this.task == null) {
            if (this.firstTimeRefresh && considerFirstTimeRefresh) {
                return "";
            }
            message = TaskMessages.DependencyEditDialog_NoPredecessorChosen_warning;
        } else if (!this.selectableTasks.contains(this.task)) {
            if (this.firstTimeRefresh && considerFirstTimeRefresh) {
                return "";
            }
            if (this.excludedTasks != null) {
                message = this.excludedTasks.get(this.task);
            }
            if (message == null) {
                message = TaskMessages.DependencyEditDialog_InvalidPredecessor_warning;
            }
        } else if (this.type == null) {
            if (this.firstTimeRefresh && considerFirstTimeRefresh) {
                return "";
            }
            message = TaskMessages.DependencyEditDialog_NoDependencyTypeChosen_warning;
        }
        this.setErrorMessage(message);
        return message;
    }

    private void setTaskSelectionToViewer(ITopic task) {
        if (this.taskViewer == null || this.taskViewer.getControl() == null || this.taskViewer.getControl().isDisposed()) {
            return;
        }
        this.changingTaskSelection = true;
        this.taskViewer.setSelection((ISelection)(task == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)task)));
        this.changingTaskSelection = false;
    }

    private void setTypeSelectionToViewer(String type) {
        if (this.typeViewer == null || this.typeViewer.getControl() == null || this.typeViewer.getControl().isDisposed()) {
            return;
        }
        this.changingTypeSelection = true;
        this.typeViewer.setSelection((ISelection)(type == null ? StructuredSelection.EMPTY : new StructuredSelection((Object)type)));
        this.changingTypeSelection = false;
    }

    private void startFilter(String filterText, boolean rightNow) {
        this.cancelFilter();
        this.filterJob = new FilterJob(Display.getCurrent(), filterText);
        this.filterJob.schedule(rightNow ? 0L : 200L);
    }

    private void cancelFilter() {
        if (this.filterJob != null) {
            this.filterJob.cancel();
        }
        this.filterJob = null;
    }

    public boolean close() {
        boolean closed = super.close();
        if (closed) {
            this.cancelFilter();
        }
        return closed;
    }

    private class FilterJob
    extends Job {
        private Display display;
        private Pattern filterPattern;
        private Map<Object, List<? extends Object>> newTaskTreeContent;
        private Set<ITopic> newSelectableTasks;
        private Map<ITopic, String> newExcludedTasks;

        public FilterJob(Display display, String filterText) {
            super(TaskMessages.DependencyEditDialog_FilterJob_jobName);
            this.display = display;
            this.filterPattern = filterText == null || "".equals(filterText) ? null : this.createFilterPattern(filterText);
        }

        private Pattern createFilterPattern(String filterText) {
            char[] chars = filterText.toCharArray();
            StringBuffer sb = new StringBuffer(chars.length * 2 + 1);
            int i = 0;
            while (i < chars.length) {
                sb.append('.');
                sb.append('*');
                char c = chars[i];
                switch (c) {
                    case '$': 
                    case '(': 
                    case ')': 
                    case '*': 
                    case '.': 
                    case '?': 
                    case '\\': 
                    case '^': 
                    case '|': {
                        sb.append('\\');
                    }
                }
                sb.append(c);
                ++i;
            }
            sb.append('.');
            sb.append('*');
            filterText = sb.toString();
            return Pattern.compile(filterText, 34);
        }

        protected IStatus run(final IProgressMonitor monitor) {
            this.newTaskTreeContent = new HashMap<Object, List<? extends Object>>(100);
            this.newSelectableTasks = new HashSet<ITopic>(50);
            if (DependencyEditDialog.this.excludedTasks == null) {
                this.newExcludedTasks = new HashMap<ITopic, String>();
                this.newExcludedTasks.put(DependencyEditDialog.this.successor, TaskMessages.DependencyEditDialog_PredecessorSameAsSuccessor_warning);
                ITopic startingPredecessor = DependencyEditDialog.this.dependency == null ? null : DependencyEditDialog.this.dependency.getPredecessor();
                for (Dependency p : TaskInfoUtils.getDependencies(DependencyEditDialog.this.successor)) {
                    ITopic t = p.getPredecessor();
                    if (t == null || t == startingPredecessor) continue;
                    this.newExcludedTasks.put(t, TaskMessages.DependencyEditDialog_DuplicatedDependency_warning);
                }
            }
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.beginTask(TaskMessages.DependencyEditDialog_FilteringTasks_name, 1);
            this.add(DependencyEditDialog.this.sheet.getRootTopic(), monitor);
            if (monitor.isCanceled()) {
                return Status.CANCEL_STATUS;
            }
            monitor.done();
            DependencyEditDialog.this.taskTreeContent = this.newTaskTreeContent;
            DependencyEditDialog.this.selectableTasks = this.newSelectableTasks;
            if (this.newExcludedTasks != null && DependencyEditDialog.this.excludedTasks == null) {
                DependencyEditDialog.this.excludedTasks = this.newExcludedTasks;
            }
            if (this.display != null && !this.display.isDisposed()) {
                this.display.asyncExec(new Runnable(){

                    public void run() {
                        if (monitor.isCanceled() || DependencyEditDialog.this.getShell() == null || DependencyEditDialog.this.getShell().isDisposed()) {
                            return;
                        }
                        DependencyEditDialog.this.taskViewer.setInput((Object)DependencyEditDialog.this.sheet);
                        DependencyEditDialog.this.refresh();
                        DependencyEditDialog.this.filterJob = null;
                    }
                });
            }
            return Status.OK_STATUS;
        }

        private boolean add(ITopic topic, IProgressMonitor monitor) {
            if (monitor.isCanceled()) {
                return false;
            }
            List children = topic.getAllChildren();
            if (monitor.isCanceled()) {
                return false;
            }
            boolean included = this.match(topic);
            if (included) {
                this.newSelectableTasks.add(topic);
            }
            if (monitor.isCanceled()) {
                return false;
            }
            ArrayList<ITopic> filteredChildren = new ArrayList<ITopic>(children.size());
            SubProgressMonitor submonitor = new SubProgressMonitor(monitor, 1);
            submonitor.beginTask(null, children.size());
            for (ITopic child : children) {
                if (monitor.isCanceled()) {
                    return false;
                }
                boolean childIncluded = this.add(child, (IProgressMonitor)submonitor);
                if (childIncluded) {
                    filteredChildren.add(child);
                }
                boolean bl = included = included || childIncluded;
            }
            if (monitor.isCanceled()) {
                return false;
            }
            submonitor.done();
            if (included) {
                this.newTaskTreeContent.put(topic, filteredChildren);
            }
            monitor.worked(1);
            return included;
        }

        private boolean match(ITopic topic) {
            return (this.filterPattern == null || this.filterPattern.matcher(topic.getTitleText()).find()) && !this.isTaskExcluded(topic);
        }

        private boolean isTaskExcluded(ITopic task) {
            if (DependencyEditDialog.this.excludedTasks != null) {
                return DependencyEditDialog.this.excludedTasks.containsKey(task);
            }
            if (this.newExcludedTasks.containsKey(task)) {
                return true;
            }
            boolean cycle = TaskInfoUtils.isCircularDependencies(DependencyEditDialog.this.successor, task);
            if (cycle) {
                this.newExcludedTasks.put(task, TaskMessages.DependencyEditDialog_CircularDependencies_warning);
                return true;
            }
            return false;
        }
    }

    private class TaskContentProvider
    implements ITreeContentProvider {
        private TaskContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            List list = null;
            if (DependencyEditDialog.this.taskTreeContent != null) {
                list = (List)DependencyEditDialog.this.taskTreeContent.get(parentElement);
            }
            return list == null ? new Object[]{} : list.toArray();
        }

        public Object getParent(Object element) {
            return ((ITopic)element).getParent();
        }

        public boolean hasChildren(Object element) {
            List list = null;
            if (DependencyEditDialog.this.taskTreeContent != null) {
                list = (List)DependencyEditDialog.this.taskTreeContent.get(element);
            }
            return list != null && !list.isEmpty();
        }

        public Object[] getElements(Object inputElement) {
            return new Object[]{((ISheet)inputElement).getRootTopic()};
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    private class TaskLabelProvider
    extends ImageCachedLabelProvider
    implements IColorProvider {
        private TaskLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof ITopic) {
                String titleText = ((ITopic)element).getTitleText();
                return titleText.replaceAll("\\r\\n|\\n|\\r", " ");
            }
            return super.getText(element);
        }

        protected Image createImage(Object element) {
            ImageDescriptor icon = MindMapUI.getImages().getElementIcon(element, true);
            if (icon == null) {
                return null;
            }
            return icon.createImage(false);
        }

        public Color getBackground(Object element) {
            return null;
        }

        public Color getForeground(Object element) {
            if (!DependencyEditDialog.this.selectableTasks.contains(element)) {
                return Display.getCurrent().getSystemColor(15);
            }
            return null;
        }
    }

    private class TypeLabelProvider
    extends LabelProvider {
        private TypeLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof String) {
                return Dependency.typeName((String)element);
            }
            return super.getText(element);
        }
    }
}

