/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.gantt2.viewer;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import org.eclipse.draw2d.AbstractHintLayout;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Layer;
import org.eclipse.draw2d.LayeredPane;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.LineBorder;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseListener;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.util.Util;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.ToolBar;
import org.xmind.gef.draw2d.RotatableWrapLabel;
import org.xmind.gef.util.Properties;
import org.xmind.ui.gantt.ChangeViewerModeAction;
import org.xmind.ui.gantt2.viewer.GanttViewer;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthEntry;
import org.xmind.ui.gantt2.viewer.TaskTreeWidthsSupport;
import org.xmind.ui.resources.ColorUtils;
import org.xmind.ui.resources.FontUtils;

public class TaskTreeHeaderViewer
implements PropertyChangeListener {
    private static Color splitColor = ColorUtils.getColor((String)"#e8f1fb");
    private Viewport viewport;
    private TaskTreeWidthsSupport widthsSupport;
    private SplitBar[] splits;
    private RotatableWrapLabel[] buttons;
    private IFigure[] insertFeedbacks;
    private FigureCanvas canvas;
    private ToolBarManager toolBarManager;
    private PropertyChangeListener itemsChangeListener;
    private GanttViewer ganttViewer;
    private boolean hasDragged;
    private int dragIndex = -1;
    private Listener filter;
    private PropertyChangeListener propertiesListener;

    public TaskTreeHeaderViewer(TaskTreeWidthsSupport widthsSupport) {
        this.widthsSupport = widthsSupport;
        widthsSupport.addPropertyChangeListener(this);
        widthsSupport.addItemsChangeListener(this.getItemsChangeListener());
    }

    public Control createControl(Composite parent, Color background) {
        LightweightSystem lws = new LightweightSystem();
        this.canvas = new FigureCanvas(parent, 0x20100000, lws);
        this.canvas.setBackground(background);
        this.canvas.setScrollBarVisibility(FigureCanvas.NEVER);
        this.canvas.setViewport(this.getViewport());
        this.addHorizontalScrollSupport(this.canvas);
        LayeredPane layeredPane = new LayeredPane();
        this.getViewport().setContents((IFigure)layeredPane);
        this.createSplitLines((Composite)this.canvas);
        this.createToolbar((Composite)this.canvas);
        this.createFigures((IFigure)layeredPane);
        this.createFeedback((IFigure)layeredPane);
        this.addFeedbackFilter(layeredPane);
        this.addPropertiesListener();
        this.canvas.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                TaskTreeHeaderViewer.this.widthsSupport.removePropertyChangeListener(TaskTreeHeaderViewer.this);
                TaskTreeHeaderViewer.this.widthsSupport.removeItemsChangeListener(TaskTreeHeaderViewer.this.getItemsChangeListener());
                TaskTreeHeaderViewer.this.removeFeedbackFilter();
                TaskTreeHeaderViewer.this.removePropertiesListener();
            }
        });
        return this.canvas;
    }

    private void addHorizontalScrollSupport(final FigureCanvas canvas) {
        if (Util.isWindows()) {
            canvas.addListener(38, new Listener(){

                public void handleEvent(Event event) {
                    if (!canvas.isDisposed()) {
                        int offset = event.count;
                        offset = -((int)(Math.sqrt(Math.abs(offset)) * (double)offset));
                        Point viewLocation = canvas.getViewport().getViewLocation();
                        canvas.getViewport().setHorizontalLocation(viewLocation.x + offset);
                    }
                }
            });
        }
    }

    private void createSplitLines(Composite parent) {
        this.splits = new SplitBar[this.widthsSupport.getSize()];
        parent.setLayout((Layout)new SplitsLayout());
        int i = 0;
        while (i < this.splits.length) {
            this.splits[i] = new SplitBar(parent, 0x20100000);
            this.splits[i].getControl().setBackground(parent.getBackground());
            this.splits[i].getControl().setForeground(splitColor);
            this.splits[i].setWidth(this.widthsSupport.getWidth(i));
            ++i;
        }
    }

    private void createToolbar(Composite parent) {
        this.toolBarManager = new ToolBarManager(8519936);
        parent.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                TaskTreeHeaderViewer.this.toolBarManager.update(true);
            }
        });
        ToolBar toolbar = this.toolBarManager.createControl(parent);
        toolbar.setBackground(parent.getBackground());
        this.toolBarManager.add((IAction)new ChangeViewerModeAction(this.ganttViewer, this.toolBarManager));
    }

    private void createFigures(IFigure parent) {
        Layer layer = new Layer();
        layer.setLayoutManager((LayoutManager)new HeaderLayout());
        parent.add((IFigure)layer);
        this.buttons = new RotatableWrapLabel[this.widthsSupport.getSize()];
        int i = 1;
        while (i < this.buttons.length) {
            RotatableWrapLabel button;
            this.buttons[i] = button = this.createLabel(this.widthsSupport.getText(i));
            layer.add((IFigure)this.buttons[i]);
            final int j = i;
            this.buttons[i].addMouseMotionListener((MouseMotionListener)new MouseMotionListener.Stub(){

                public void mouseDragged(MouseEvent me) {
                    if (TaskTreeHeaderViewer.this.dragIndex == -1) {
                        return;
                    }
                    Rectangle bounds = button.getParent().getClientArea();
                    int value = me.x - bounds.x;
                    int index = TaskTreeHeaderViewer.getInsertIndex(value, TaskTreeHeaderViewer.this.widthsSupport);
                    if (TaskTreeHeaderViewer.this.insertFeedbacks[index].isVisible()) {
                        return;
                    }
                    IFigure[] iFigureArray = TaskTreeHeaderViewer.this.insertFeedbacks;
                    int n = iFigureArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFigure figure = iFigureArray[n2];
                        figure.setVisible(false);
                        ++n2;
                    }
                    TaskTreeHeaderViewer.this.insertFeedbacks[index].setVisible(true);
                    TaskTreeHeaderViewer.this.hasDragged = true;
                }
            });
            button.addMouseListener((MouseListener)new MouseListener.Stub(){

                public void mousePressed(MouseEvent me) {
                    TaskTreeHeaderViewer.this.dragIndex = j;
                }
            });
            ++i;
        }
    }

    private RotatableWrapLabel createLabel(String text) {
        RotatableWrapLabel label = new RotatableWrapLabel(text);
        label.setTextAlignment(2);
        label.setAbbreviated(true);
        label.setSingleLine(true);
        label.setFont(FontUtils.getNewHeight((String)"org.eclipse.jface.defaultfont", (int)10));
        return label;
    }

    private void createFeedback(IFigure parent) {
        Layer feedbackLayer = new Layer();
        feedbackLayer.setLayoutManager((LayoutManager)new FeedbackLayout());
        parent.add((IFigure)feedbackLayer);
        this.insertFeedbacks = new IFigure[this.widthsSupport.getSize()];
        int i = 0;
        while (i < this.insertFeedbacks.length) {
            this.insertFeedbacks[i] = this.createFeedbackLabel();
            this.insertFeedbacks[i].setVisible(false);
            feedbackLayer.add(this.insertFeedbacks[i]);
            ++i;
        }
    }

    private IFigure createFeedbackLabel() {
        Figure insertFeedback = new Figure();
        insertFeedback.setBorder((Border)new LineBorder(ColorUtils.getColor((String)"#2f7dd9"), 1));
        return insertFeedback;
    }

    private void addFeedbackFilter(final LayeredPane layeredPane) {
        if (this.filter == null) {
            this.filter = new Listener(){

                public void handleEvent(Event event) {
                    if (TaskTreeHeaderViewer.this.hasDragged) {
                        TaskTreeWidthEntry entry;
                        TaskTreeHeaderViewer.this.hasDragged = false;
                        IFigure[] iFigureArray = TaskTreeHeaderViewer.this.insertFeedbacks;
                        int n = iFigureArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            IFigure figure = iFigureArray[n2];
                            figure.setVisible(false);
                            ++n2;
                        }
                        if (TaskTreeHeaderViewer.this.dragIndex == -1) {
                            return;
                        }
                        Rectangle bounds = layeredPane.getClientArea();
                        int value = event.x - bounds.x;
                        int index = TaskTreeHeaderViewer.getInsertIndex(value, TaskTreeHeaderViewer.this.widthsSupport);
                        ++index;
                        TaskTreeWidthEntry[] entries = TaskTreeHeaderViewer.this.widthsSupport.getWidthEntries();
                        ArrayList<TaskTreeWidthEntry> list = new ArrayList<TaskTreeWidthEntry>();
                        TaskTreeWidthEntry[] taskTreeWidthEntryArray = entries;
                        int n3 = entries.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            entry = taskTreeWidthEntryArray[n4];
                            list.add(entry);
                            ++n4;
                        }
                        entry = (TaskTreeWidthEntry)list.get(TaskTreeHeaderViewer.this.dragIndex);
                        list.remove(TaskTreeHeaderViewer.this.dragIndex);
                        int insertIndex = index <= TaskTreeHeaderViewer.this.dragIndex ? index : index - 1;
                        list.add(insertIndex, entry);
                        TaskTreeHeaderViewer.this.widthsSupport.setEntries(list.toArray(new TaskTreeWidthEntry[1]));
                    }
                    TaskTreeHeaderViewer.this.dragIndex = -1;
                }
            };
        }
        Display.getCurrent().addFilter(4, this.filter);
    }

    private void removeFeedbackFilter() {
        if (this.filter != null) {
            Display.getCurrent().removeFilter(4, this.filter);
            this.filter = null;
        }
    }

    private void refreshWidths() {
        int i = 0;
        while (i < this.splits.length) {
            this.widthsSupport.setWidth(i, this.splits[i].width);
            ++i;
        }
    }

    public void refreshSplitWidths() {
        int i = 0;
        while (i < this.splits.length) {
            this.splits[i].setWidth(this.widthsSupport.getWidth(i));
            ++i;
        }
    }

    public FigureCanvas getCanvas() {
        return this.canvas;
    }

    public Viewport getViewport() {
        if (this.viewport == null) {
            this.viewport = new Viewport(true);
        }
        return this.viewport;
    }

    public void setGanttViewer(GanttViewer ganttViewer) {
        this.ganttViewer = ganttViewer;
    }

    public void propertyChange(PropertyChangeEvent evt) {
        this.refreshSplitWidths();
        if (this.getCanvas() != null && !this.getCanvas().isDisposed()) {
            this.getCanvas().layout();
        }
    }

    private void update2() {
        Control[] children;
        Control[] controlArray = children = this.getCanvas().getChildren();
        int n = children.length;
        int n2 = 0;
        while (n2 < n) {
            Control child = controlArray[n2];
            if (!(child instanceof ToolBar)) {
                child.dispose();
            }
            ++n2;
        }
        ((Figure)this.canvas.getContents()).removeAll();
        this.createSplitLines((Composite)this.canvas);
        this.createFigures(this.canvas.getContents());
        this.createFeedback(this.canvas.getContents());
        this.canvas.layout();
    }

    public PropertyChangeListener getItemsChangeListener() {
        if (this.itemsChangeListener == null) {
            this.itemsChangeListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    TaskTreeHeaderViewer.this.update2();
                }
            };
        }
        return this.itemsChangeListener;
    }

    private static int getInsertIndex(int width, TaskTreeWidthsSupport widthsSupport) {
        if (width <= widthsSupport.sum(0)) {
            return 0;
        }
        int i = 0;
        while (i < widthsSupport.getSize() - 1) {
            if (width <= widthsSupport.sum(i + 1)) {
                int mid = (widthsSupport.sum(i) + widthsSupport.sum(i + 1)) / 2;
                if (width < mid) {
                    return i;
                }
                return i + 1;
            }
            ++i;
        }
        return widthsSupport.getSize() - 1;
    }

    private void addPropertiesListener() {
        if (this.getProperties() != null) {
            this.getProperties().addPropertyChangeListener("renderTextAsPath", this.getPropertiesListener());
        }
    }

    private void removePropertiesListener() {
        if (this.getProperties() != null) {
            this.getProperties().removePropertyChangeListener("renderTextAsPath", this.getPropertiesListener());
        }
    }

    private Properties getProperties() {
        if (this.ganttViewer != null) {
            return this.ganttViewer.getProperties();
        }
        return null;
    }

    private PropertyChangeListener getPropertiesListener() {
        if (this.propertiesListener == null) {
            this.propertiesListener = new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (TaskTreeHeaderViewer.this.getProperties() != null) {
                        boolean useAdvancedRenderer = TaskTreeHeaderViewer.this.getProperties().getBoolean("renderTextAsPath", false);
                        int i = 1;
                        while (i < TaskTreeHeaderViewer.this.buttons.length) {
                            RotatableWrapLabel button = TaskTreeHeaderViewer.this.buttons[i];
                            button.setRenderStyle(useAdvancedRenderer ? 1 : 0);
                            ++i;
                        }
                    }
                }
            };
        }
        return this.propertiesListener;
    }

    private class FeedbackLayout
    extends AbstractHintLayout {
        private FeedbackLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension s = new Dimension();
            s.width = TaskTreeHeaderViewer.this.widthsSupport.sum();
            s.height = GanttViewer.DEFAULT_HEADER_HEIGHT;
            return s;
        }

        public void layout(IFigure container) {
            Rectangle r = container.getClientArea();
            int x = r.x;
            int y = r.y;
            int i = 0;
            while (i < TaskTreeHeaderViewer.this.insertFeedbacks.length) {
                TaskTreeHeaderViewer.this.insertFeedbacks[i].setBounds(new Rectangle(x + TaskTreeHeaderViewer.this.widthsSupport.sum(i) - 4, y, 2, r.height));
                ++i;
            }
        }
    }

    private class HeaderLayout
    extends AbstractHintLayout {
        private HeaderLayout() {
        }

        protected Dimension calculatePreferredSize(IFigure container, int wHint, int hHint) {
            Dimension s = new Dimension();
            s.width = TaskTreeHeaderViewer.this.widthsSupport.sum();
            s.height = GanttViewer.DEFAULT_HEADER_HEIGHT;
            return s;
        }

        public void layout(IFigure container) {
            Rectangle r = container.getClientArea();
            int x = r.x;
            int y = r.y;
            int height = ((TaskTreeHeaderViewer)TaskTreeHeaderViewer.this).buttons[1].getPreferredSize().height;
            int height0 = r.height;
            y += height0 - height - 6;
            int i = 1;
            while (i < TaskTreeHeaderViewer.this.buttons.length) {
                TaskTreeHeaderViewer.this.buttons[i].setBounds(new Rectangle(x + TaskTreeHeaderViewer.this.widthsSupport.sum(i - 1), y, TaskTreeHeaderViewer.this.widthsSupport.getWidth(i) - 1, height));
                ++i;
            }
        }
    }

    private class SplitBar
    implements Listener {
        private Control control;
        private org.eclipse.swt.graphics.Point start = null;
        private int width;
        private int startWidth;

        public SplitBar(Composite parent, int style) {
            this.control = new Composite(parent, style);
            this.hook(this.control);
        }

        public Control getControl() {
            return this.control;
        }

        private void hook(Control control) {
            control.setCursor(control.getDisplay().getSystemCursor(9));
            control.addListener(9, (Listener)this);
            control.addListener(3, (Listener)this);
            control.addListener(5, (Listener)this);
            control.addListener(4, (Listener)this);
        }

        public void handleEvent(Event event) {
            switch (event.type) {
                case 9: {
                    this.paintControl(event);
                    break;
                }
                case 3: {
                    this.handleMouseDown(event);
                    break;
                }
                case 5: {
                    this.handleMouseMove(event);
                    break;
                }
                case 4: {
                    this.handleMouseUp(event);
                }
            }
        }

        private void paintControl(Event e) {
            org.eclipse.swt.graphics.Rectangle r = ((Control)e.widget).getBounds();
            r.x = 0;
            r.y = 0;
            e.gc.fillRectangle(r);
            e.gc.drawLine(r.x + 2, r.y, r.x + 2, r.height);
        }

        private void handleMouseDown(Event e) {
            this.start = this.getCursorPosition(e);
            this.startWidth = this.width;
        }

        private void handleMouseUp(Event e) {
            this.start = null;
            this.startWidth = 0;
        }

        private void handleMouseMove(Event e) {
            if (this.start == null) {
                return;
            }
            org.eclipse.swt.graphics.Point p = this.getCursorPosition(e);
            this.setWidth(Math.max(3, p.x - this.start.x + this.startWidth));
            TaskTreeHeaderViewer.this.refreshWidths();
        }

        private org.eclipse.swt.graphics.Point getCursorPosition(Event e) {
            return ((Control)e.widget).toDisplay(e.x, e.y);
        }

        public void setWidth(int width) {
            this.width = width;
        }
    }

    private class SplitsLayout
    extends Layout {
        private SplitsLayout() {
        }

        protected org.eclipse.swt.graphics.Point computeSize(Composite composite, int wHint, int hHint, boolean flushCache) {
            return composite.computeSize(wHint, hHint, flushCache);
        }

        protected void layout(Composite composite, boolean flushCache) {
            Viewport viewport = ((FigureCanvas)composite).getViewport();
            Point origin = new Point();
            if (viewport != null) {
                origin = viewport.getViewLocation();
            }
            int y = composite.getClientArea().y;
            int height = composite.getClientArea().height;
            int i = 0;
            while (i < TaskTreeHeaderViewer.this.splits.length) {
                TaskTreeHeaderViewer.this.splits[i].getControl().setBounds(TaskTreeHeaderViewer.this.widthsSupport.sum(i) - origin.x - 2, y, 5, height);
                ++i;
            }
            ToolBar toolbar = TaskTreeHeaderViewer.this.toolBarManager.getControl();
            org.eclipse.swt.graphics.Point preferredSize = toolbar.computeSize(-1, -1);
            org.eclipse.swt.graphics.Rectangle clientArea = composite.getClientArea();
            int x = TaskTreeHeaderViewer.this.widthsSupport.getWidth(0) < preferredSize.x ? clientArea.x + (TaskTreeHeaderViewer.this.widthsSupport.getWidth(0) - preferredSize.x) : clientArea.x + (TaskTreeHeaderViewer.this.widthsSupport.getWidth(0) - preferredSize.x) / 2 - origin.x;
            toolbar.setBounds(x, clientArea.y + clientArea.height - preferredSize.y - 3, preferredSize.x, preferredSize.y);
            viewport.invalidateTree();
            viewport.validate();
        }
    }
}

