/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.blackbox;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.internal.event.CoreEventSupport;
import org.xmind.ui.blackbox.BlackBoxManager;
import org.xmind.ui.blackbox.BlackBoxMap;
import org.xmind.ui.blackbox.BlackBoxVersion;
import org.xmind.ui.blackbox.IBlackBoxLibrary;
import org.xmind.ui.blackbox.IBlackBoxMap;
import org.xmind.ui.blackbox.IBlackBoxVersion;

public class BlackBoxLibrary
implements IBlackBoxLibrary,
ICoreEventSource {
    private static final String MAP_REMOVE = "mapRemove";
    private static final String VERSION_ADD = "versionAdd";
    private static final String VERSION_REMOVE = "versionRemove";
    private List<IBlackBoxMap> maps = new ArrayList<IBlackBoxMap>();
    private List<String> savedSrcs = new ArrayList<String>();
    private File blackbox = null;
    private ICoreEventSupport coreEventSupport;

    public BlackBoxLibrary() {
        this.load();
    }

    @Override
    public synchronized void addVersion(String source, String mapID, IBlackBoxVersion version) {
        Set<IBlackBoxVersion> versions;
        IBlackBoxMap map = this.findMapBySource(source);
        if (map == null) {
            BlackBoxMap m = new BlackBoxMap(this, mapID);
            m.setSource(source);
            map = m;
            this.maps.add(map);
        }
        if ((versions = map.getVersions()).size() == 0) {
            versions.add(version);
        } else if (versions.size() < 3 && !version.isReliable()) {
            versions.add(version);
        } else {
            IBlackBoxVersion trash = null;
            trash = this.findTrashVersion(versions, version.isReliable());
            versions.remove(trash);
            versions.add(version);
            BlackBoxManager.addTrash(trash);
        }
        if (!this.isSavedMap(source)) {
            this.savedSrcs.add(source);
        }
        this.save(map);
        this.fireTargetEvent(VERSION_ADD, version);
    }

    @Override
    public synchronized boolean removeMap(IBlackBoxMap map) {
        if (this.maps.remove(map)) {
            BlackBoxManager.addTrash(map);
            this.save(map);
            this.fireTargetEvent(MAP_REMOVE, map);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeVersion(IBlackBoxMap map, String timestamp) {
        Set<IBlackBoxVersion> versions = map.getVersions();
        for (IBlackBoxVersion v : versions) {
            if (!v.getTimestamp().equals(timestamp)) continue;
            if (versions.remove(v)) {
                BlackBoxManager.addTrash(v);
                this.save(map);
                if (versions.size() == 0) {
                    this.removeMap(map);
                    this.fireTargetEvent(MAP_REMOVE, map);
                }
                this.fireTargetEvent(VERSION_REMOVE, v);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public synchronized IBlackBoxMap[] getMaps() {
        this.load();
        return this.maps.toArray(new IBlackBoxMap[this.maps.size()]);
    }

    @Override
    public synchronized IBlackBoxMap findMapBySource(String source) {
        for (IBlackBoxMap map : this.maps) {
            if (!source.equals(map.getSource())) continue;
            return map;
        }
        return null;
    }

    @Override
    public synchronized IBlackBoxMap findMapByID(String id) {
        for (IBlackBoxMap map : this.maps) {
            if (!map.getID().equals(id)) continue;
            return map;
        }
        return null;
    }

    @Override
    public synchronized boolean isSavedMap(String source) {
        if (source == null) {
            return false;
        }
        return this.savedSrcs.contains(source);
    }

    @Override
    public synchronized void removeSavedMap(String source) {
        if (this.savedSrcs.size() <= 0 || source == null) {
            return;
        }
        if (this.isSavedMap(source)) {
            this.savedSrcs.remove(source);
        }
    }

    private void load() {
        File[] infos;
        File blackbox = new File(BlackBoxManager.getBlackboxPath());
        if (!blackbox.exists()) {
            return;
        }
        this.maps.clear();
        File[] fileArray = infos = blackbox.listFiles();
        int n = infos.length;
        int n2 = 0;
        while (n2 < n) {
            File info = fileArray[n2];
            String fileName = info.getName();
            String[] parts = fileName.split("\\.");
            if (fileName.contains(".xbkinfo")) {
                try {
                    this.loadBackupInfo(info, parts);
                }
                catch (IOException e) {
                    BlackBoxManager.log("Error occurred while loading maps.", e);
                }
            } else if (fileName.contains(".xbkmap")) {
                this.loadMapInfo(info, parts);
            }
            ++n2;
        }
    }

    private synchronized void save(IBlackBoxMap map) {
        block15: {
            File metaFile = this.getMetaFile(map.getID());
            if (!metaFile.exists()) {
                BufferedWriter writer = null;
                try {
                    try {
                        writer = new BufferedWriter(new FileWriter(metaFile));
                        writer.write(map.getSource());
                        writer.flush();
                    }
                    catch (IOException iOException) {
                        try {
                            if (writer != null) {
                                writer.close();
                            }
                            break block15;
                        }
                        catch (IOException iOException2) {}
                        break block15;
                    }
                }
                catch (Throwable throwable) {
                    try {
                        if (writer != null) {
                            writer.close();
                        }
                    }
                    catch (IOException iOException) {}
                    throw throwable;
                }
                try {
                    if (writer != null) {
                        writer.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        BlackBoxManager.clearTrashes();
    }

    private File getMetaFile(String mapID) {
        if (this.blackbox == null) {
            this.blackbox = new File(BlackBoxManager.getBlackboxPath());
        }
        File metaFile = new File(this.blackbox, String.valueOf(mapID) + ".xbkinfo");
        return metaFile;
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.getCoreEventSupport().registerGlobalListener(type, listener);
    }

    private void fireTargetEvent(String eventType, Object target) {
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, eventType, target);
    }

    public ICoreEventSupport getCoreEventSupport() {
        if (this.coreEventSupport == null) {
            this.coreEventSupport = new CoreEventSupport();
        }
        return this.coreEventSupport;
    }

    private IBlackBoxVersion findTrashVersion(Set<IBlackBoxVersion> versions, boolean isReliable) {
        if (isReliable) {
            for (IBlackBoxVersion v : versions) {
                if (!v.isReliable()) continue;
                return v;
            }
        }
        IBlackBoxVersion trash = null;
        for (IBlackBoxVersion v : versions) {
            if (v.isReliable()) continue;
            if (trash == null) {
                trash = v;
                continue;
            }
            IBlackBoxVersion iBlackBoxVersion = trash = trash.compareTo(v) > 0 ? v : trash;
        }
        return trash;
    }

    private void loadBackupInfo(File info, String[] parts) throws IOException {
        BlackBoxMap map = null;
        String mapID = null;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() == 32) {
                mapID = part;
                break;
            }
            ++n2;
        }
        if (mapID == null) {
            return;
        }
        map = (BlackBoxMap)this.findMapByID(mapID);
        if (map == null) {
            map = new BlackBoxMap(this, mapID);
            this.maps.add(map);
        }
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(info));
            StringBuffer sb = new StringBuffer();
            while (reader.ready()) {
                sb.append(reader.readLine());
            }
            String source = sb.toString();
            map.setSource(source);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    private void loadMapInfo(File info, String[] parts) {
        Set<IBlackBoxVersion> versions;
        BlackBoxMap map = null;
        String mapID = null;
        boolean reliable = false;
        String timestamp = null;
        String[] stringArray = parts;
        int n = parts.length;
        int n2 = 0;
        while (n2 < n) {
            String part = stringArray[n2];
            if (part.length() == 32) {
                mapID = part;
            } else if (part.length() == 1) {
                reliable = "a".equals(part);
            } else if (part.length() == 13) {
                timestamp = part;
            }
            ++n2;
        }
        if (mapID == null || timestamp == null) {
            return;
        }
        map = (BlackBoxMap)this.findMapByID(mapID);
        if (map == null) {
            map = new BlackBoxMap(this, mapID);
            this.maps.add(map);
        }
        if ((versions = map.getVersions()).size() < 3) {
            BlackBoxVersion v = new BlackBoxVersion(mapID, timestamp, reliable);
            v.setFile(info);
            versions.add(v);
        }
    }
}

