/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.gui;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import com.pugh.sockso.Properties;
import com.pugh.sockso.gui.BuiltinOptionField;
import com.pugh.sockso.gui.controls.ComboOptionField;
import com.pugh.sockso.gui.controls.TextOptionField;
import com.pugh.sockso.music.encoders.Encoders;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.resources.Resources;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;

public class EncoderPanel
extends JPanel {
    private JRadioButton typeNone;
    private JRadioButton typeBuiltin;
    private JRadioButton typeCustom;
    private ComboOptionField builtinOptions;
    private TextOptionField customCommand;
    private TextOptionField builtinBitrate;
    private JLabel noneLabel;
    private ButtonGroup typeGroup;
    private JPanel builtinPanel;
    private JPanel customPanel;
    private final String fileType;
    private final Properties p;
    private final Resources r;

    public EncoderPanel(JFrame parent, String fileType, Properties p, Resources r) {
        this.fileType = fileType;
        this.p = p;
        this.r = r;
        this.createComponents();
        this.layoutComponents();
        String typeProp = p.get("encoders." + fileType);
        if (Encoders.Type.BUILTIN.name().equals(typeProp)) {
            this.showOption(Encoders.Type.BUILTIN);
        } else if (Encoders.Type.CUSTOM.name().equals(typeProp)) {
            this.showOption(Encoders.Type.CUSTOM);
        } else {
            this.showOption(Encoders.Type.NONE);
        }
    }

    private void createComponents() {
        Locale locale = this.r.getCurrentLocale();
        this.typeGroup = new ButtonGroup();
        this.typeNone = new JRadioButton(locale.getString("gui.label.encTypeNone"));
        this.typeNone.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncoderPanel.this.showOption(Encoders.Type.NONE);
                EncoderPanel.this.saveSelectedOption(Encoders.Type.NONE);
            }
        });
        this.typeBuiltin = new JRadioButton(locale.getString("gui.label.encTypeBuiltin"));
        this.typeBuiltin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncoderPanel.this.showOption(Encoders.Type.BUILTIN);
                EncoderPanel.this.saveSelectedOption(Encoders.Type.BUILTIN);
            }
        });
        this.typeCustom = new JRadioButton(locale.getString("gui.label.encTypeCustom"));
        this.typeCustom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                EncoderPanel.this.showOption(Encoders.Type.CUSTOM);
                EncoderPanel.this.saveSelectedOption(Encoders.Type.CUSTOM);
            }
        });
        this.typeGroup.add(this.typeNone);
        this.typeGroup.add(this.typeBuiltin);
        this.typeGroup.add(this.typeCustom);
        this.builtinOptions = new BuiltinOptionField(this.p, "encoders." + this.fileType + ".name", (Object[])this.getEncoderOptions(this.fileType));
        this.builtinBitrate = new TextOptionField(this.p, "encoders." + this.fileType + ".bitrate");
        this.customCommand = new TextOptionField(this.p, "encoders." + this.fileType + ".command");
        this.customCommand.setMinimumSize(new Dimension(200, 20));
        this.noneLabel = new JLabel(locale.getString("gui.label.encNoneSelected"));
    }

    private Encoders.Builtin[] getEncoderOptions(String fileType) {
        Encoders.Builtin[] encoders = Encoders.getBuiltinEncoders(fileType);
        Encoders.Builtin[] withBlank = new Encoders.Builtin[encoders.length + 1];
        withBlank[0] = null;
        for (int i = 0; i < encoders.length; ++i) {
            withBlank[i + 1] = encoders[i];
        }
        return withBlank;
    }

    protected void saveSelectedOption(Encoders.Type type) {
        this.p.set("encoders." + this.fileType, type.name());
        this.p.save();
    }

    protected void showOption(Encoders.Type type) {
        this.builtinPanel.setVisible(false);
        this.customPanel.setVisible(false);
        this.noneLabel.setVisible(false);
        switch (type) {
            case NONE: {
                this.typeNone.setSelected(true);
                this.noneLabel.setVisible(true);
                break;
            }
            case BUILTIN: {
                this.typeBuiltin.setSelected(true);
                this.builtinPanel.setVisible(true);
                break;
            }
            case CUSTOM: {
                this.typeCustom.setSelected(true);
                this.customPanel.setVisible(true);
            }
        }
    }

    private void layoutComponents() {
        Locale locale = this.r.getCurrentLocale();
        FormLayout layout = new FormLayout(" right:max(40dlu;pref), 3dlu, 150dlu, 7dlu ");
        DefaultFormBuilder builtinBuilder = new DefaultFormBuilder(layout);
        builtinBuilder.setDefaultDialogBorder();
        builtinBuilder.append(locale.getString("gui.label.encoder"), (Component)this.builtinOptions);
        builtinBuilder.nextLine();
        builtinBuilder.append(locale.getString("gui.label.bitrate"), (Component)this.builtinBitrate);
        builtinBuilder.nextLine();
        this.builtinPanel = builtinBuilder.getPanel();
        DefaultFormBuilder customBuilder = new DefaultFormBuilder(layout);
        customBuilder.setDefaultDialogBorder();
        customBuilder.append(locale.getString("gui.label.command"), (Component)this.customCommand);
        customBuilder.nextLine();
        this.customPanel = customBuilder.getPanel();
        JPanel buttonPanel = new JPanel();
        buttonPanel.add(this.typeNone);
        buttonPanel.add(this.typeBuiltin);
        buttonPanel.add(this.typeCustom);
        JPanel mainPanel = new JPanel();
        mainPanel.add(this.builtinPanel);
        mainPanel.add(this.customPanel);
        mainPanel.add(this.noneLabel);
        this.setLayout(new BorderLayout());
        this.add((Component)buttonPanel, "North");
        this.add((Component)mainPanel, "Center");
    }
}

