/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.music.tag.aac;

import com.pugh.sockso.music.tag.aac.Atom;
import com.pugh.sockso.music.tag.aac.AtomHeader;
import com.pugh.sockso.music.tag.aac.AtomType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AACMetaData {
    private String track;
    private String artist;
    private String album;
    private int number;
    private int total;
    private String genre;

    public AACMetaData(File file) throws IOException {
        this.parse(file);
    }

    private static void read(FileInputStream fis, AtomHeader lastHeader, ArrayList<AtomHeader> headers, ArrayList<Atom> atoms, AtomType stop) throws IOException {
        AtomHeader ah = new AtomHeader(fis);
        if (ah.getType() == null) {
            return;
        }
        headers.add(ah);
        if (ah.getType() == stop) {
            return;
        }
        if (ah.getType() == AtomType.META) {
            fis.skip(4L);
        }
        if (lastHeader != null && ah.getType() == AtomType.DATA) {
            byte[] data = new byte[(int)(ah.getSize() - (long)AtomHeader.SIZE)];
            fis.read(data);
            atoms.add(new Atom(lastHeader, data));
        } else if (!ah.hasSubAtom()) {
            fis.skip(ah.getSize() - (long)AtomHeader.SIZE);
        }
        AACMetaData.read(fis, ah, headers, atoms, stop);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void parse(File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            ArrayList<AtomHeader> headers = new ArrayList<AtomHeader>();
            ArrayList<Atom> atoms = new ArrayList<Atom>();
            try {
                AACMetaData.read(fis, null, headers, atoms, AtomType.MDAT);
            }
            catch (IOException ioe) {
                // empty catch block
            }
            for (Atom atom : atoms) {
                switch (atom.getHeader().getType()) {
                    case TITLE: {
                        this.track = atom.getData();
                        break;
                    }
                    case ARTIST: {
                        this.artist = atom.getData();
                        break;
                    }
                    case ALBUM: {
                        this.album = atom.getData();
                        break;
                    }
                    case TRACK: {
                        String trackStr = atom.getData();
                        if (trackStr == null || trackStr.indexOf(58) <= 0) break;
                        try {
                            this.number = Integer.parseInt(trackStr.substring(0, trackStr.indexOf(58)));
                            this.total = Integer.parseInt(trackStr.substring(trackStr.indexOf(58) + 1));
                        }
                        catch (Exception ex) {}
                        break;
                    }
                    case GENRE1: {
                        this.genre = atom.getData();
                    }
                }
            }
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public String getTrack() {
        return this.track;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public int getNumber() {
        return this.number;
    }

    public int getTotal() {
        return this.total;
    }

    public String getGenre() {
        return this.genre;
    }

    public static void main(String[] args) throws IOException {
        AACMetaData tagger = new AACMetaData(new File(args[0]));
        System.out.println("AACMetaData: track[" + tagger.getTrack() + "] artist[" + tagger.getArtist() + "] album[" + tagger.getAlbum() + "] number[" + tagger.getNumber() + "] total[" + tagger.getTotal() + "] genre[" + tagger.getGenre() + "]");
    }
}

