/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Utils;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.log4j.Logger;

public class HttpResponseCookie {
    protected static final int MAX_AGE = 604800;
    private static final Logger log = Logger.getLogger(HttpResponseCookie.class);
    private final String name;
    private final String value;
    private final String path;
    private final Date expires;

    public HttpResponseCookie(String name, String value) {
        this(name, value, new Date(new Date().getTime() + 604800000L), "/");
    }

    public HttpResponseCookie(String name, String value, Date expires, String path) {
        this.name = name;
        this.value = value;
        this.expires = expires;
        this.path = path;
    }

    public String toString() {
        SimpleDateFormat formatter = new SimpleDateFormat("EEE, dd-MMM-yyyy HH:mm:ss 'GMT'");
        return Utils.URLEncode(this.name) + "=" + Utils.URLEncode(this.value) + "; " + "Path=" + this.path + "; " + "Expires=" + formatter.format(this.expires) + "; " + "Version=1; " + "Max-Age=" + 604800 + "; ";
    }

    public String getName() {
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public boolean equals(HttpResponseCookie cookie) {
        return cookie.getName().equals(this.name);
    }
}

