/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web;

import com.pugh.sockso.Utils;
import com.pugh.sockso.db.Database;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.apache.log4j.Logger;

public class User {
    private static final Logger log = Logger.getLogger(User.class);
    private final int sessionId;
    private final String name;
    private final String pass;
    private final String email;
    private final String sessionCode;
    private int id;

    public User(int id, String name) {
        this(id, name, "", "");
    }

    public User(String name, String pass, String email) {
        this(-1, name, pass, email, -1, "");
    }

    public User(int id, String name, String email) {
        this(id, name, "", email, -1, "");
    }

    public User(int id, String name, String pass, String email) {
        this(id, name, pass, email, -1, "");
    }

    public User(int id, String name, String pass, String email, int sessionId, String sessionCode) {
        this.id = id;
        this.name = name;
        this.pass = pass;
        this.email = email;
        this.sessionId = sessionId;
        this.sessionCode = sessionCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save(Database db) throws SQLException {
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            String sql = " insert into users ( name, pass, email, date_created )  values ( ?, ?, ?, current_timestamp ) ";
            st = db.prepare(sql);
            st.setString(1, this.name);
            st.setString(2, Utils.md5(this.pass));
            st.setString(3, this.email);
            st.executeUpdate();
            Utils.close(st);
            sql = " select max(id) as new_id  from users ";
            st = db.prepare(sql);
            rs = st.executeQuery();
            if (!rs.next()) {
                throw new SQLException("No results returned from aggregate query");
            }
            this.id = rs.getInt("new_id");
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
    }

    public int getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getEmail() {
        return this.email;
    }

    public int getSessionId() {
        return this.sessionId;
    }

    public String getSessionCode() {
        return this.sessionCode;
    }
}

