/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.music.Track;
import com.pugh.sockso.templates.web.TFlexPlayer;
import com.pugh.sockso.templates.web.TJsPlayer;
import com.pugh.sockso.templates.web.TXspfPlayer;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.action.WebAction;
import com.pugh.sockso.web.action.playlist.XspfPlayer;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Player
extends WebAction {
    @Override
    public void handleRequest() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        String[] playArgs = req.getPlayParams(true);
        String type = req.getUrlParam(1);
        if (type.equals("js")) {
            this.showJsPlayer(req.getUrlParam(2).equals("random") ? this.getRandomTracks() : Track.getTracksFromPlayArgs(this.getDatabase(), playArgs));
        } else {
            String extraArgs = "";
            if (req.hasArgument("orderBy")) {
                extraArgs = extraArgs + "&orderBy=" + req.getArgument("orderBy");
            }
            this.showXspfPlayer(this.getXspfPlayer(), extraArgs, playArgs);
        }
    }

    protected void showJsPlayer(Vector<Track> tracks) throws IOException, SQLException, BadRequestException {
        TJsPlayer tpl = new TJsPlayer();
        tpl.setTracks(tracks);
        tpl.setProperties(this.getProperties());
        this.getResponse().showHtml(tpl.makeRenderer());
    }

    protected void showXspfPlayer(XspfPlayer tpl, String extraArgs, String[] playArgs) throws IOException {
        tpl.setProperties(this.getProperties());
        tpl.setExtraArgs(extraArgs);
        tpl.setPlayArgs(playArgs);
        this.getResponse().showHtml(tpl.makeRenderer());
    }

    protected XspfPlayer getXspfPlayer() {
        Request req = this.getRequest();
        String player = req.getArgument("player");
        if (player.equals("flexPlayer")) {
            return new TFlexPlayer();
        }
        return new TXspfPlayer();
    }
}

