/*
 * Decompiled with CFR 0.152.
 */
package com.pugh.sockso.web.action;

import com.pugh.sockso.Properties;
import com.pugh.sockso.Utils;
import com.pugh.sockso.Validater;
import com.pugh.sockso.auth.Authenticator;
import com.pugh.sockso.db.Database;
import com.pugh.sockso.music.Track;
import com.pugh.sockso.resources.Locale;
import com.pugh.sockso.templates.web.users.TScrobbleLog;
import com.pugh.sockso.templates.web.users.TUserEdit;
import com.pugh.sockso.templates.web.users.TUserLogin;
import com.pugh.sockso.templates.web.users.TUserRegister;
import com.pugh.sockso.templates.web.users.TUserRegistered;
import com.pugh.sockso.templates.web.users.TUserUpdated;
import com.pugh.sockso.web.BadRequestException;
import com.pugh.sockso.web.Request;
import com.pugh.sockso.web.Response;
import com.pugh.sockso.web.Session;
import com.pugh.sockso.web.Submission;
import com.pugh.sockso.web.User;
import com.pugh.sockso.web.action.WebAction;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Vector;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Userer
extends WebAction {
    private static final Logger log = Logger.getLogger(Userer.class);
    private final Vector<Authenticator> authenticators = new Vector();

    @Override
    public void handleRequest() throws BadRequestException, IOException, SQLException {
        Request req = this.getRequest();
        String type = req.getUrlParam(1);
        if (type.equals("register")) {
            this.register();
        } else if (type.equals("login")) {
            this.login();
        } else if (type.equals("logout")) {
            this.logout();
        } else if (type.equals("edit")) {
            this.edit();
        } else if (type.equals("update")) {
            this.update();
        } else if (type.equals("scrobbleLog")) {
            this.scrobbleLog();
        } else {
            throw new BadRequestException("unknown command '" + type + "'", 400);
        }
    }

    public void addAuthenticator(Authenticator authenticator) {
        this.authenticators.add(authenticator);
    }

    protected void scrobbleLog() throws SQLException, IOException {
        User user = this.getUser();
        Vector<Track> tracks = this.getNonScrobbledTracks(user);
        this.markUsersTracksScrobbled(user);
        this.showScrobbleLog(tracks);
    }

    protected void showScrobbleLog(Vector<Track> tracks) throws IOException {
        TScrobbleLog tpl = new TScrobbleLog();
        Response res = this.getResponse();
        tpl.setTracks(tracks);
        res.addHeader("Content-Disposition", "inline; filename=\".scrobbler.log\"");
        res.showText(tpl.makeRenderer());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void markUsersTracksScrobbled(User user) throws SQLException {
        PreparedStatement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " update play_log  set scrobbled = 1  where user_id = ? ";
            st = db.prepare(" update play_log  set scrobbled = 1  where user_id = ? ");
            st.setInt(1, user.getId());
            st.executeUpdate();
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Vector<Track> getNonScrobbledTracks(User user) throws SQLException {
        Vector<Track> vector;
        PreparedStatement st = null;
        ResultSet rs = null;
        try {
            Database db = this.getDatabase();
            String sql = Utils.replaceAll("t.date_added", "l.date_played", Track.getSelectSql()) + " from play_log l " + " inner join tracks t " + " on t.id = l.track_id " + " inner join artists ar " + " on ar.id = t.artist_id " + " inner join albums al " + " on al.id = t.album_id " + " where l.user_id = ? " + " and l.scrobbled = 0 ";
            st = db.prepare(sql);
            st.setInt(1, user.getId());
            rs = st.executeQuery();
            vector = Track.createVectorFromResultSet(rs);
        }
        catch (Throwable throwable) {
            Utils.close(rs);
            Utils.close(st);
            throw throwable;
        }
        Utils.close(rs);
        Utils.close(st);
        return vector;
    }

    private void update() throws IOException, BadRequestException, SQLException {
        this.requireLogin();
        this.getUpdateSubmission().validate();
        this.updateUser();
        this.showUserUpdated();
    }

    protected void showUserUpdated() throws IOException, SQLException {
        TUserUpdated tpl = new TUserUpdated();
        this.getResponse().showHtml(tpl);
    }

    protected Submission getUpdateSubmission() {
        Submission s = new Submission(this.getRequest(), this.getLocale());
        s.addField("email", 2, "www.error.invalidEmail");
        s.addMatchingFields("pass1", "pass2", "www.error.passwordsDontMatch");
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void updateUser() throws SQLException {
        PreparedStatement st = null;
        try {
            User user = this.getUser();
            Request req = this.getRequest();
            Database db = this.getDatabase();
            String sql = " update users  set email = ?,  pass = ?  where id = ? ";
            st = db.prepare(" update users  set email = ?,  pass = ?  where id = ? ");
            st.setString(1, req.getArgument("email"));
            st.setString(2, Utils.md5(req.getArgument("pass1")));
            st.setInt(3, user.getId());
            st.execute();
        }
        catch (Throwable throwable) {
            Utils.close(st);
            throw throwable;
        }
        Utils.close(st);
    }

    protected void requireLogin() throws IOException {
        if (this.getUser() == null) {
            this.getResponse().redirect("/user/login");
        }
    }

    private void edit() throws IOException, SQLException {
        this.requireLogin();
        this.showUserEdit();
    }

    protected void showUserEdit() throws IOException, SQLException {
        TUserEdit tpl = new TUserEdit();
        this.getResponse().showHtml(tpl);
    }

    @Override
    public boolean requiresLogin() {
        return false;
    }

    public void register() throws IOException, BadRequestException, SQLException {
        Properties p = this.getProperties();
        Request req = this.getRequest();
        User user = this.getUser();
        Locale locale = this.getLocale();
        if (p.get("users.disableRegistration").equals("yes")) {
            throw new BadRequestException(locale.getString("www.error.registrationDisabled"), 403);
        }
        if (user != null) {
            throw new BadRequestException(locale.getString("www.error.alreadyLoggedIn"), 403);
        }
        String todo = req.getArgument("todo");
        if (todo.equals("register")) {
            this.registerUser();
        } else {
            this.showUserRegister();
        }
    }

    protected void showUserRegister() throws IOException, SQLException {
        TUserRegister tpl = new TUserRegister();
        this.getResponse().showHtml(tpl);
    }

    protected void registerUser() throws BadRequestException, SQLException, IOException {
        Request req = this.getRequest();
        Locale locale = this.getLocale();
        String name = req.getArgument("name").trim();
        String pass1 = req.getArgument("pass1");
        String pass2 = req.getArgument("pass2");
        String email = req.getArgument("email").trim();
        Database db = this.getDatabase();
        Validater v = new Validater(db);
        if (!v.checkRequiredFields(new String[]{name, pass1, email})) {
            throw new BadRequestException(locale.getString("www.error.missingField"));
        }
        if (!pass1.equals(pass2)) {
            throw new BadRequestException(locale.getString("www.error.passwordsDontMatch"));
        }
        if (!v.isValidEmail(email)) {
            throw new BadRequestException(locale.getString("www.error.invalidEmail"));
        }
        if (v.usernameExists(name)) {
            throw new BadRequestException(locale.getString("www.error.duplicateUsername"));
        }
        if (v.emailExists(email)) {
            throw new BadRequestException(locale.getString("www.error.duplicateEmail"));
        }
        User newUser = new User(-1, name, pass1, email);
        newUser.save(db);
        this.loginUser(name, pass1);
        this.showUserRegistered(newUser);
    }

    protected void showUserRegistered(User newUser) throws IOException, SQLException {
        TUserRegistered tpl = new TUserRegistered();
        Response res = this.getResponse();
        res.setUser(newUser);
        res.showHtml(tpl);
    }

    public void login() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        User user = this.getUser();
        Locale locale = this.getLocale();
        if (user != null) {
            throw new BadRequestException(locale.getString("www.error.alreadyLoggedIn"), 403);
        }
        String todo = req.getArgument("todo");
        if (todo.equals("login")) {
            this.loginUser();
        } else {
            this.showUserLogin();
        }
    }

    protected void showUserLogin() throws IOException, SQLException {
        TUserLogin tpl = new TUserLogin();
        this.getResponse().showHtml(tpl);
    }

    protected void loginUser() throws IOException, SQLException, BadRequestException {
        Request req = this.getRequest();
        Response res = this.getResponse();
        String name = req.getArgument("name");
        String pass = req.getArgument("pass");
        this.loginUser(name, pass);
        res.redirect("/");
    }

    protected void loginUser(String name, String pass) throws SQLException, BadRequestException {
        for (Authenticator auth : this.authenticators) {
            try {
                if (!auth.authenticate(name, pass)) continue;
                User user = this.findOrCreateUser(name, pass);
                Session sess = new Session(this.getDatabase(), this.getRequest(), this.getResponse());
                sess.create(user.getId());
                return;
            }
            catch (Exception e) {
                throw new BadRequestException(e.getMessage());
            }
        }
        throw new BadRequestException(this.getLocale().getString("www.error.passwordIncorrect"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public User findOrCreateUser(String name, String pass) throws SQLException {
        ResultSet rs = null;
        Statement st = null;
        try {
            Database db = this.getDatabase();
            String sql = " select id, name  from users  where name = ?  limit 1 ";
            st = db.prepare(" select id, name  from users  where name = ?  limit 1 ");
            st.setString(1, name);
            rs = st.executeQuery();
            if (rs.next()) {
                User user = new User(rs.getInt("id"), rs.getString("name"));
                return user;
            }
            User user = new User(name, pass, "");
            user.save(db);
            User user2 = user;
            return user2;
        }
        finally {
            st.close();
            rs.close();
        }
    }

    public void logout() throws IOException {
        Response res = this.getResponse();
        Session sess = new Session(null, null, res);
        sess.destroy();
        res.redirect("/");
    }
}

