/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ParseException;
import java.io.UnsupportedEncodingException;

class Parser {
    private byte[] in;
    private int start;
    private int stop;
    private int pos;
    private byte encoding;
    public static final byte ISO = 0;
    public static final byte UNICODE = 1;

    public Parser(byte[] in, boolean encoding) {
        this(in, encoding, 0, in.length - 1);
    }

    public Parser(byte[] in, boolean encoding, int start, int stop) {
        if (in.length == 0) {
            encoding = false;
        }
        this.in = in;
        this.start = start;
        this.pos = start;
        this.stop = stop > -1 ? stop : 0;
        if (encoding) {
            this.parseEncoding();
        } else {
            this.encoding = 0;
        }
    }

    public void setPosition(int pos) {
        this.pos = pos;
    }

    public int getPosition() {
        return this.pos;
    }

    public void parseEncoding() {
        this.encoding = this.in[this.pos];
        ++this.pos;
    }

    public String parseText() throws ParseException {
        return this.parseText(this.encoding);
    }

    /*
     * Unable to fully structure code
     */
    public String parseText(byte encoding) throws ParseException {
        try {
            block7: {
                term = this.pos;
                if (encoding != 0) ** GOTO lbl9
                while (term < this.stop && this.in[term] != 0) {
                    ++term;
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    ++term;
lbl9:
                    // 2 sources

                    ** while (term < this.stop - 1 && (this.in[term] != 0 || this.in[term + 1] != 0))
                }
lbl10:
                // 1 sources

                term += 2;
            }
            if (encoding == 0 && term == this.stop && this.in[term] != 0 || encoding == 1 && term == this.stop - 1 && (this.in[term] != 0 || this.in[term + 1] != 0)) {
                term = this.stop + 1;
            }
            ret = null;
            try {
                ret = new String(this.in, this.pos, term - this.pos, encoding == 0 ? "ISO8859_1" : "ISO8859_1");
            }
            catch (UnsupportedEncodingException var4_5) {
                // empty catch block
            }
            this.pos = term + (encoding == 0 ? 1 : 2);
            return ret;
        }
        catch (Exception e) {
            throw new ParseException();
        }
    }

    public byte[] parseBinary() throws ParseException {
        return this.parseBinary(this.stop - this.pos + 1);
    }

    public byte[] parseBinary(int number) throws ParseException {
        try {
            byte[] ret = new byte[number];
            System.arraycopy(this.in, this.pos, ret, 0, number);
            this.pos += number;
            return ret;
        }
        catch (Exception e) {
            throw new ParseException();
        }
    }
}

