/*
 * Decompiled with CFR 0.152.
 */
package joptsimple;

import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeSet;
import joptsimple.AbstractOptionSpec;
import joptsimple.AlternativeLongOptionSpec;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.NoArgumentOptionSpec;
import joptsimple.OptionSpecVisitor;
import joptsimple.OptionalArgumentOptionSpec;
import joptsimple.ParserRules;
import joptsimple.RequiredArgumentOptionSpec;
import joptsimple.internal.Classes;
import joptsimple.internal.ColumnarData;
import joptsimple.internal.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class HelpFormatter
implements OptionSpecVisitor {
    private final ColumnarData grid = new ColumnarData("Option", "Description");

    HelpFormatter() {
    }

    String format(Map<String, AbstractOptionSpec<?>> options) {
        if (options.isEmpty()) {
            return "No options specified";
        }
        this.grid.clear();
        Comparator comparator = new Comparator<AbstractOptionSpec<?>>(){

            @Override
            public int compare(AbstractOptionSpec<?> first, AbstractOptionSpec<?> second) {
                return first.options().iterator().next().compareTo(second.options().iterator().next());
            }
        };
        TreeSet sorted = new TreeSet(comparator);
        sorted.addAll(options.values());
        for (AbstractOptionSpec abstractOptionSpec : sorted) {
            abstractOptionSpec.accept(this);
        }
        return this.grid.format();
    }

    void addHelpLineFor(AbstractOptionSpec<?> spec, String additionalInfo) {
        this.grid.addRow(this.createOptionDisplay(spec) + additionalInfo, spec.description());
    }

    @Override
    public void visit(NoArgumentOptionSpec spec) {
        this.addHelpLineFor(spec, "");
    }

    @Override
    public void visit(RequiredArgumentOptionSpec<?> spec) {
        this.visit(spec, '<', '>');
    }

    @Override
    public void visit(OptionalArgumentOptionSpec<?> spec) {
        this.visit(spec, '[', ']');
    }

    @Override
    public void visit(AlternativeLongOptionSpec spec) {
        this.addHelpLineFor(spec, ' ' + Strings.surround(spec.argumentDescription(), '<', '>'));
    }

    private void visit(ArgumentAcceptingOptionSpec<?> spec, char begin, char end) {
        String argDescription = spec.argumentDescription();
        String typeIndicator = HelpFormatter.typeIndicator(spec);
        StringBuilder collector = new StringBuilder();
        if (typeIndicator.length() > 0) {
            collector.append(typeIndicator);
            if (argDescription.length() > 0) {
                collector.append(": ").append(argDescription);
            }
        } else if (argDescription.length() > 0) {
            collector.append(argDescription);
        }
        String helpLine = collector.length() == 0 ? "" : ' ' + Strings.surround(collector.toString(), begin, end);
        this.addHelpLineFor(spec, helpLine);
    }

    private String createOptionDisplay(AbstractOptionSpec<?> spec) {
        StringBuilder buffer = new StringBuilder();
        Iterator<String> iter = spec.options().iterator();
        while (iter.hasNext()) {
            String option = iter.next();
            buffer.append(option.length() > 1 ? "--" : ParserRules.HYPHEN);
            buffer.append(option);
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }

    private static String typeIndicator(ArgumentAcceptingOptionSpec<?> spec) {
        String indicator = spec.typeIndicator();
        return indicator == null || String.class.getName().equals(indicator) ? "" : Classes.shortNameOf(indicator);
    }
}

