/*
 * Decompiled with CFR 0.152.
 */
package org.dvb.dsmcc;

import java.io.File;
import java.io.InterruptedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.cert.X509Certificate;
import org.dvb.dsmcc.AsynchronousLoadingEventListener;
import org.dvb.dsmcc.DSMCCException;
import org.dvb.dsmcc.InsufficientResourcesException;
import org.dvb.dsmcc.InvalidFormatException;
import org.dvb.dsmcc.InvalidPathNameException;
import org.dvb.dsmcc.MPEGDeliveryException;
import org.dvb.dsmcc.NotEntitledException;
import org.dvb.dsmcc.NotLoadedException;
import org.dvb.dsmcc.NothingToAbortException;
import org.dvb.dsmcc.ObjectChangeEventListener;
import org.dvb.dsmcc.ServerDeliveryException;
import org.dvb.dsmcc.ServiceXFRException;
import org.dvb.dsmcc.SuccessEvent;
import org.videolan.Logger;

public class DSMCCObject
extends File {
    public static final int FROM_CACHE = 1;
    public static final int FROM_CACHE_OR_STREAM = 2;
    public static final int FROM_STREAM_ONLY = 3;
    public static final int FORCED_STATIC_CACHING = 4;
    private boolean loaded = false;
    private boolean stream = false;
    private boolean streamEvent = false;
    private static final long serialVersionUID = -6845145080873848152L;
    private static final Logger logger = Logger.getLogger(DSMCCObject.class.getName());

    public DSMCCObject(String path) {
        super(path);
    }

    public DSMCCObject(String path, String name) {
        super(path, name);
    }

    public DSMCCObject(DSMCCObject dir, String name) {
        super(dir.getPath(), name);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public boolean isStream() {
        return this.stream;
    }

    public boolean isStreamEvent() {
        return this.streamEvent;
    }

    public boolean isObjectKindKnown() {
        return true;
    }

    public void synchronousLoad() throws InvalidFormatException, InterruptedIOException, MPEGDeliveryException, ServerDeliveryException, InvalidPathNameException, NotEntitledException, ServiceXFRException, InsufficientResourcesException {
        if (!super.exists()) {
            throw new InvalidPathNameException();
        }
        this.loaded = true;
    }

    public void asynchronousLoad(AsynchronousLoadingEventListener listener) throws InvalidPathNameException {
        try {
            this.synchronousLoad();
            listener.receiveEvent(new SuccessEvent(this));
        }
        catch (DSMCCException e) {
        }
        catch (InterruptedIOException interruptedIOException) {
            // empty catch block
        }
    }

    public void abort() throws NothingToAbortException {
        throw new NothingToAbortException();
    }

    public static boolean prefetch(String path, byte priority) {
        return false;
    }

    public static boolean prefetch(DSMCCObject dir, String path, byte priority) {
        return false;
    }

    public void unload() throws NotLoadedException {
        if (this.loaded) {
            throw new NotLoadedException();
        }
        this.loaded = false;
    }

    public URL getURL() {
        String url = "file://" + super.getAbsolutePath();
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            logger.warning("Failed to make url " + url);
            e.printStackTrace();
            return null;
        }
    }

    public void addObjectChangeEventListener(ObjectChangeEventListener listener) throws InsufficientResourcesException {
        Logger.unimplemented(DSMCCObject.class.getName(), "addObjectChangeEventListener");
        throw new Error("Not implemented");
    }

    public void removeObjectChangeEventListener(ObjectChangeEventListener listener) {
        Logger.unimplemented(DSMCCObject.class.getName(), "removeObjectChangeEventListener");
        throw new Error("Not implemented");
    }

    public void loadDirectoryEntry(AsynchronousLoadingEventListener listener) throws InvalidPathNameException {
        if (!super.exists()) {
            throw new InvalidPathNameException();
        }
        listener.receiveEvent(new SuccessEvent(this));
    }

    public void setRetrievalMode(int retrieval_mode) {
        Logger.unimplemented(DSMCCObject.class.getName(), "setRetrievalMode");
        throw new Error("Not implemented");
    }

    public X509Certificate[][] getSigners() {
        Logger.unimplemented(DSMCCObject.class.getName(), "getSigners");
        throw new Error("Not implemented");
    }

    public X509Certificate[][] getSigners(boolean known_root) throws InvalidFormatException, InterruptedIOException, MPEGDeliveryException, ServerDeliveryException, InvalidPathNameException, NotEntitledException, ServiceXFRException, InsufficientResourcesException {
        Logger.unimplemented(DSMCCObject.class.getName(), "getSigners");
        throw new Error("Not implemented");
    }
}

